/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.wands;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISpellContainer {
    public static final int NO_SPELL_SELECTED = -1;
    public static final int OTHER_HAND_SELECTED = -2;

    @NotNull
    default public List<SpellPackage> getSpells(@Nullable ItemStack stack) {
        return stack == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)((Collection)stack.getOrDefault(DataComponentsPM.SPELL_PACKAGE_LIST.get(), (Object)ImmutableList.of())));
    }

    default public int getSpellCount(@Nullable ItemStack stack) {
        if (stack != null) {
            return ((List)stack.getOrDefault(DataComponentsPM.SPELL_PACKAGE_LIST.get(), (Object)ImmutableList.of())).size();
        }
        return 0;
    }

    public Component getSpellCapacityText(@Nullable ItemStack var1);

    default public int getActiveSpellIndex(@Nullable ItemStack stack) {
        return stack == null ? -1 : (Integer)stack.getOrDefault(DataComponentsPM.ACTIVE_SPELL_INDEX.get(), (Object)-1);
    }

    @Nullable
    default public SpellPackage getActiveSpell(@Nullable ItemStack stack) {
        SpellPackage retVal = null;
        if (stack != null) {
            List spellList = (List)stack.get(DataComponentsPM.SPELL_PACKAGE_LIST.get());
            int index = this.getActiveSpellIndex(stack);
            if (spellList != null && index >= 0 && index < spellList.size()) {
                retVal = (SpellPackage)spellList.get(index);
            }
        }
        return retVal;
    }

    default public boolean setActiveSpellIndex(@Nullable ItemStack stack, int index) {
        if (stack == null) {
            return false;
        }
        if (index == -1 || index == -2 || index >= 0 && index < this.getSpells(stack).size()) {
            stack.set(DataComponentsPM.ACTIVE_SPELL_INDEX.get(), (Object)index);
            return true;
        }
        return false;
    }

    public boolean canAddSpell(@Nullable ItemStack var1, @Nullable SpellPackage var2);

    default public boolean addSpell(@Nullable ItemStack stack, @Nullable SpellPackage spell) {
        if (stack != null && spell != null && this.canAddSpell(stack, spell)) {
            stack.set(DataComponentsPM.SPELL_PACKAGE_LIST.get(), (Object)ImmutableList.builder().addAll(this.getSpells(stack)).add((Object)spell).build());
            return true;
        }
        return false;
    }

    default public void clearSpells(@Nullable ItemStack stack) {
        if (stack != null) {
            stack.remove(DataComponentsPM.SPELL_PACKAGE_LIST.get());
            stack.remove(DataComponentsPM.ACTIVE_SPELL_INDEX.get());
        }
    }
}

