/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.wands;

import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentHelperPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.armor.IManaDiscountGear;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.wands.ManaManager;
import java.text.DecimalFormat;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IManaContainer {
    public static final int INFINITE_MANA = -1;
    public static final DecimalFormat FRACTIONAL_MANA_FORMATTER = new DecimalFormat("######0.00");
    public static final DecimalFormat WHOLE_MANA_FORMATTER = new DecimalFormat("#######");

    public ManaStorage getManaStorage(ItemStack var1);

    default public int getMana(@Nullable ItemStack stack, @Nullable Source source) {
        if (this.getMaxMana(stack, source) == -1) {
            return -1;
        }
        int retVal = 0;
        if (stack != null && source != null) {
            retVal = this.getManaStorage(stack).getManaStored(source);
        }
        return retVal;
    }

    default public MutableComponent getManaText(@Nullable ItemStack stack, @Nullable Source source, boolean truncate) {
        int mana = this.getMana(stack, source);
        if (mana == -1) {
            return Component.literal((String)Character.toString('\u221e'));
        }
        double wholeMana = (double)mana / 100.0;
        double toDisplay = truncate ? (double)((int)wholeMana) : wholeMana;
        DecimalFormat formatter = toDisplay == (double)((int)toDisplay) ? WHOLE_MANA_FORMATTER : FRACTIONAL_MANA_FORMATTER;
        return Component.literal((String)formatter.format(toDisplay));
    }

    @NotNull
    default public SourceList getAllMana(@Nullable ItemStack stack) {
        SourceList retVal = SourceList.EMPTY;
        SourceList stored = this.getManaStorage(stack).getAllManaStored();
        for (Source source : Sources.getAllSorted()) {
            if (this.getMaxMana(stack, source) == -1) {
                retVal = retVal.set(source, -1);
                continue;
            }
            retVal = retVal.merge(source, stored.getAmount(source));
        }
        return retVal;
    }

    public int getMaxMana(@Nullable ItemStack var1, @Nullable Source var2);

    default public MutableComponent getMaxManaText(@Nullable ItemStack stack, @Nullable Source source) {
        int mana;
        int n = mana = stack == null || source == null ? 0 : this.getMaxMana(stack, source);
        if (mana == -1) {
            return Component.literal((String)Character.toString('\u221e'));
        }
        return Component.literal((String)WHOLE_MANA_FORMATTER.format((double)mana / 100.0));
    }

    public void setMana(@NotNull ItemStack var1, @NotNull Source var2, int var3);

    default public int addMana(ItemStack stack, Source source, int amount) {
        return this.addMana(stack, source, amount, this.getMaxMana(stack, source));
    }

    default public int addMana(@Nullable ItemStack stack, @Nullable Source source, int amount, int max) {
        if (stack == null || source == null || this.getMaxMana(stack, source) == -1) {
            return 0;
        }
        int current = this.getMana(stack, source);
        int toStore = current + amount;
        int leftover = Mth.clamp((int)(toStore - max), (int)0, (int)amount);
        this.setMana(stack, source, Math.max(current, Math.min(toStore, max)));
        return leftover;
    }

    default public int deductMana(@Nullable ItemStack stack, @Nullable Source source, int amount) {
        if (stack == null || source == null) {
            return amount;
        }
        if (this.getMaxMana(stack, source) == -1) {
            return 0;
        }
        int toStore = this.getMana(stack, source) - amount;
        int leftover = Mth.clamp((int)(-toStore), (int)0, (int)amount);
        this.setMana(stack, source, Math.max(toStore, 0));
        return leftover;
    }

    default public boolean consumeMana(ItemStack stack, Player player, Source source, int amount, HolderLookup.Provider registries) {
        if (stack == null || source == null) {
            return false;
        }
        if (this.containsMana(stack, player, source, amount, registries)) {
            if (this.getMaxMana(stack, source) != -1) {
                this.setMana(stack, source, this.getMana(stack, source) - (amount == 0 ? 0 : Math.max(1, this.getModifiedCost(stack, player, source, amount, registries))));
            }
            if (player != null) {
                ManaManager.recordManaConsumptionSideEffects(player, source, amount);
            }
            return true;
        }
        return false;
    }

    default public boolean consumeMana(ItemStack stack, Player player, SourceList sources, HolderLookup.Provider registries) {
        if (stack == null || sources == null) {
            return false;
        }
        if (this.containsMana(stack, player, sources, registries)) {
            SourceList.Builder deltaBuilder = SourceList.builder();
            for (Source source : sources.getSources()) {
                int amount = sources.getAmount(source);
                int realAmount = amount / 100;
                if (this.getMaxMana(stack, source) != -1) {
                    this.setMana(stack, source, this.getMana(stack, source) - this.getModifiedCost(stack, player, source, amount, registries));
                }
                if (player != null) {
                    StatsManager.incrementValue(player, StatsPM.MANA_SPENT_TOTAL, realAmount);
                    StatsManager.incrementValue(player, source.getManaSpentStat(), realAmount);
                }
                deltaBuilder.with(source, Mth.floor((double)Math.sqrt(realAmount)));
            }
            SourceList attunementDeltas = deltaBuilder.build();
            if (player != null && !attunementDeltas.isEmpty()) {
                AttunementManager.incrementAttunement(player, AttunementType.TEMPORARY, attunementDeltas);
            }
            return true;
        }
        return false;
    }

    default public boolean removeManaRaw(ItemStack stack, Source source, int amount) {
        if (stack == null || source == null) {
            return false;
        }
        if (this.containsManaRaw(stack, source, amount)) {
            if (this.getMaxMana(stack, source) != -1) {
                this.setMana(stack, source, this.getMana(stack, source) - (amount == 0 ? 0 : Math.max(1, amount)));
            }
            return true;
        }
        return false;
    }

    default public boolean containsMana(ItemStack stack, Player player, Source source, int amount, HolderLookup.Provider registries) {
        return this.getMaxMana(stack, source) == -1 || this.getMana(stack, source) >= this.getModifiedCost(stack, player, source, amount, registries);
    }

    default public boolean containsMana(@Nullable ItemStack stack, @Nullable Player player, @Nullable SourceList sources, HolderLookup.Provider registries) {
        for (Source source : sources.getSources()) {
            if (this.containsMana(stack, player, source, sources.getAmount(source), registries)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsManaRaw(@Nullable ItemStack stack, @Nullable Source source, int amount) {
        return this.getMaxMana(stack, source) == -1 || this.getMana(stack, source) >= amount;
    }

    public int getBaseCostModifier(@Nullable ItemStack var1);

    default public int getTotalCostModifier(ItemStack stack, @Nullable Player player, Source source, HolderLookup.Provider registries) {
        int modifier = this.getBaseCostModifier(stack);
        if (player != null) {
            int gearDiscount = 0;
            for (ItemStack gearStack : player.getAllSlots()) {
                Item item = gearStack.getItem();
                if (item instanceof IManaDiscountGear) {
                    IManaDiscountGear discountItem = (IManaDiscountGear)item;
                    gearDiscount += discountItem.getManaDiscount(gearStack, player, source);
                }
                gearDiscount += 2 * EnchantmentHelperPM.getEnchantmentLevel(gearStack, EnchantmentsPM.MANA_EFFICIENCY, registries);
            }
            if (gearDiscount > 0) {
                modifier += gearDiscount;
            }
            if (AttunementManager.meetsThreshold(player, source, AttunementThreshold.MINOR)) {
                modifier += 5;
            }
            if (player.hasEffect(EffectsPM.MANAFRUIT.getHolder())) {
                modifier += 2 * player.getEffect(EffectsPM.MANAFRUIT.getHolder()).getAmplifier() + 1;
            }
            if (player.hasEffect(EffectsPM.MANA_IMPEDANCE.getHolder())) {
                modifier -= 5 * (player.getEffect(EffectsPM.MANA_IMPEDANCE.getHolder()).getAmplifier() + 1);
            }
        }
        return modifier;
    }

    default public int getModifiedCost(@Nullable ItemStack stack, @Nullable Player player, @Nullable Source source, int baseCost, HolderLookup.Provider registries) {
        return (int)Math.floor((double)baseCost / (1.0 + (double)this.getTotalCostModifier(stack, player, source, registries) / 100.0));
    }

    default public SourceList getModifiedCost(@Nullable ItemStack stack, @Nullable Player player, SourceList baseCost, HolderLookup.Provider registries) {
        SourceList retVal = SourceList.EMPTY;
        for (Source s : baseCost.getSources()) {
            retVal = retVal.set(s, this.getModifiedCost(stack, player, s, baseCost.getAmount(s), registries));
        }
        return retVal;
    }
}

