/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class RecipeContainerWrapper
implements Container {
    protected final IItemHandlerModifiable inv;

    public RecipeContainerWrapper(IItemHandlerModifiable inv) {
        this.inv = inv;
    }

    public int getContainerSize() {
        return this.inv.getSlots();
    }

    public boolean isEmpty() {
        for (int index = 0; index < this.inv.getSlots(); ++index) {
            if (this.inv.getStackInSlot(index).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return this.inv.getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot, int count) {
        ItemStack stack = this.inv.getStackInSlot(slot);
        return stack.isEmpty() ? ItemStack.EMPTY : stack.split(count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack s = this.getItem(index);
        if (s.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.setItem(index, ItemStack.EMPTY);
        return s;
    }

    public void setItem(int slot, ItemStack stack) {
        this.inv.setStackInSlot(slot, stack);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return false;
    }

    public void clearContent() {
        for (int index = 0; index < this.inv.getSlots(); ++index) {
            this.inv.setStackInSlot(index, ItemStack.EMPTY);
        }
    }
}

