/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RayTraceUtils {
    @Nullable
    public static HitResult getMouseOver(Level level, Player player) {
        AABB aabb;
        Minecraft mc = Minecraft.getInstance();
        Entity viewEntity = mc.getCameraEntity();
        double reachDistance = player.blockInteractionRange();
        Vec3 eyePos = viewEntity.getEyePosition(1.0f);
        double sqReachDistance = mc.hitResult != null ? mc.hitResult.getLocation().distanceToSqr(eyePos) : reachDistance * reachDistance;
        Vec3 lookVector = viewEntity.getViewVector(1.0f);
        Vec3 reachPos = eyePos.add(lookVector.scale(reachDistance));
        EntityHitResult entityResult = RayTraceUtils.rayTraceEntities(level, viewEntity, eyePos, reachPos, aabb = viewEntity.getBoundingBox().expandTowards(lookVector.scale(reachDistance)).inflate(1.0, 1.0, 1.0), testEntity -> !testEntity.isSpectator(), sqReachDistance);
        if (entityResult != null) {
            return entityResult;
        }
        return mc.hitResult;
    }

    @Nullable
    public static EntityHitResult rayTraceEntities(@Nonnull Level world, @Nullable Entity excludeEntity, @Nonnull Vec3 startVec, @Nonnull Vec3 endVec, @Nonnull AABB aabb, @Nullable Predicate<Entity> selector, double maxSqDistance) {
        double sqDistThreshold = maxSqDistance;
        Entity hitEntity = null;
        Vec3 hitVec = null;
        for (Entity entity : world.getEntities(excludeEntity, aabb, selector)) {
            double sqDist;
            AABB entityAABB = entity.getBoundingBox().inflate(0.3);
            Optional optionalHitVec = entityAABB.clip(startVec, endVec);
            if (!optionalHitVec.isPresent() || !((sqDist = startVec.distanceToSqr((Vec3)optionalHitVec.get())) < sqDistThreshold)) continue;
            hitEntity = entity;
            hitVec = (Vec3)optionalHitVec.get();
        }
        if (hitEntity == null || hitVec == null) {
            return null;
        }
        return new EntityHitResult(hitEntity, hitVec);
    }

    @Nullable
    public static BlockHitResult getBlockResultFromEntityResult(@Nullable EntityHitResult entityResult) {
        if (entityResult == null) {
            return null;
        }
        BlockPos targetPos = BlockPos.containing((Position)entityResult.getLocation());
        Vec3 entityVec = entityResult.getEntity().position();
        BlockPos entityPos = BlockPos.containing((Position)entityVec);
        Vec3 targetVec = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5);
        Vec3 dirVec = entityVec.subtract(targetVec);
        Direction dir = Direction.getNearest((double)dirVec.x, (double)dirVec.y, (double)dirVec.z);
        return new BlockHitResult(entityResult.getLocation(), dir, entityPos, false);
    }

    public static boolean hasLineOfSight(@Nullable Entity source, @Nullable BlockPos target) {
        if (source == null || target == null) {
            return false;
        }
        Vec3 sourceVec = source.getEyePosition();
        Vec3 targetVec = Vec3.atCenterOf((Vec3i)target);
        ClipContext context = new ClipContext(sourceVec, targetVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, source);
        BlockHitResult result = source.level().clip(context);
        if (result == null || result.getType() == HitResult.Type.MISS) {
            return true;
        }
        if (result.getType() == HitResult.Type.BLOCK) {
            return target.equals((Object)result.getBlockPos());
        }
        return false;
    }

    public static boolean hasLineOfSight(@Nullable Level world, @Nullable BlockPos source, @Nullable BlockPos target) {
        Vec3 endVec;
        if (world == null || source == null || target == null) {
            return false;
        }
        Vec3 startVec = new Vec3((double)source.getX() + 0.5, (double)source.getY() + 0.5, (double)source.getZ() + 0.5);
        EntitylessRayTraceContext context = new EntitylessRayTraceContext((BlockGetter)world, startVec, endVec = new Vec3((double)target.getX() + 0.5, (double)target.getY() + 0.5, (double)target.getZ() + 0.5), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY);
        BlockHitResult result = RayTraceUtils.rayTraceBlocksIgnoringSource(context);
        if (result == null || result.getType() == HitResult.Type.MISS) {
            return true;
        }
        if (result.getType() == HitResult.Type.BLOCK) {
            return target.equals((Object)result.getBlockPos());
        }
        return false;
    }

    protected static BlockHitResult rayTraceBlocksIgnoringSource(EntitylessRayTraceContext context) {
        return RayTraceUtils.iterateRayTrace(context, RayTraceUtils::doRayTraceCheck, RayTraceUtils::createMiss);
    }

    protected static BlockHitResult doRayTraceCheck(EntitylessRayTraceContext context, BlockPos pos) {
        BlockGetter world = context.getWorld();
        BlockState blockState = world.getBlockState(pos);
        FluidState fluidState = world.getFluidState(pos);
        Vec3 startVec = context.getStartVec();
        Vec3 endVec = context.getEndVec();
        VoxelShape blockShape = context.getBlockShape(blockState, world, pos);
        BlockHitResult blockResult = RayTraceUtils.doCollisionCheck(world, startVec, endVec, pos, blockShape, blockState);
        VoxelShape fluidShape = context.getFluidShape(fluidState, world, pos);
        BlockHitResult fluidResult = fluidShape.clip(startVec, endVec, pos);
        double blockDistanceSq = blockResult == null ? Double.MAX_VALUE : startVec.distanceToSqr(blockResult.getLocation());
        double fluidDistanceSq = fluidResult == null ? Double.MAX_VALUE : startVec.distanceToSqr(fluidResult.getLocation());
        return blockDistanceSq <= fluidDistanceSq ? blockResult : fluidResult;
    }

    protected static BlockHitResult createMiss(EntitylessRayTraceContext context) {
        Vec3 endVec = context.getEndVec();
        Vec3 delta = context.getStartVec().subtract(endVec);
        return BlockHitResult.miss((Vec3)endVec, (Direction)Direction.getNearest((double)delta.x, (double)delta.y, (double)delta.z), (BlockPos)BlockPos.containing((Position)endVec));
    }

    @Nullable
    protected static BlockHitResult doCollisionCheck(BlockGetter world, Vec3 startVec, Vec3 endVec, BlockPos iteratedPos, VoxelShape iteratedShape, BlockState iteratedState) {
        BlockHitResult faceResult;
        BlockHitResult result = iteratedShape.clip(startVec, endVec, iteratedPos);
        if (result != null && (faceResult = iteratedState.getInteractionShape(world, iteratedPos).clip(startVec, endVec, iteratedPos)) != null && faceResult.getLocation().subtract(startVec).lengthSqr() < result.getLocation().subtract(startVec).lengthSqr()) {
            return result.withDirection(faceResult.getDirection());
        }
        return result;
    }

    protected static BlockHitResult iterateRayTrace(EntitylessRayTraceContext context, BiFunction<EntitylessRayTraceContext, BlockPos, BlockHitResult> checkFunc, Function<EntitylessRayTraceContext, BlockHitResult> missFunc) {
        Vec3 endVec;
        Vec3 startVec = context.getStartVec();
        if (startVec.equals((Object)(endVec = context.getEndVec()))) {
            return missFunc.apply(context);
        }
        double adjEndX = Mth.lerp((double)-1.0E-7, (double)endVec.x, (double)startVec.x);
        double adjEndY = Mth.lerp((double)-1.0E-7, (double)endVec.y, (double)startVec.y);
        double adjEndZ = Mth.lerp((double)-1.0E-7, (double)endVec.z, (double)startVec.z);
        double adjStartX = Mth.lerp((double)-1.0E-7, (double)startVec.x, (double)endVec.x);
        double adjStartY = Mth.lerp((double)-1.0E-7, (double)startVec.y, (double)endVec.y);
        double adjStartZ = Mth.lerp((double)-1.0E-7, (double)startVec.z, (double)endVec.z);
        int adjStartXFloor = Mth.floor((double)adjStartX);
        int adjStartYFloor = Mth.floor((double)adjStartY);
        int adjStartZFloor = Mth.floor((double)adjStartZ);
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos(adjStartXFloor, adjStartYFloor, adjStartZFloor);
        double deltaX = adjEndX - adjStartX;
        double deltaY = adjEndY - adjStartY;
        double deltaZ = adjEndZ - adjStartZ;
        int signDeltaX = Mth.sign((double)deltaX);
        int signDeltaY = Mth.sign((double)deltaY);
        int signDeltaZ = Mth.sign((double)deltaZ);
        double d9 = signDeltaX == 0 ? Double.MAX_VALUE : (double)signDeltaX / deltaX;
        double d10 = signDeltaY == 0 ? Double.MAX_VALUE : (double)signDeltaY / deltaY;
        double d11 = signDeltaZ == 0 ? Double.MAX_VALUE : (double)signDeltaZ / deltaZ;
        double d12 = d9 * (signDeltaX > 0 ? 1.0 - Mth.frac((double)adjStartX) : Mth.frac((double)adjStartX));
        double d13 = d10 * (signDeltaY > 0 ? 1.0 - Mth.frac((double)adjStartY) : Mth.frac((double)adjStartY));
        double d14 = d11 * (signDeltaZ > 0 ? 1.0 - Mth.frac((double)adjStartZ) : Mth.frac((double)adjStartZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            BlockHitResult result;
            if (d12 < d13) {
                if (d12 < d14) {
                    adjStartXFloor += signDeltaX;
                    d12 += d9;
                } else {
                    adjStartZFloor += signDeltaZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                adjStartYFloor += signDeltaY;
                d13 += d10;
            } else {
                adjStartZFloor += signDeltaZ;
                d14 += d11;
            }
            if ((result = checkFunc.apply(context, (BlockPos)mbp.set(adjStartXFloor, adjStartYFloor, adjStartZFloor))) == null) continue;
            return result;
        }
        return missFunc.apply(context);
    }

    protected static class EntitylessRayTraceContext {
        private final BlockGetter world;
        private final Vec3 startVec;
        private final Vec3 endVec;
        private final ClipContext.Block blockMode;
        private final ClipContext.Fluid fluidMode;

        public EntitylessRayTraceContext(BlockGetter world, Vec3 startVec, Vec3 endVec, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
            this.world = world;
            this.startVec = startVec;
            this.endVec = endVec;
            this.blockMode = blockMode;
            this.fluidMode = fluidMode;
        }

        public BlockGetter getWorld() {
            return this.world;
        }

        public Vec3 getStartVec() {
            return this.startVec;
        }

        public Vec3 getEndVec() {
            return this.endVec;
        }

        public VoxelShape getBlockShape(BlockState state, BlockGetter world, BlockPos pos) {
            return this.blockMode.get(state, world, pos, CollisionContext.empty());
        }

        public VoxelShape getFluidShape(FluidState state, BlockGetter world, BlockPos pos) {
            return this.fluidMode.canPick(state) ? state.getShape(world, pos) : Shapes.empty();
        }
    }
}

