/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import net.minecraft.world.entity.player.Player;

public class PlayerUtils {
    public static int getXpNeededForNextLevel(int currentLevel) {
        if (currentLevel >= 30) {
            return 112 + (currentLevel - 30) * 9;
        }
        return currentLevel >= 15 ? 37 + (currentLevel - 15) * 5 : 7 + currentLevel * 2;
    }

    public static int getCumulativeXpNeededForLevel(int targetLevel) {
        int retVal = 0;
        for (int level = 0; level < targetLevel; ++level) {
            retVal += PlayerUtils.getXpNeededForNextLevel(level);
        }
        return retVal;
    }

    public static boolean canAffordXp(Player player, int pointCost) {
        double xpForProgress;
        int xpForLevel = PlayerUtils.getCumulativeXpNeededForLevel(player.experienceLevel);
        return (double)xpForLevel + (xpForProgress = Math.floor(player.experienceProgress * (float)PlayerUtils.getXpNeededForNextLevel(player.experienceLevel))) >= (double)pointCost;
    }
}

