/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import javax.annotation.Nonnull;
import net.minecraft.world.phys.Vec3;

public class LineSegment {
    protected Vec3 start;
    protected Vec3 end;

    public LineSegment(Vec3 start, Vec3 end) {
        this.start = start;
        this.end = end;
    }

    public Vec3 getStart() {
        return this.start;
    }

    public Vec3 getEnd() {
        return this.end;
    }

    public Vec3 getMiddle() {
        double x = (this.start.x + this.end.x) / 2.0;
        double y = (this.start.y + this.end.y) / 2.0;
        double z = (this.start.z + this.end.z) / 2.0;
        return new Vec3(x, y, z);
    }

    public Vec3 getDelta() {
        return this.end.subtract(this.start);
    }

    public void perturb(@Nonnull Vec3 perturbStart, @Nonnull Vec3 perturbEnd) {
        this.start = this.start.add(perturbStart);
        this.end = this.end.add(perturbEnd);
    }
}

