/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class JsonUtils {
    @Nonnull
    public static List<String> toStrings(@Nonnull JsonArray jsonArray) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (JsonElement element : jsonArray) {
            try {
                retVal.add(element.getAsString());
            }
            catch (Exception exception) {}
        }
        return retVal;
    }

    @Nonnull
    public static List<ResourceLocation> toResourceLocations(@Nonnull JsonArray jsonArray) {
        ArrayList<ResourceLocation> retVal = new ArrayList<ResourceLocation>();
        for (JsonElement element : jsonArray) {
            try {
                retVal.add(ResourceLocation.parse((String)element.getAsString()));
            }
            catch (Exception exception) {}
        }
        return retVal;
    }

    @Nonnull
    public static SourceList toSourceList(@Nonnull JsonObject jsonObject) {
        SourceList.Builder retVal = SourceList.builder();
        for (Source source : Sources.getAllSorted()) {
            retVal.with(source, GsonHelper.getAsInt((JsonObject)jsonObject, (String)source.getId().toString(), (int)0));
        }
        return retVal.build();
    }
}

