/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemUtils {
    protected static final Logger LOGGER = LogManager.getLogger();

    public static int getHashCode(@Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return 0;
        }
        ItemStack temp = stack.copyWithCount(1);
        return Objects.hash(Services.ITEMS_REGISTRY.getKey(temp.getItem()), temp.getComponents());
    }

    @Nonnull
    public static List<ItemStack> copyItemStackList(List<ItemStack> list) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack stack : list) {
            output.add(stack.copy());
        }
        return output;
    }

    @Nonnull
    public static List<ItemStack> mergeItemStackIntoList(@Nonnull List<ItemStack> list, @Nonnull ItemStack stackToCopy) {
        List<ItemStack> output = ItemUtils.copyItemStackList(list);
        ItemStack stack = stackToCopy.copy();
        for (ItemStack outStack : output) {
            if (!ItemStack.isSameItem((ItemStack)outStack, (ItemStack)stack)) continue;
            if (stack.getCount() + outStack.getCount() <= outStack.getMaxStackSize()) {
                outStack.grow(stack.getCount());
                return output;
            }
            int toGrow = outStack.getMaxStackSize() - outStack.getCount();
            outStack.grow(toGrow);
            stack.shrink(toGrow);
        }
        for (int index = 0; index < output.size(); ++index) {
            if (!output.get(index).isEmpty()) continue;
            output.set(index, stack);
            return output;
        }
        output.add(stack);
        return output;
    }

    @Nonnull
    public static List<ItemStack> mergeItemStackLists(@Nonnull List<ItemStack> list1, @Nonnull List<ItemStack> list2) {
        List<ItemStack> output = ItemUtils.copyItemStackList(list1);
        for (ItemStack stack : list2) {
            output = ItemUtils.mergeItemStackIntoList(output, stack);
        }
        return output;
    }
}

