/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.platform.Services;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class InventoryUtils {
    public static boolean isPlayerCarrying(@Nullable Player player, @Nullable ItemStack stack, boolean matchNBT) {
        if (player == null) {
            return false;
        }
        if (stack == null || stack.isEmpty()) {
            return true;
        }
        int count = stack.getCount();
        for (ItemStack searchStack : player.getInventory().items) {
            boolean areEqual = matchNBT ? ItemStack.matches((ItemStack)stack, (ItemStack)searchStack) : ItemStack.isSameItem((ItemStack)stack, (ItemStack)searchStack);
            if (!areEqual || (count -= searchStack.getCount()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerCarrying(@Nullable Player player, @Nullable ItemStack stack) {
        return InventoryUtils.isPlayerCarrying(player, stack, false);
    }

    public static boolean isPlayerCarrying(@Nullable Player player, @Nonnull Item item) {
        return InventoryUtils.isPlayerCarrying(player, new ItemStack((ItemLike)item));
    }

    public static boolean isPlayerCarrying(@Nullable Player player, @Nullable TagKey<Item> tag, int amount) {
        if (player == null) {
            return false;
        }
        if (tag == null) {
            return true;
        }
        for (ItemStack searchStack : player.getInventory().items) {
            if (searchStack.isEmpty() || !searchStack.is(tag) || (amount -= searchStack.getCount()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeItem(@Nullable Player player, @Nullable ItemStack stack, boolean matchNBT) {
        if (player == null) {
            return false;
        }
        if (stack == null || stack.isEmpty()) {
            return true;
        }
        if (!InventoryUtils.isPlayerCarrying(player, stack)) {
            return false;
        }
        int count = stack.getCount();
        for (int index = 0; index < player.getInventory().items.size(); ++index) {
            boolean areEqual;
            ItemStack searchStack = (ItemStack)player.getInventory().items.get(index);
            boolean bl = areEqual = matchNBT ? ItemStack.matches((ItemStack)stack, (ItemStack)searchStack) : ItemStack.isSameItem((ItemStack)stack, (ItemStack)searchStack);
            if (!areEqual) continue;
            if (searchStack.getCount() > count) {
                searchStack.shrink(count);
                count = 0;
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, index, searchStack));
                }
            } else {
                count -= searchStack.getCount();
                player.getInventory().items.set(index, (Object)ItemStack.EMPTY);
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, index, ItemStack.EMPTY));
                }
            }
            if (count > 0) continue;
            InventoryUtils.addRefundItem(stack, stack.getCount(), player);
            return true;
        }
        return false;
    }

    public static boolean consumeItem(@Nullable Player player, @Nullable ItemStack stack) {
        return InventoryUtils.consumeItem(player, stack, false);
    }

    public static boolean consumeItem(@Nullable Player player, @Nullable TagKey<Item> tag, int amount) {
        if (player == null) {
            return false;
        }
        if (tag == null || amount <= 0) {
            return true;
        }
        if (!InventoryUtils.isPlayerCarrying(player, tag, amount)) {
            return false;
        }
        for (int index = 0; index < player.getInventory().items.size(); ++index) {
            ItemStack searchStack = (ItemStack)player.getInventory().items.get(index);
            if (searchStack.isEmpty() || !searchStack.is(tag)) continue;
            if (searchStack.getCount() > amount) {
                InventoryUtils.addRefundItem(searchStack, amount, player);
                searchStack.shrink(amount);
                amount = 0;
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, index, searchStack));
                }
            } else {
                InventoryUtils.addRefundItem(searchStack, searchStack.getCount(), player);
                amount -= searchStack.getCount();
                player.getInventory().items.set(index, (Object)ItemStack.EMPTY);
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, index, ItemStack.EMPTY));
                }
            }
            if (amount > 0) continue;
            return true;
        }
        return false;
    }

    private static void addRefundItem(ItemStack stack, int refundCount, Player player) {
        ItemEntity entity;
        ItemStack refundStack = ItemStack.EMPTY;
        if (Services.ITEMS.hasCraftingRemainingItem(stack)) {
            refundStack = Services.ITEMS.getCraftingRemainingItem(stack).copyWithCount(refundCount);
        } else if (stack.is(Items.POTION)) {
            refundStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE, refundCount);
        } else if (stack.is((Item)ItemsPM.CONCOCTION.get())) {
            refundStack = new ItemStack((ItemLike)ItemsPM.SKYGLASS_FLASK.get(), refundCount);
        }
        if (!refundStack.isEmpty() && !player.addItem(refundStack) && (entity = player.drop(refundStack, false)) != null) {
            entity.setNoPickUpDelay();
            entity.setTarget(player.getUUID());
        }
    }

    @Nonnull
    public static NonNullList<ItemStack> find(@Nullable Player player, @Nullable ItemStack toFind, boolean matchNBT) {
        NonNullList retVal = NonNullList.create();
        if (player != null && toFind != null && !toFind.isEmpty()) {
            for (ItemStack searchStack : player.getInventory().items) {
                boolean areEqual = matchNBT ? ItemStack.matches((ItemStack)toFind, (ItemStack)searchStack) : ItemStack.isSameItem((ItemStack)toFind, (ItemStack)searchStack);
                if (!areEqual) continue;
                retVal.add((Object)searchStack);
            }
        }
        return retVal;
    }

    @Nonnull
    public static NonNullList<ItemStack> find(@Nullable Player player, @Nullable ItemStack toFind) {
        return InventoryUtils.find(player, toFind, false);
    }

    @Nonnull
    public static NonNullList<ItemStack> find(@Nullable Player player, @Nullable TagKey<Item> tag) {
        NonNullList retVal = NonNullList.create();
        if (player != null && tag != null) {
            for (ItemStack searchStack : player.getInventory().items) {
                if (searchStack.isEmpty() || !searchStack.is(tag)) continue;
                retVal.add((Object)searchStack);
            }
        }
        return retVal;
    }
}

