/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class FunctionUtils {
    public static <T, U, V, R> TriFunction<T, U, V, R> memoize(final TriFunction<T, U, V, R> pMemoTriFunction) {
        return new TriFunction<T, U, V, R>(){
            private final Map<Triple<T, U, V>, R> cache = new ConcurrentHashMap();

            public R apply(T arg1, U arg2, V arg3) {
                return this.cache.computeIfAbsent((Triple)ImmutableTriple.of(arg1, arg2, arg3), (Function)args -> pMemoTriFunction.apply(args.getLeft(), args.getMiddle(), args.getRight()));
            }

            public String toString() {
                return "memoize/3[function=" + String.valueOf(pMemoTriFunction) + ", size=" + this.cache.size() + "]";
            }
        };
    }
}

