/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.TeleportArrivalPacket;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityUtils {
    @Nonnull
    public static ItemStack getEntityItemStack(Entity entity) {
        ItemStack stack = ItemStack.EMPTY;
        if (entity instanceof ItemEntity) {
            stack = ((ItemEntity)entity).getItem();
        } else if (entity instanceof Boat) {
            stack = new ItemStack((ItemLike)((Boat)entity).getDropItem());
        } else if (entity.getType().equals(EntityType.ITEM_FRAME)) {
            stack = new ItemStack((ItemLike)Items.ITEM_FRAME);
        } else if (entity.getType().equals(EntityType.ARMOR_STAND)) {
            stack = new ItemStack((ItemLike)Items.ARMOR_STAND);
        } else if (entity.getType().equals(EntityType.MINECART)) {
            stack = new ItemStack((ItemLike)Items.MINECART);
        } else if (entity.getType().equals(EntityType.CHEST_MINECART)) {
            stack = new ItemStack((ItemLike)Items.CHEST_MINECART);
        } else if (entity.getType().equals(EntityType.FURNACE_MINECART)) {
            stack = new ItemStack((ItemLike)Items.FURNACE_MINECART);
        } else if (entity.getType().equals(EntityType.HOPPER_MINECART)) {
            stack = new ItemStack((ItemLike)Items.HOPPER_MINECART);
        } else if (entity.getType().equals(EntityType.TNT_MINECART)) {
            stack = new ItemStack((ItemLike)Items.TNT_MINECART);
        } else if (entity.getType().equals(EntityType.COMMAND_BLOCK_MINECART)) {
            stack = new ItemStack((ItemLike)Items.COMMAND_BLOCK_MINECART);
        } else if (entity.getType().equals(EntityType.END_CRYSTAL)) {
            stack = new ItemStack((ItemLike)Items.END_CRYSTAL);
        } else if (entity.getType().equals(EntityType.PAINTING)) {
            stack = new ItemStack((ItemLike)Items.PAINTING);
        }
        return stack;
    }

    public static <T extends Entity> List<T> getEntitiesInRange(@Nonnull Level world, @Nonnull BlockPos center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRange(world, (double)center.getX() + 0.5, (double)center.getY() + 0.5, (double)center.getZ() + 0.5, exclude, entityClass, range);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(@Nonnull Level world, @Nonnull Vec3 center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRange(world, center.x(), center.y(), center.z(), exclude, entityClass, range);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(@Nonnull Level world, @Nonnull Vec3 center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range, Predicate<Entity> selector) {
        return EntityUtils.getEntitiesInRange(world, center.x(), center.y(), center.z(), exclude, entityClass, range, selector);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(@Nonnull Level world, double x, double y, double z, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRange(world, x, y, z, exclude, entityClass, range, EntitySelector.NO_SPECTATORS);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(@Nonnull Level world, double x, double y, double z, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range, Predicate<Entity> selector) {
        List retVal = world.getEntitiesOfClass(entityClass, new AABB(x, y, z, x, y, z).inflate(range, range, range), selector);
        if (exclude != null) {
            List excludeIds = exclude.stream().map(e -> e.getId()).collect(Collectors.toList());
            retVal = retVal.stream().filter(e -> !excludeIds.contains(e.getId())).collect(Collectors.toList());
        }
        return retVal;
    }

    public static <T extends Entity> List<T> getEntitiesInRangeSorted(@Nonnull Level world, @Nonnull BlockPos center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRangeSorted(world, (double)center.getX() + 0.5, (double)center.getY() + 0.5, (double)center.getZ() + 0.5, exclude, entityClass, range);
    }

    public static <T extends Entity> List<T> getEntitiesInRangeSorted(@Nonnull Level world, @Nonnull Vec3 center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRangeSorted(world, center, exclude, entityClass, range, EntitySelector.NO_SPECTATORS);
    }

    public static <T extends Entity> List<T> getEntitiesInRangeSorted(@Nonnull Level world, @Nonnull Vec3 center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range, Predicate<Entity> selector) {
        List<T> entities = EntityUtils.getEntitiesInRange(world, center, exclude, entityClass, range, selector);
        return entities.stream().sorted(new EntityDistanceComparator(center)).collect(Collectors.toList());
    }

    public static <T extends Entity> List<T> getEntitiesInRangeSorted(@Nonnull Level world, double x, double y, double z, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRangeSorted(world, new Vec3(x, y, z), exclude, entityClass, range);
    }

    public static void teleportEntity(LivingEntity player, Level world, Vec3 destination) {
        Services.EVENTS.attemptEnderEntityTeleport(player, destination).ifPresent(target -> {
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                PacketHandler.sendToAllAround(new TeleportArrivalPacket(target.x(), target.y(), target.z()), serverLevel, BlockPos.containing((Position)target), 64.0);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (player.level() == world && !player.isSleeping()) {
                        if (player.isPassenger()) {
                            player.stopRiding();
                        }
                        StatsManager.incrementValue((Player)serverPlayer, StatsPM.DISTANCE_TELEPORTED_CM, (int)(100.0 * player.position().distanceTo(target)));
                        player.teleportTo(target.x(), target.y(), target.z());
                        player.fallDistance = 0.0f;
                    }
                }
            }
        });
    }

    protected static class EntityDistanceComparator
    implements Comparator<Entity> {
        protected final Vec3 center;

        public EntityDistanceComparator(@Nonnull Vec3 center) {
            this.center = center;
        }

        @Override
        public int compare(Entity a, Entity b) {
            double distB;
            if (a.equals((Object)b)) {
                return 0;
            }
            double distA = this.center.distanceToSqr(a.position());
            return distA > (distB = this.center.distanceToSqr(b.position())) ? 1 : (distA < distB ? -1 : 0);
        }
    }
}

