/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import com.verdantartifice.primalmagick.platform.Services;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;

public class DataPackUtils {
    static String itemFilePrefix = "data/primalmagick/affinities/items/";
    static String entityFilePrefix = "data/primalmagick/affinities/entity_types/";
    static String packName = "primalMagickAffinities";
    static String packMCMetaFilename = "pack.mcmeta";
    static String packMCMeta = "    {\n        \"pack\": {\n          \"description\": \"Primal Magick ModPack Base Item Affinities\",\n          \"pack_format\": %d\n        }\n    }\n".formatted(SharedConstants.getCurrentVersion().getPackVersion(PackType.SERVER_DATA));
    static String itemTemplate = "    { \"type\": \"item\",\n      \"set\": {\n        \"primalmagick:earth\": 0,\n        \"primalmagick:sun\": 0,\n        \"primalmagick:moon\": 0,\n        \"primalmagick:sky\": 0,\n        \"primalmagick:sea\": 0,\n        \"primalmagick:blood\": 0,\n        \"primalmagick:infernal\": 0,\n        \"primalmagick:void\": 0,\n        \"primalmagick:hallowed\": 0\n      },\n      \"target\": \"%s\"\n    }\n";
    static String entityTemplate = "    { \"type\": \"entity_type\",\n      \"values\": {\n        \"primalmagick:earth\": 0,\n        \"primalmagick:sun\": 0,\n        \"primalmagick:moon\": 0,\n        \"primalmagick:sky\": 0,\n        \"primalmagick:sea\": 0,\n        \"primalmagick:blood\": 0,\n        \"primalmagick:infernal\": 0,\n        \"primalmagick:void\": 0,\n        \"primalmagick:hallowed\": 0\n      },\n      \"target\": \"%s\"\n    }\n";

    public static byte[] ItemsToDataPackTemplate(List<Item> sourceItems, List<EntityType<?>> sourceEntities) throws IOException {
        String path;
        String namespace;
        ResourceLocation resourceLocation;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        ZipEntry z = new ZipEntry(String.format("%s/%s", packName, packMCMetaFilename));
        zos.putNextEntry(z);
        zos.write(packMCMeta.getBytes());
        zos.closeEntry();
        for (Item item : sourceItems) {
            resourceLocation = Services.ITEMS_REGISTRY.getKey(item);
            if (resourceLocation == null) continue;
            namespace = resourceLocation.getNamespace();
            path = resourceLocation.getPath();
            String entryPath = String.format("%s/data/%s/affinities/items/%s.json", packName, namespace, path);
            String target = resourceLocation.toString();
            z = new ZipEntry(entryPath);
            zos.putNextEntry(z);
            zos.write(String.format(itemTemplate, target).getBytes());
            zos.closeEntry();
        }
        for (EntityType entityType : sourceEntities) {
            resourceLocation = Services.ENTITY_TYPES_REGISTRY.getKey(entityType);
            if (resourceLocation == null) continue;
            namespace = resourceLocation.getNamespace();
            path = resourceLocation.getPath();
            String target = resourceLocation.toString();
            String entryPath = String.format("%s/data/%s/affinities/entity_types/%s.json", packName, namespace, path);
            z = new ZipEntry(entryPath);
            zos.putNextEntry(z);
            zos.write(String.format(entityTemplate, target).getBytes());
            zos.closeEntry();
        }
        zos.close();
        return bos.toByteArray();
    }
}

