/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.joml.Vector2i;

public class CodecUtils {
    public static final Codec<String> SINGLE_CHARACTER_STRING_CODEC = Codec.STRING.flatXmap(str -> {
        if (str.length() != 1) {
            return DataResult.error(() -> "Invalid key entry: '" + str + "' is an invalid symbol (must be 1 character only).");
        }
        return " ".equals(str) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)str);
    }, DataResult::success);
    public static final Codec<Block> BLOCK_NONAIR_CODEC = Services.BLOCKS_REGISTRY.codec().validate(block -> block == Blocks.AIR ? DataResult.error(() -> "Block must not be minecraft:air") : DataResult.success((Object)block));
    public static final Codec<Vector2i> VECTOR2I = Codec.INT.listOf().comapFlatMap(intList -> Util.fixedSize((List)intList, (int)2).map(values -> new Vector2i(((Integer)values.get(0)).intValue(), ((Integer)values.get(1)).intValue())), vec -> List.of(Integer.valueOf(vec.x()), Integer.valueOf(vec.y())));
    private static final Function<Optional<Integer>, OptionalInt> TO_OPTIONAL_INT = intOpt -> intOpt.map(OptionalInt::of).orElseGet(OptionalInt::empty);
    private static final Function<OptionalInt, Optional<Integer>> FROM_OPTIONAL_INT = intOpt -> intOpt.isPresent() ? Optional.of(intOpt.getAsInt()) : Optional.empty();
    private static final Function<Optional<Double>, OptionalDouble> TO_OPTIONAL_DOUBLE = doubleOpt -> doubleOpt.map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    private static final Function<OptionalDouble, Optional<Double>> FROM_OPTIONAL_DOUBLE = doubleOpt -> doubleOpt.isPresent() ? Optional.of(doubleOpt.getAsDouble()) : Optional.empty();

    public static MapCodec<OptionalInt> asOptionalInt(MapCodec<Optional<Integer>> codec) {
        return codec.xmap(TO_OPTIONAL_INT, FROM_OPTIONAL_INT);
    }

    public static MapCodec<OptionalDouble> asOptionalDouble(MapCodec<Optional<Double>> codec) {
        return codec.xmap(TO_OPTIONAL_DOUBLE, FROM_OPTIONAL_DOUBLE);
    }
}

