/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tips;

import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.tips.TipDefinition;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class TipDefinitionsPM {
    public static final ResourceKey<TipDefinition> THANKS = TipDefinitionsPM.create("thanks");
    public static final ResourceKey<TipDefinition> DISCORD = TipDefinitionsPM.create("discord");
    public static final ResourceKey<TipDefinition> MORE_TIPS = TipDefinitionsPM.create("more_tips");
    public static final ResourceKey<TipDefinition> EARTH_SHRINE_LOC = TipDefinitionsPM.create("earth_shrine_loc");
    public static final ResourceKey<TipDefinition> SEA_SHRINE_LOC = TipDefinitionsPM.create("sea_shrine_loc");
    public static final ResourceKey<TipDefinition> SKY_SHRINE_LOC = TipDefinitionsPM.create("sky_shrine_loc");
    public static final ResourceKey<TipDefinition> SUN_SHRINE_LOC = TipDefinitionsPM.create("sun_shrine_loc");
    public static final ResourceKey<TipDefinition> MOON_SHRINE_LOC = TipDefinitionsPM.create("moon_shrine_loc");
    public static final ResourceKey<TipDefinition> NO_BLOOD_SHRINES = TipDefinitionsPM.create("no_blood_shrines");
    public static final ResourceKey<TipDefinition> NO_INFERNAL_SHRINES = TipDefinitionsPM.create("no_infernal_shrines");
    public static final ResourceKey<TipDefinition> NO_VOID_SHRINES = TipDefinitionsPM.create("no_void_shrines");
    public static final ResourceKey<TipDefinition> NO_HALLOWED_SHRINES = TipDefinitionsPM.create("no_hallowed_shrines");
    public static final ResourceKey<TipDefinition> GO_EXPLORE = TipDefinitionsPM.create("go_explore");
    public static final ResourceKey<TipDefinition> NEW_DISCIPLINES = TipDefinitionsPM.create("new_disciplines");
    public static final ResourceKey<TipDefinition> SALT = TipDefinitionsPM.create("salt");
    public static final ResourceKey<TipDefinition> TREEFOLK = TipDefinitionsPM.create("treefolk");
    public static final ResourceKey<TipDefinition> VIEW_AFFINITIES = TipDefinitionsPM.create("view_affinities");
    public static final ResourceKey<TipDefinition> ANALYSIS = TipDefinitionsPM.create("analysis");
    public static final ResourceKey<TipDefinition> NO_AFFINITIES = TipDefinitionsPM.create("no_affinities");
    public static final ResourceKey<TipDefinition> RESEARCH_TABLE = TipDefinitionsPM.create("research_table");
    public static final ResourceKey<TipDefinition> PROJECT_SUCCESS = TipDefinitionsPM.create("project_success");
    public static final ResourceKey<TipDefinition> RESEARCH_BOLDNESS = TipDefinitionsPM.create("research_boldness");
    public static final ResourceKey<TipDefinition> RESEARCH_AIDS = TipDefinitionsPM.create("research_aids");
    public static final ResourceKey<TipDefinition> PERMANENT_ATTUNEMENT = TipDefinitionsPM.create("permanent_attunement");
    public static final ResourceKey<TipDefinition> TEMPORARY_ATTUNEMENT = TipDefinitionsPM.create("temporary_attunement");
    public static final ResourceKey<TipDefinition> BETTER_ANALYSIS = TipDefinitionsPM.create("better_analysis");
    public static final ResourceKey<TipDefinition> SPENDING_MANA = TipDefinitionsPM.create("spending_mana");
    public static final ResourceKey<TipDefinition> SOTU = TipDefinitionsPM.create("sotu");
    public static final ResourceKey<TipDefinition> MANA_CHARGER = TipDefinitionsPM.create("mana_charger");
    public static final ResourceKey<TipDefinition> STAVES = TipDefinitionsPM.create("staves");
    public static final ResourceKey<TipDefinition> ROBES = TipDefinitionsPM.create("robes");
    public static final ResourceKey<TipDefinition> RITUAL_SYMMETRY = TipDefinitionsPM.create("ritual_symmetry");
    public static final ResourceKey<TipDefinition> INDUCED_ATTUNEMENT = TipDefinitionsPM.create("induced_attunement");
    public static final ResourceKey<TipDefinition> AMBROSIA_CAP = TipDefinitionsPM.create("ambrosia_cap");
    public static final ResourceKey<TipDefinition> POWER_RUNES = TipDefinitionsPM.create("power_runes");
    public static final ResourceKey<TipDefinition> RUNE_HINTS = TipDefinitionsPM.create("rune_hints");

    public static ResourceKey<TipDefinition> create(String name) {
        return ResourceKey.create(RegistryKeysPM.TIPS, (ResourceLocation)ResourceUtils.loc(name));
    }

    protected static void register(BootstrapContext<TipDefinition> ctx, ResourceKey<TipDefinition> key, Function<ResourceKey<TipDefinition>, TipDefinition> func) {
        ctx.register(key, (Object)func.apply(key));
    }

    protected static void register(BootstrapContext<TipDefinition> ctx, ResourceKey<TipDefinition> key) {
        TipDefinitionsPM.register(ctx, key, (ResourceKey<TipDefinition> k) -> TipDefinition.builder((ResourceKey<TipDefinition>)k).build());
    }

    protected static void register(BootstrapContext<TipDefinition> ctx, ResourceKey<TipDefinition> key, ResourceKey<ResearchEntry> req) {
        TipDefinitionsPM.register(ctx, key, (ResourceKey<TipDefinition> k) -> TipDefinition.builder((ResourceKey<TipDefinition>)k).requiredResearch(req).build());
    }

    public static void bootstrap(BootstrapContext<TipDefinition> context) {
        TipDefinitionsPM.register(context, THANKS);
        TipDefinitionsPM.register(context, DISCORD);
        TipDefinitionsPM.register(context, MORE_TIPS);
        TipDefinitionsPM.register(context, EARTH_SHRINE_LOC);
        TipDefinitionsPM.register(context, SEA_SHRINE_LOC);
        TipDefinitionsPM.register(context, SKY_SHRINE_LOC);
        TipDefinitionsPM.register(context, SUN_SHRINE_LOC);
        TipDefinitionsPM.register(context, MOON_SHRINE_LOC);
        TipDefinitionsPM.register(context, NO_BLOOD_SHRINES, ResearchEntries.DISCOVER_BLOOD);
        TipDefinitionsPM.register(context, NO_INFERNAL_SHRINES, ResearchEntries.DISCOVER_INFERNAL);
        TipDefinitionsPM.register(context, NO_VOID_SHRINES, ResearchEntries.DISCOVER_VOID);
        TipDefinitionsPM.register(context, NO_HALLOWED_SHRINES, ResearchEntries.DISCOVER_HALLOWED);
        TipDefinitionsPM.register(context, GO_EXPLORE);
        TipDefinitionsPM.register(context, NEW_DISCIPLINES);
        TipDefinitionsPM.register(context, SALT);
        TipDefinitionsPM.register(context, TREEFOLK);
        TipDefinitionsPM.register(context, VIEW_AFFINITIES, ResearchEntries.FIRST_STEPS);
        TipDefinitionsPM.register(context, ANALYSIS, ResearchEntries.FIRST_STEPS);
        TipDefinitionsPM.register(context, NO_AFFINITIES, ResearchEntries.FIRST_STEPS);
        TipDefinitionsPM.register(context, RESEARCH_TABLE, ResearchEntries.THEORYCRAFTING);
        TipDefinitionsPM.register(context, PROJECT_SUCCESS, ResearchEntries.THEORYCRAFTING);
        TipDefinitionsPM.register(context, RESEARCH_BOLDNESS, ResearchEntries.THEORYCRAFTING);
        TipDefinitionsPM.register(context, RESEARCH_AIDS, ResearchEntries.THEORYCRAFTING);
        TipDefinitionsPM.register(context, PERMANENT_ATTUNEMENT, ResearchEntries.ATTUNEMENTS);
        TipDefinitionsPM.register(context, TEMPORARY_ATTUNEMENT, ResearchEntries.ATTUNEMENTS);
        TipDefinitionsPM.register(context, BETTER_ANALYSIS, ResearchEntries.UNLOCK_MAGITECH);
        TipDefinitionsPM.register(context, SPENDING_MANA, ResearchEntries.TERRESTRIAL_MAGICK);
        TipDefinitionsPM.register(context, SOTU, (ResourceKey<TipDefinition> k) -> TipDefinition.builder((ResourceKey<TipDefinition>)k).requiredResearch(ResearchEntries.SECRETS_OF_THE_UNIVERSE, 0).build());
        TipDefinitionsPM.register(context, MANA_CHARGER, ResearchEntries.WAND_CHARGER);
        TipDefinitionsPM.register(context, STAVES, ResearchEntries.STAVES);
        TipDefinitionsPM.register(context, ROBES, ResearchEntries.IMBUED_WOOL);
        TipDefinitionsPM.register(context, RITUAL_SYMMETRY, ResearchEntries.BASIC_RITUAL);
        TipDefinitionsPM.register(context, INDUCED_ATTUNEMENT, ResearchEntries.AMBROSIA);
        TipDefinitionsPM.register(context, AMBROSIA_CAP, ResearchEntries.AMBROSIA);
        TipDefinitionsPM.register(context, POWER_RUNES, ResearchEntries.BASIC_RUNEWORKING);
        TipDefinitionsPM.register(context, RUNE_HINTS, ResearchEntries.BASIC_RUNEWORKING);
    }

    public static Stream<TipDefinition> stream(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(RegistryKeysPM.TIPS).stream();
    }

    @NotNull
    public static Optional<TipDefinition> getRandom(Player player, RandomSource randomSource) {
        List<TipDefinition> filteredTips = TipDefinitionsPM.stream(player.registryAccess()).filter(tip -> tip.shouldShow(player)).toList();
        if (filteredTips.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(filteredTips.get(randomSource.nextInt(filteredTips.size())));
    }
}

