/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tips;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchStageKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record TipDefinition(String translationKey, Optional<AbstractRequirement<?>> requirement) {
    public static Codec<TipDefinition> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("translationKey").forGetter(TipDefinition::translationKey), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("requirement").forGetter(TipDefinition::requirement)).apply((Applicative)instance, TipDefinition::new));
    }

    public Component getText() {
        return Component.translatable((String)this.translationKey);
    }

    public boolean shouldShow(Player player) {
        return this.requirement.map(req -> req.isMetBy(player)).orElse(true);
    }

    public static Builder builder(ResourceKey<TipDefinition> key) {
        return new Builder(key.location());
    }

    public static Builder builder(ResourceLocation id) {
        return new Builder(id);
    }

    public static Builder builder(String id) {
        return new Builder(ResourceUtils.loc(id));
    }

    public static class Builder {
        protected final ResourceLocation id;
        protected String translationKey;
        protected Optional<AbstractRequirement<?>> requirement;

        protected Builder(ResourceLocation id) {
            this.id = id;
            this.translationKey = String.join((CharSequence)".", "tip", id.getNamespace(), id.getPath());
            this.requirement = Optional.empty();
        }

        public Builder translationKey(String key) {
            this.translationKey = key;
            return this;
        }

        public Builder requirement(AbstractRequirement<?> requirement) {
            this.requirement = Optional.ofNullable(requirement);
            return this;
        }

        public Builder requiredResearch(AbstractResearchKey<?> researchKey) {
            return this.requirement(new ResearchRequirement(researchKey));
        }

        public Builder requiredResearch(ResourceKey<ResearchEntry> rawResearchKey) {
            return this.requiredResearch(new ResearchEntryKey(rawResearchKey));
        }

        public Builder requiredResearch(ResourceKey<ResearchEntry> rawResearchKey, int stage) {
            return this.requiredResearch(new ResearchStageKey(rawResearchKey, stage));
        }

        public TipDefinition build() {
            return new TipDefinition(this.translationKey, this.requirement);
        }

        public void save(BiConsumer<ResourceLocation, TipDefinition> consumer) {
            consumer.accept(this.id, this.build());
        }
    }
}

