/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.rituals;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.DynamicOps;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.blocks.rituals.OfferingPedestalBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.RitualAltarBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.SaltTrailBlock;
import com.verdantartifice.primalmagick.common.blockstates.properties.SaltSide;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.crafting.BlockIngredient;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.menus.FakeMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.OfferingChannelPacket;
import com.verdantartifice.primalmagick.common.network.packets.fx.PlayClientSoundPacket;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellBoltPacket;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropTileEntity;
import com.verdantartifice.primalmagick.common.rituals.IRitualStabilizer;
import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import com.verdantartifice.primalmagick.common.rituals.Mishap;
import com.verdantartifice.primalmagick.common.rituals.steps.AbstractRitualStep;
import com.verdantartifice.primalmagick.common.rituals.steps.OfferingRitualStep;
import com.verdantartifice.primalmagick.common.rituals.steps.PropRitualStep;
import com.verdantartifice.primalmagick.common.rituals.steps.UniversalRitualStep;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.rituals.OfferingPedestalTileEntity;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import com.verdantartifice.primalmagick.common.wands.IInteractWithWand;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.common.wands.ManaManager;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class RitualAltarTileEntity
extends AbstractTileSidedInventoryPM
implements IInteractWithWand {
    protected static final int OUTPUT_INV_INDEX = 0;
    protected static final float MIN_STABILITY = -100.0f;
    protected static final float MAX_STABILITY = 25.0f;
    protected static final int RITUAL_SOUND_LENGTH = 58;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RNG = new Random();
    protected final WeightedRandomBag<Mishap> mishaps;
    protected int ticksExisted = 0;
    protected boolean active = false;
    protected boolean currentStepComplete = false;
    protected int activeCount = 0;
    protected int nextCheckCount = 0;
    protected float stability = 0.0f;
    protected UUID activePlayerId = null;
    protected ResourceLocation activeRecipeId = null;
    protected AbstractRitualStep<?> currentStep = null;
    protected LinkedList<AbstractRitualStep<?>> remainingSteps = new LinkedList();
    protected BlockPos awaitedPropPos = null;
    protected BlockPos channeledOfferingPos = null;
    protected boolean scanDirty = false;
    protected boolean skipWarningMessage = false;
    protected float symmetryDelta = 0.0f;
    protected List<BlockPos> saltPositions = new ArrayList<BlockPos>();
    protected List<BlockPos> pedestalPositions = new ArrayList<BlockPos>();
    protected List<BlockPos> propPositions = new ArrayList<BlockPos>();
    protected Map<Block, Integer> blockCounts = new HashMap<Block, Integer>();

    public RitualAltarTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.RITUAL_ALTAR.get(), pos, state);
        this.mishaps = (WeightedRandomBag)Util.make(new WeightedRandomBag(), bag -> {
            bag.add(new Mishap(this::mishapOffering, false, 0.0f), 6.0);
            bag.add(new Mishap(this::mishapSalt, false, 10.0f), 3.0);
            bag.add(new Mishap(this::mishapDamage, false, 25.0f), 3.0);
            bag.add(new Mishap(this::mishapSalt, true, 35.0f), 2.0);
            bag.add(new Mishap(this::mishapDamage, true, 45.0f), 2.0);
            bag.add(new Mishap(this::mishapOffering, true, 50.0f), 1.0);
            bag.add(new Mishap(this::mishapDetonate, false, 75.0f), 2.0);
            bag.add(new Mishap(this::mishapDetonate, true, 90.0f), 1.0);
        });
    }

    public boolean isActive() {
        return this.active;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    @Nullable
    public Player getActivePlayer() {
        Level level;
        if (this.activePlayerId != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getServer().getPlayerList().getPlayer(this.activePlayerId);
        }
        return null;
    }

    public void setActivePlayer(@Nullable Player player) {
        this.activePlayerId = player == null ? null : player.getUUID();
    }

    @Nullable
    protected Optional<RecipeHolder<IRitualRecipe>> getActiveRecipe() {
        Recipe recipe;
        Optional recipeOpt;
        if (this.activeRecipeId != null && (recipeOpt = this.level.getServer().getRecipeManager().byKey(this.activeRecipeId)).isPresent() && (recipe = ((RecipeHolder)recipeOpt.get()).value()) instanceof IRitualRecipe) {
            IRitualRecipe ritualRecipe = (IRitualRecipe)recipe;
            return Optional.of(new RecipeHolder(((RecipeHolder)recipeOpt.get()).id(), (Recipe)ritualRecipe));
        }
        return Optional.empty();
    }

    @Override
    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return inventoryIndex == 0 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
    }

    public Color getOrbColor() {
        float saturation;
        float hue;
        if (this.stability >= 0.0f) {
            hue = 0.33333334f;
            saturation = Mth.clamp((float)(this.stability / 25.0f), (float)0.0f, (float)1.0f);
        } else {
            hue = 0.0f;
            saturation = Mth.clamp((float)(this.stability / -100.0f), (float)0.0f, (float)1.0f);
        }
        return Color.getHSBColor(hue, saturation, 1.0f);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.active = compound.getBoolean("Active");
        this.currentStepComplete = compound.getBoolean("CurrentStepComplete");
        this.activeCount = compound.getInt("ActiveCount");
        this.nextCheckCount = compound.getInt("NextCheckCount");
        this.stability = Mth.clamp((float)compound.getFloat("Stability"), (float)-100.0f, (float)25.0f);
        this.activePlayerId = compound.contains("ActivePlayer", 10) ? NbtUtils.loadUUID((Tag)compound.getCompound("ActivePlayer")) : null;
        this.activeRecipeId = compound.contains("ActiveRecipeId", 8) ? ResourceLocation.parse((String)compound.getString("ActiveRecipeId")) : null;
        RegistryOps registryOps = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.currentStep = null;
        if (compound.contains("CurrentStep")) {
            AbstractRitualStep.dispatchCodec().parse((DynamicOps)registryOps, (Object)compound.get("CurrentStep")).resultOrPartial(msg -> LOGGER.error("Failed to decode current ritual step: {}", msg)).ifPresent(decodedStep -> {
                this.currentStep = decodedStep;
            });
        }
        this.remainingSteps.clear();
        if (compound.contains("RemainingSteps")) {
            AbstractRitualStep.dispatchCodec().listOf().parse((DynamicOps)registryOps, (Object)compound.get("RemainingSteps")).resultOrPartial(msg -> LOGGER.error("Failed to decode remaining ritual steps: {}", msg)).ifPresent(decodedSteps -> this.remainingSteps.addAll((Collection<AbstractRitualStep<?>>)decodedSteps));
        }
        this.awaitedPropPos = compound.contains("AwaitedPropPos", 4) ? BlockPos.of((long)compound.getLong("AwaitedPropPos")) : null;
        this.channeledOfferingPos = compound.contains("ChanneledOfferingPos", 4) ? BlockPos.of((long)compound.getLong("ChanneledOfferingPos")) : null;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        RegistryOps registryOps = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        compound.putBoolean("Active", this.active);
        compound.putBoolean("CurrentStepComplete", this.currentStepComplete);
        compound.putInt("ActiveCount", this.activeCount);
        compound.putInt("NextCheckCount", this.nextCheckCount);
        compound.putFloat("Stability", this.stability);
        if (this.activePlayerId != null) {
            compound.putUUID("ActivePlayer", this.activePlayerId);
        }
        if (this.activeRecipeId != null) {
            compound.putString("ActiveRecipeId", this.activeRecipeId.toString());
        }
        if (this.currentStep != null) {
            AbstractRitualStep.dispatchCodec().encodeStart((DynamicOps)registryOps, this.currentStep).resultOrPartial(msg -> LOGGER.error("Failed to encode current ritual step: {}", msg)).ifPresent(encodedStep -> compound.put("CurrentStep", encodedStep));
        }
        if (this.remainingSteps != null && !this.remainingSteps.isEmpty()) {
            AbstractRitualStep.dispatchCodec().listOf().encodeStart((DynamicOps)registryOps, this.remainingSteps).resultOrPartial(msg -> LOGGER.error("Failed to encode remaining ritual steps: {}", msg)).ifPresent(encodedSteps -> compound.put("RemainingSteps", encodedSteps));
        }
        if (this.awaitedPropPos != null) {
            compound.putLong("AwaitedPropPos", this.awaitedPropPos.asLong());
        }
        if (this.channeledOfferingPos != null) {
            compound.putLong("ChanneledOfferingPos", this.channeledOfferingPos.asLong());
        }
    }

    protected void reset() {
        BlockState state;
        Block block;
        if (this.awaitedPropPos != null && (block = (state = this.level.getBlockState(this.awaitedPropPos)).getBlock()) instanceof IRitualPropBlock) {
            ((IRitualPropBlock)block).closeProp(state, this.level, this.awaitedPropPos);
        }
        this.active = false;
        this.currentStepComplete = false;
        this.activeCount = 0;
        this.nextCheckCount = 0;
        this.stability = 0.0f;
        this.setActivePlayer(null);
        this.activeRecipeId = null;
        this.currentStep = null;
        this.remainingSteps.clear();
        this.awaitedPropPos = null;
        this.channeledOfferingPos = null;
        this.scanDirty = false;
        this.skipWarningMessage = false;
        this.symmetryDelta = 0.0f;
        this.pedestalPositions.clear();
        this.propPositions.clear();
        this.saltPositions.clear();
        this.blockCounts.clear();
        this.setChanged();
        this.syncTile(false);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RitualAltarTileEntity entity) {
        if (entity.active) {
            entity.doEffects();
        }
        if (entity.ticksExisted % (entity.active ? 10 : 20) == 0 && !level.isClientSide) {
            entity.scanDirty = true;
        }
        if (entity.scanDirty && !level.isClientSide) {
            entity.scanSurroundings();
            entity.scanDirty = false;
        }
        if (!level.isClientSide && entity.active) {
            if (entity.currentStep == null || entity.currentStepComplete) {
                if (entity.remainingSteps.isEmpty()) {
                    if (entity.activeCount >= entity.nextCheckCount) {
                        entity.finishCraft();
                        entity.setChanged();
                        entity.syncTile(false);
                    }
                    return;
                }
                entity.currentStep = entity.remainingSteps.poll();
                entity.currentStepComplete = false;
                entity.skipWarningMessage = false;
            }
            float delta = entity.calculateStabilityDelta();
            entity.addStability(delta);
            if (entity.currentStep != null && !entity.doStep(entity.currentStep)) {
                entity.addStability(Math.min(0.0f, delta));
            }
            if (entity.activeCount % 10 == 0 && entity.stability < 0.0f && (float)level.random.nextInt(1500) < Math.abs(entity.stability)) {
                entity.doMishap();
            }
            entity.setChanged();
            entity.syncTile(false);
        }
        ++entity.ticksExisted;
        if (entity.active) {
            ++entity.activeCount;
        }
    }

    @Override
    public InteractionResult onWandRightClick(ItemStack wandStack, Level level, Player player, BlockPos pos, Direction direction) {
        if (!this.level.isClientSide && wandStack.getItem() instanceof IWand) {
            if (this.active) {
                player.displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.info.canceled"), false);
                this.doMishap();
                this.reset();
            } else if (!level.getBlockState(pos.above()).isAir() || !level.getBlockState(pos.above(2)).isAir()) {
                player.displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.obstructed"), false);
                this.reset();
            } else if (this.startCraft(wandStack, player)) {
                this.active = true;
                this.activeCount = 0;
                player.displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.info.started"), false);
                this.setActivePlayer(player);
                this.setChanged();
                this.syncTile(false);
            } else {
                this.reset();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void onWandUseTick(ItemStack wandStack, Level level, Player player, Vec3 targetPos, int count) {
    }

    protected void doEffects() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.activeCount % 58 == 0) {
                PacketHandler.sendToAllAround(new PlayClientSoundPacket(SoundsPM.RITUAL.get(), 1.0f, 1.0f), serverLevel, this.getBlockPos(), 16.0);
            }
        }
    }

    protected boolean startCraft(ItemStack wandStack, Player player) {
        this.scanSurroundings();
        ArrayList<ItemStack> offerings = new ArrayList<ItemStack>();
        for (BlockPos offeringPos : this.pedestalPositions) {
            OfferingPedestalTileEntity pedestalTile;
            ItemStack stack;
            BlockEntity tile = this.level.getBlockEntity(offeringPos);
            if (!(tile instanceof OfferingPedestalTileEntity) || (stack = (pedestalTile = (OfferingPedestalTileEntity)tile).getItem()) == null || stack.isEmpty()) continue;
            offerings.add(stack);
        }
        TransientCraftingContainer inv = new TransientCraftingContainer((AbstractContainerMenu)new FakeMenu(), offerings.size(), 1);
        int offeringIndex = 0;
        for (ItemStack offering : offerings) {
            inv.setItem(offeringIndex++, offering);
        }
        Optional recipeOpt = this.level.getServer().getRecipeManager().getRecipeFor(RecipeTypesPM.RITUAL.get(), (RecipeInput)inv.asCraftInput(), this.level);
        if (recipeOpt.isPresent()) {
            RecipeHolder recipe = (RecipeHolder)recipeOpt.get();
            if (this.canUseRitualRecipe(wandStack, player, (RecipeHolder<IRitualRecipe>)recipe) && this.generateRitualSteps((RecipeHolder<IRitualRecipe>)recipe)) {
                this.activeRecipeId = recipe.id();
                this.currentStep = null;
                this.currentStepComplete = false;
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean generateRitualSteps(@Nonnull RecipeHolder<IRitualRecipe> recipe) {
        int index;
        LinkedList<OfferingRitualStep> offeringSteps = new LinkedList<OfferingRitualStep>();
        LinkedList<AbstractRitualStep> propSteps = new LinkedList<AbstractRitualStep>();
        LinkedList<AbstractRitualStep> newSteps = new LinkedList<AbstractRitualStep>();
        for (index = 0; index < ((IRitualRecipe)recipe.value()).getIngredients().size(); ++index) {
            offeringSteps.add(new OfferingRitualStep(index));
        }
        for (index = 0; index < ((IRitualRecipe)recipe.value()).getProps().size(); ++index) {
            propSteps.add(new PropRitualStep(index));
        }
        for (BlockPos propPos : this.propPositions) {
            IRitualPropBlock propBlock;
            BlockState propState = this.level.getBlockState(propPos);
            Block block = propState.getBlock();
            if (!(block instanceof IRitualPropBlock) || !(propBlock = (IRitualPropBlock)block).isUniversal() || propBlock.isPropActivated(propState, this.level, propPos)) continue;
            propSteps.add(new UniversalRitualStep(propPos, Services.BLOCKS_REGISTRY.getKey(block)));
        }
        Collections.shuffle(offeringSteps, RNG);
        Collections.shuffle(propSteps, RNG);
        int numOfferings = offeringSteps.size();
        int numProps = propSteps.size();
        int[] offeringBuckets = new int[numProps + 1];
        Arrays.fill(offeringBuckets, numOfferings / (numProps + 1));
        int leftoverOfferings = numOfferings % (numProps + 1);
        if (leftoverOfferings > 0) {
            int index2;
            ArrayList<Integer> leftoverBuckets = new ArrayList<Integer>();
            for (index2 = 0; index2 < numProps + 1; ++index2) {
                leftoverBuckets.add(index2 < leftoverOfferings ? 1 : 0);
            }
            Collections.shuffle(leftoverBuckets, RNG);
            for (index2 = 0; index2 < offeringBuckets.length; ++index2) {
                int n = index2;
                offeringBuckets[n] = offeringBuckets[n] + (Integer)leftoverBuckets.get(index2);
            }
        }
        for (int index3 = 0; index3 < offeringBuckets.length; ++index3) {
            if (index3 > 0) {
                newSteps.add((AbstractRitualStep)propSteps.poll());
            }
            for (int bucketIndex = 0; bucketIndex < offeringBuckets[index3]; ++bucketIndex) {
                newSteps.add((AbstractRitualStep)offeringSteps.poll());
            }
        }
        this.remainingSteps = newSteps;
        return true;
    }

    protected void finishCraft() {
        this.getActiveRecipe().ifPresent(recipeHolder -> {
            ItemStack outputStack = ((IRitualRecipe)recipeHolder.value()).getResultItem((HolderLookup.Provider)this.getLevel().registryAccess()).copy();
            this.setItem(0, 0, outputStack);
            Player activePlayer = this.getActivePlayer();
            if (activePlayer != null) {
                activePlayer.displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.info.complete"), false);
                StatsManager.incrementValue(activePlayer, StatsPM.RITUALS_COMPLETED);
                StatsManager.incrementValue(activePlayer, StatsPM.CRAFTED_RITUAL, outputStack.getCount());
                ExpertiseManager.awardExpertise(activePlayer, recipeHolder);
            }
        });
        this.spawnSuccessParticles();
        this.reset();
    }

    protected boolean canUseRitualRecipe(ItemStack wandStack, Player player, RecipeHolder<IRitualRecipe> recipeHolder) {
        IRitualRecipe recipe = (IRitualRecipe)recipeHolder.value();
        return !(!recipe.getRequirement().isEmpty() && !((AbstractRequirement)recipe.getRequirement().get()).isMetBy(player) || !recipe.getManaCosts().isEmpty() && !this.consumeMana(wandStack, player, recipe));
    }

    protected boolean consumeMana(ItemStack wandStack, Player player, IRitualRecipe recipe) {
        if (wandStack == null || wandStack.isEmpty() || !(wandStack.getItem() instanceof IWand)) {
            return false;
        }
        return ManaManager.consumeMana(player, wandStack, recipe.getManaCosts(), (HolderLookup.Provider)player.registryAccess());
    }

    protected void scanSurroundings() {
        this.saltPositions.clear();
        this.pedestalPositions.clear();
        this.propPositions.clear();
        this.blockCounts.clear();
        HashSet<BlockPos> scanHistory = new HashSet<BlockPos>();
        scanHistory.add(this.worldPosition);
        LinkedList<BlockPos> toScan = new LinkedList<BlockPos>();
        toScan.offer(this.worldPosition.north());
        toScan.offer(this.worldPosition.east());
        toScan.offer(this.worldPosition.south());
        toScan.offer(this.worldPosition.west());
        while (!toScan.isEmpty()) {
            BlockPos pos = (BlockPos)toScan.poll();
            this.scanPosition(pos, toScan, scanHistory);
        }
        this.symmetryDelta = this.calculateSymmetryDelta();
        Collections.shuffle(this.pedestalPositions, RNG);
        Collections.shuffle(this.propPositions, RNG);
    }

    protected void scanPosition(BlockPos pos, Queue<BlockPos> toScan, Set<BlockPos> history) {
        IRitualPropBlock propBlock;
        if (history.contains(pos)) {
            return;
        }
        history.add(pos);
        BlockState state = this.level.getBlockState(pos);
        Block block = state.getBlock();
        int dist = Math.abs(this.worldPosition.getX() - pos.getX()) + Math.abs(this.worldPosition.getZ() - pos.getZ());
        if (dist > ((RitualAltarBlock)this.getBlockState().getBlock()).getMaxSaltPower()) {
            return;
        }
        if (block == BlocksPM.SALT_TRAIL.get()) {
            this.saltPositions.add(pos);
            for (Map.Entry<Direction, EnumProperty<SaltSide>> entry : SaltTrailBlock.FACING_PROPERTY_MAP.entrySet()) {
                BlockPos nextPos = pos.relative(entry.getKey());
                SaltSide saltSide = (SaltSide)((Object)state.getValue((Property)entry.getValue()));
                if (saltSide == SaltSide.UP) {
                    toScan.add(nextPos.above());
                    continue;
                }
                if (saltSide != SaltSide.SIDE) continue;
                toScan.add(nextPos);
                toScan.add(nextPos.below());
            }
        } else if (block == BlocksPM.OFFERING_PEDESTAL.get()) {
            OfferingPedestalBlock pedestalBlock = (OfferingPedestalBlock)block;
            if (pedestalBlock.isBlockSaltPowered((BlockGetter)this.level, pos)) {
                this.pedestalPositions.add(pos);
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (blockEntity instanceof OfferingPedestalTileEntity) {
                    OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)blockEntity;
                    pedestalTile.setAltarPos(this.getBlockPos());
                }
            }
        } else if (block instanceof IRitualPropBlock && (propBlock = (IRitualPropBlock)block).isBlockSaltPowered((BlockGetter)this.level, pos)) {
            this.propPositions.add(pos);
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (blockEntity instanceof IRitualPropTileEntity) {
                IRitualPropTileEntity propTile = (IRitualPropTileEntity)blockEntity;
                propTile.setAltarPos(this.getBlockPos());
            }
        }
    }

    @Nullable
    public static BlockPos getSymmetricPosition(@Nullable BlockPos altarPos, @Nullable BlockPos propPos) {
        if (altarPos == null || propPos == null) {
            return null;
        }
        int dx = altarPos.getX() - propPos.getX();
        int dz = altarPos.getZ() - propPos.getZ();
        return new BlockPos(altarPos.getX() + dx, propPos.getY(), altarPos.getZ() + dz);
    }

    protected float calculateSymmetryDelta() {
        float delta = 0.0f;
        HashSet<BlockPos> toScan = new HashSet<BlockPos>();
        toScan.addAll(this.pedestalPositions);
        toScan.addAll(this.propPositions);
        for (BlockPos scanPos : toScan) {
            IRitualStabilizer stabilizer;
            BlockPos symPos = RitualAltarTileEntity.getSymmetricPosition(this.worldPosition, scanPos);
            Block block = this.level.getBlockState(scanPos).getBlock();
            if (!(block instanceof IRitualStabilizer) || !(stabilizer = (IRitualStabilizer)block).isBlockSaltPowered((BlockGetter)this.level, scanPos)) continue;
            if (stabilizer.hasSymmetryPenalty(this.level, scanPos, symPos)) {
                delta -= stabilizer.getSymmetryPenalty(this.level, scanPos);
                continue;
            }
            delta += this.calculateDiminishingStabilityBonus(block, stabilizer.getStabilityBonus(this.level, scanPos));
        }
        return delta;
    }

    protected float calculateDiminishingStabilityBonus(Block block, float baseValue) {
        float retVal = baseValue;
        int count = this.blockCounts.getOrDefault(block, 0);
        if (count > 0) {
            retVal = baseValue * (float)Math.pow(0.75, count);
        }
        this.blockCounts.put(block, count + 1);
        return retVal;
    }

    protected boolean doStep(@Nonnull AbstractRitualStep<?> step) {
        return step.execute(this);
    }

    public static boolean doOfferingStep(RitualAltarTileEntity altar, OfferingRitualStep step) {
        IRitualRecipe recipe = altar.getActiveRecipe().map(holder -> (IRitualRecipe)holder.value()).orElse(null);
        if (recipe == null) {
            LOGGER.warn("No recipe found when trying to do offering ritual step");
            return false;
        }
        int offeringIndex = step.getIndex();
        Ingredient requiredOffering = (Ingredient)recipe.getIngredients().get(offeringIndex);
        if (altar.activeCount >= altar.nextCheckCount && altar.channeledOfferingPos == null) {
            for (BlockPos pedestalPos : altar.pedestalPositions) {
                BlockEntity tile = altar.level.getBlockEntity(pedestalPos);
                Block block = altar.level.getBlockState(pedestalPos).getBlock();
                if (!(tile instanceof OfferingPedestalTileEntity)) continue;
                OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)tile;
                if (!(block instanceof ISaltPowered)) continue;
                ISaltPowered saltBlock = (ISaltPowered)block;
                if (!requiredOffering.test(pedestalTile.getItem()) || !saltBlock.isBlockSaltPowered((BlockGetter)altar.level, pedestalPos)) continue;
                altar.channeledOfferingPos = pedestalPos;
                altar.nextCheckCount = altar.activeCount + 60;
                return true;
            }
            if (!altar.skipWarningMessage && altar.getActivePlayer() != null) {
                if (requiredOffering.isEmpty()) {
                    altar.getActivePlayer().displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.missing_offering.empty"), false);
                } else {
                    altar.getActivePlayer().displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.missing_offering", (Object[])new Object[]{requiredOffering.getItems()[0].getHoverName()}), false);
                }
                altar.skipWarningMessage = true;
            }
            altar.nextCheckCount = altar.activeCount + 20;
        }
        if (altar.channeledOfferingPos != null) {
            BlockEntity tile = altar.level.getBlockEntity(altar.channeledOfferingPos);
            Block block = altar.level.getBlockState(altar.channeledOfferingPos).getBlock();
            if (tile instanceof OfferingPedestalTileEntity) {
                OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)tile;
                if (block instanceof ISaltPowered) {
                    ISaltPowered saltBlock = (ISaltPowered)block;
                    if (requiredOffering.test(pedestalTile.getItem()) && saltBlock.isBlockSaltPowered((BlockGetter)altar.level, altar.channeledOfferingPos)) {
                        if (altar.activeCount >= altar.nextCheckCount) {
                            pedestalTile.removeItem(1);
                            altar.currentStepComplete = true;
                            altar.channeledOfferingPos = null;
                        } else {
                            altar.spawnOfferingParticles(altar.channeledOfferingPos, pedestalTile.getItem());
                        }
                        return true;
                    }
                }
            }
            altar.channeledOfferingPos = null;
            if (altar.getActivePlayer() != null) {
                if (requiredOffering.isEmpty()) {
                    altar.getActivePlayer().displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.channel_interrupt.empty"), false);
                } else {
                    altar.getActivePlayer().displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.channel_interrupt", (Object[])new Object[]{requiredOffering.getItems()[0].getHoverName()}), false);
                }
                altar.skipWarningMessage = true;
            }
            altar.addStability(Mth.clamp((float)(50.0f * Math.min(0.0f, altar.calculateStabilityDelta())), (float)-25.0f, (float)-1.0f));
        }
        return false;
    }

    public static boolean doPropStep(RitualAltarTileEntity altar, PropRitualStep step) {
        IRitualRecipe recipe = altar.getActiveRecipe().map(holder -> (IRitualRecipe)holder.value()).orElse(null);
        if (recipe == null) {
            LOGGER.warn("No recipe found when trying to do prop ritual step");
            return false;
        }
        int propIndex = step.getIndex();
        BlockIngredient requiredProp = (BlockIngredient)recipe.getProps().get(propIndex);
        if (altar.activeCount >= altar.nextCheckCount) {
            if (altar.awaitedPropPos == null) {
                for (BlockPos propPos : altar.propPositions) {
                    BlockState propState = altar.level.getBlockState(propPos);
                    Block block = propState.getBlock();
                    if (!requiredProp.test(block) || !altar.openProp(propPos, b -> !b.isPropActivated(propState, altar.level, propPos) && b.isBlockSaltPowered((BlockGetter)altar.level, propPos))) continue;
                    return true;
                }
                if (!altar.skipWarningMessage && altar.getActivePlayer() != null) {
                    if (requiredProp.hasNoMatchingBlocks()) {
                        altar.getActivePlayer().displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.missing_prop.empty"), false);
                    } else {
                        altar.getActivePlayer().displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.missing_prop", (Object[])new Object[]{requiredProp.getMatchingBlocks()[0].getName()}), false);
                    }
                    altar.skipWarningMessage = true;
                }
            } else {
                BlockState propState = altar.level.getBlockState(altar.awaitedPropPos);
                Block block = propState.getBlock();
                if (!(block instanceof IRitualPropBlock && requiredProp.test(block) && ((IRitualPropBlock)block).isBlockSaltPowered((BlockGetter)altar.level, altar.awaitedPropPos))) {
                    altar.onPropInterrupted(block, propState, Services.BLOCKS_REGISTRY.getKey(requiredProp.getMatchingBlocks()[0]));
                }
            }
            altar.nextCheckCount = altar.activeCount + 20;
        }
        return false;
    }

    public static boolean doUniversalPropStep(RitualAltarTileEntity altar, UniversalRitualStep step) {
        IRitualRecipe recipe = altar.getActiveRecipe().map(holder -> (IRitualRecipe)holder.value()).orElse(null);
        if (recipe == null) {
            LOGGER.warn("No recipe found when trying to do universal ritual step");
            return false;
        }
        BlockPos propPos = step.getPos();
        ResourceLocation expectedId = step.getExpectedId();
        if (altar.activeCount >= altar.nextCheckCount) {
            if (altar.awaitedPropPos == null) {
                BlockState propState = altar.level.getBlockState(propPos);
                if (altar.openProp(propPos, b -> b.isUniversal() && !b.isPropActivated(propState, altar.level, propPos) && b.isBlockSaltPowered((BlockGetter)altar.level, propPos))) {
                    return true;
                }
                if (!altar.skipWarningMessage && altar.getActivePlayer() != null) {
                    Block stepBlock = (Block)Services.BLOCKS_REGISTRY.get(expectedId);
                    if (stepBlock == null) {
                        altar.getActivePlayer().displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.missing_prop.empty"), false);
                    } else {
                        altar.getActivePlayer().displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.missing_prop", (Object[])new Object[]{stepBlock.getName()}), false);
                    }
                    altar.skipWarningMessage = true;
                }
            } else {
                BlockState propState = altar.level.getBlockState(altar.awaitedPropPos);
                Block block = propState.getBlock();
                if (!(block instanceof IRitualPropBlock && ((IRitualPropBlock)block).isUniversal() && ((IRitualPropBlock)block).isBlockSaltPowered((BlockGetter)altar.level, altar.awaitedPropPos))) {
                    altar.onPropInterrupted(block, propState, expectedId);
                }
            }
            altar.nextCheckCount = altar.activeCount + 20;
        }
        return false;
    }

    protected boolean openProp(BlockPos propPos, Predicate<IRitualPropBlock> isPropValid) {
        IRitualPropBlock propBlock;
        BlockState propState = this.level.getBlockState(propPos);
        Block block = propState.getBlock();
        if (block instanceof IRitualPropBlock && isPropValid.test(propBlock = (IRitualPropBlock)block)) {
            propBlock.openProp(propState, this.level, propPos, this.getActivePlayer(), this.worldPosition);
            this.awaitedPropPos = propPos;
            this.nextCheckCount = this.activeCount + 20;
            return true;
        }
        return false;
    }

    protected void onPropInterrupted(Block block, BlockState propState, ResourceLocation expectedId) {
        Block expectedProp = (Block)Services.BLOCKS_REGISTRY.get(expectedId);
        if (this.getActivePlayer() != null) {
            if (expectedProp == null) {
                this.getActivePlayer().displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.prop_interrupt.empty"), false);
            } else {
                this.getActivePlayer().displayClientMessage((Component)Component.translatable((String)"ritual.primalmagick.warning.prop_interrupt", (Object[])new Object[]{expectedProp.getName()}), false);
            }
            this.skipWarningMessage = true;
        }
        if (block instanceof IRitualPropBlock) {
            ((IRitualPropBlock)block).closeProp(propState, this.level, this.awaitedPropPos);
        }
        this.awaitedPropPos = null;
        this.addStability(Mth.clamp((float)(50.0f * Math.min(0.0f, this.calculateStabilityDelta())), (float)-25.0f, (float)-1.0f));
    }

    public void onPropActivation(BlockPos propPos, float stabilityBonus) {
        if (this.awaitedPropPos != null && this.awaitedPropPos.equals((Object)propPos)) {
            BlockState propState = this.level.getBlockState(propPos);
            Block block = propState.getBlock();
            if (block instanceof IRitualPropBlock) {
                IRitualPropBlock propBlock = (IRitualPropBlock)block;
                propBlock.closeProp(propState, this.level, propPos);
                this.addStability(stabilityBonus);
            }
            this.currentStepComplete = true;
            this.nextCheckCount = this.activeCount;
            this.awaitedPropPos = null;
            this.setChanged();
            this.syncTile(false);
        }
    }

    protected void addStability(float delta) {
        this.stability = Mth.clamp((float)(this.stability + delta), (float)-100.0f, (float)25.0f);
    }

    public float calculateStabilityDelta() {
        MutableFloat retVal = new MutableFloat(0.0f);
        this.getActiveRecipe().ifPresent(recipeHolder -> retVal.subtract(0.01f * (float)((IRitualRecipe)recipeHolder.value()).getInstability()));
        Block block = this.getBlockState().getBlock();
        if (block instanceof RitualAltarBlock) {
            RitualAltarBlock altarBlock = (RitualAltarBlock)block;
            int safeSaltCount = altarBlock.getMaxSafeSalt();
            if (this.saltPositions.size() > safeSaltCount) {
                retVal.subtract(0.001f * (float)(this.saltPositions.size() - safeSaltCount));
            }
        }
        retVal.add(this.symmetryDelta);
        return retVal.floatValue();
    }

    protected void spawnOfferingParticles(BlockPos startPos, ItemStack stack) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double sx = (double)startPos.getX() + 0.4 + this.level.random.nextDouble() * 0.2;
            double sy = (double)startPos.getY() + 1.4 + this.level.random.nextDouble() * 0.2;
            double sz = (double)startPos.getZ() + 0.4 + this.level.random.nextDouble() * 0.2;
            PacketHandler.sendToAllAround(new OfferingChannelPacket(sx, sy, sz, this.worldPosition.above(2), stack), serverLevel, startPos, 32.0);
        }
    }

    protected void spawnSuccessParticles() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.2, (double)this.worldPosition.getZ() + 0.5, 15, 0.0, 0.0, 0.0, 0.1);
        }
    }

    protected void doMishap() {
        int attempts = 0;
        while (attempts++ < 25) {
            Mishap mishap = this.mishaps.getRandom(this.level.random);
            if (mishap == null || !mishap.execute(this.stability)) continue;
            this.addStability(5.0f + 5.0f * this.level.random.nextFloat());
            StatsManager.incrementValue(this.getActivePlayer(), StatsPM.RITUAL_MISHAPS);
            break;
        }
    }

    protected void doMishapEffects(BlockPos target, boolean playSound) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos source = this.worldPosition.above(2);
            PacketHandler.sendToAllAround(new SpellBoltPacket(source, target, this.getOrbColor().getRGB()), serverLevel, source, 32.0);
            if (playSound) {
                this.level.playSound(null, source, SoundsPM.ELECTRIC.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(this.level.random.nextGaussian() * 0.05));
            }
        }
    }

    protected void mishapOffering(boolean destroy) {
        int attempts = 0;
        while (attempts++ < 25 && !this.pedestalPositions.isEmpty()) {
            OfferingPedestalTileEntity pedestalTile;
            BlockPos pedestalPos = this.pedestalPositions.get(this.level.random.nextInt(this.pedestalPositions.size()));
            BlockEntity tile = this.level.getBlockEntity(pedestalPos);
            if (!(tile instanceof OfferingPedestalTileEntity) || (pedestalTile = (OfferingPedestalTileEntity)tile).getItem().isEmpty()) continue;
            if (destroy) {
                pedestalTile.setItem(ItemStack.EMPTY);
            } else {
                pedestalTile.dropContents(this.level, pedestalPos);
            }
            pedestalTile.setChanged();
            pedestalTile.syncTile(false);
            this.doMishapEffects(pedestalPos, true);
            break;
        }
    }

    protected void mishapSalt(boolean multiple) {
        int breakCount = multiple ? 2 + this.level.random.nextInt(4) : 1;
        block0: for (int breakIndex = 0; breakIndex < breakCount; ++breakIndex) {
            int attempts = 0;
            while (attempts++ < 25 && !this.saltPositions.isEmpty()) {
                BlockPos saltPos = this.saltPositions.get(this.level.random.nextInt(this.saltPositions.size()));
                Block block = this.level.getBlockState(saltPos).getBlock();
                if (block != BlocksPM.SALT_TRAIL.get()) continue;
                Containers.dropItemStack((Level)this.level, (double)((double)saltPos.getX() + 0.5), (double)((double)saltPos.getY() + 0.5), (double)((double)saltPos.getZ() + 0.5), (ItemStack)new ItemStack((ItemLike)ItemsPM.REFINED_SALT.get()));
                this.level.removeBlock(saltPos, false);
                this.doMishapEffects(saltPos, breakIndex == 0);
                continue block0;
            }
        }
        this.scanDirty = true;
    }

    protected void mishapDamage(boolean allTargets) {
        List<LivingEntity> targets = EntityUtils.getEntitiesInRange(this.level, this.worldPosition, null, LivingEntity.class, 10.0);
        if (targets != null && !targets.isEmpty()) {
            for (int index = 0; index < targets.size(); ++index) {
                LivingEntity target = targets.get(index);
                int damage = 5 + Mth.floor((double)(Math.sqrt(Math.abs(Math.min(0.0f, this.stability))) / 2.0));
                int amp = Math.max(0, damage - 6);
                target.hurt(target.damageSources().magic(), (float)damage);
                target.addEffect(new MobEffectInstance(EffectsPM.MANA_IMPEDANCE.getHolder(), 12000, amp));
                this.doMishapEffects(target.blockPosition(), index == 0);
                if (!allTargets) break;
            }
        }
    }

    protected void mishapDetonate(boolean central) {
        BlockPos target = null;
        if (central) {
            target = this.worldPosition;
        } else {
            int attempts = 0;
            while (attempts++ < 25 && !this.pedestalPositions.isEmpty()) {
                OfferingPedestalTileEntity pedestalTile;
                BlockPos pedestalPos = this.pedestalPositions.get(this.level.random.nextInt(this.pedestalPositions.size()));
                BlockEntity tile = this.level.getBlockEntity(pedestalPos);
                if (!(tile instanceof OfferingPedestalTileEntity) || (pedestalTile = (OfferingPedestalTileEntity)tile).getItem().isEmpty()) continue;
                target = pedestalPos;
                break;
            }
            if (target == null && !this.pedestalPositions.isEmpty()) {
                target = this.pedestalPositions.get(this.level.random.nextInt(this.pedestalPositions.size()));
            }
        }
        if (target != null) {
            BlockState state;
            Block block;
            if (central && this.awaitedPropPos != null && (block = (state = this.level.getBlockState(this.awaitedPropPos)).getBlock()) instanceof IRitualPropBlock) {
                ((IRitualPropBlock)block).closeProp(state, this.level, this.awaitedPropPos);
            }
            if (!central) {
                this.doMishapEffects(target, true);
                this.scanDirty = true;
            }
            float force = central ? 3.0f + this.level.random.nextFloat() : 2.0f;
            this.level.explode(null, (double)target.getX() + 0.5, (double)target.getY() + 0.5, (double)target.getZ() + 0.5, force, Level.ExplosionInteraction.TNT);
        }
    }

    public ItemStack getItem() {
        return this.getItem(0, 0);
    }

    public ItemStack getSyncedStack() {
        return (ItemStack)((NonNullList)this.syncedInventories.get(0)).get(0);
    }

    public void setItem(ItemStack stack) {
        this.setItem(0, 0, stack);
    }

    @Override
    protected int getInventoryCount() {
        return 1;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return inventoryIndex == 0 ? 1 : 0;
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return Optional.of(0);
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).itemValidFunction((slot, stack) -> false).build());
        return retVal;
    }
}

