/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.rituals;

import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class OfferingPedestalTileEntity
extends AbstractTileSidedInventoryPM {
    public static final int INPUT_INV_INDEX = 0;
    protected BlockPos altarPos = null;

    public OfferingPedestalTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.OFFERING_PEDESTAL.get(), pos, state);
    }

    @Override
    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return inventoryIndex == 0 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
    }

    @Nullable
    public BlockPos getAltarPos() {
        return this.altarPos;
    }

    public void setAltarPos(@Nullable BlockPos pos) {
        this.altarPos = pos;
        this.setChanged();
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.altarPos = compound.contains("AltarPos", 4) ? BlockPos.of((long)compound.getLong("AltarPos")) : null;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (this.altarPos != null) {
            compound.putLong("AltarPos", this.altarPos.asLong());
        }
    }

    public ItemStack getItem() {
        return this.getItem(0, 0);
    }

    public ItemStack getSyncedStack() {
        return (ItemStack)((NonNullList)this.syncedInventories.get(0)).get(0);
    }

    public void setItem(ItemStack stack) {
        this.setItem(0, 0, stack);
    }

    public ItemStack removeItem(int count) {
        return ((IItemHandlerPM)this.itemHandlers.get(0)).extractItem(0, count, false);
    }

    @Override
    protected int getInventoryCount() {
        return 1;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return inventoryIndex == 0 ? 1 : 0;
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return Optional.of(0);
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).slotLimitFunction(slot -> 1).build());
        return retVal;
    }

    @Override
    public Optional<IItemHandlerPM> getTargetRandomizedInventory() {
        return Optional.ofNullable((IItemHandlerPM)this.itemHandlers.get(0));
    }
}

