/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.rituals;

import com.verdantartifice.primalmagick.common.blocks.rituals.EntropySinkBlock;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.rituals.AbstractRitualPropTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EntropySinkTileEntity
extends AbstractRitualPropTileEntity {
    public static final int TICKS_PER_GLOW = 1200;
    protected int glowTicks;
    protected boolean isGlowing;

    public EntropySinkTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.ENTROPY_SINK.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EntropySinkTileEntity entity) {
        if (entity.isGlowing) {
            ++entity.glowTicks;
        }
        if (entity.glowTicks >= 1200) {
            entity.isGlowing = false;
            entity.glowTicks = 0;
            level.setBlock(pos, (BlockState)state.setValue((Property)EntropySinkBlock.LIT, (Comparable)Boolean.FALSE), 11);
        }
    }

    public int getGlowTicks() {
        return this.glowTicks;
    }

    public boolean isGlowing() {
        return this.isGlowing;
    }

    public void startGlowing() {
        if (this.isGlowing) {
            this.glowTicks = 0;
        } else {
            this.isGlowing = true;
        }
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, 0);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.isGlowing = true;
            this.glowTicks = 0;
            return true;
        }
        return super.triggerEvent(id, type);
    }
}

