/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.rituals;

import com.verdantartifice.primalmagick.common.rituals.IRitualPropTileEntity;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualAltarTileEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractRitualPropTileEntity
extends AbstractTilePM
implements IRitualPropTileEntity {
    protected BlockPos altarPos = null;
    protected boolean isOpen = false;

    public AbstractRitualPropTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean isPropOpen() {
        return this.isOpen;
    }

    @Override
    public void setPropOpen(boolean open) {
        this.isOpen = open;
        this.setChanged();
    }

    @Override
    @Nullable
    public BlockPos getAltarPos() {
        return this.altarPos;
    }

    @Override
    public void setAltarPos(@Nullable BlockPos pos) {
        this.altarPos = pos;
        this.setChanged();
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.altarPos = compound.contains("AltarPos", 4) ? BlockPos.of((long)compound.getLong("AltarPos")) : null;
        this.isOpen = compound.contains("PropOpen", 1) ? compound.getBoolean("PropOpen") : false;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (this.altarPos != null) {
            compound.putLong("AltarPos", this.altarPos.asLong());
        }
        compound.putBoolean("PropOpen", this.isOpen);
    }

    @Override
    public void notifyAltarOfPropActivation(float stabilityBonus) {
        BlockEntity tile;
        if (this.altarPos != null && (tile = this.level.getBlockEntity(this.altarPos)) instanceof RitualAltarTileEntity) {
            RitualAltarTileEntity altarTile = (RitualAltarTileEntity)tile;
            altarTile.onPropActivation(this.worldPosition, stabilityBonus);
        }
    }
}

