/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.misc;

import com.verdantartifice.primalmagick.common.blocks.misc.CarvedBookshelfBlock;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class CarvedBookshelfTileEntity
extends AbstractTileSidedInventoryPM {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int BOOK_CAPACITY = 6;
    private int lastInteractedSlot = -1;

    public CarvedBookshelfTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.CARVED_BOOKSHELF.get(), pos, state);
    }

    public int getLastInteractedSlot() {
        return this.lastInteractedSlot;
    }

    @Override
    protected int getInventoryCount() {
        return 1;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0 -> 6;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return Optional.of(0);
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).slotLimitFunction(slot -> 1).itemValidFunction((slot, stack) -> stack.is(ItemTags.BOOKSHELF_BOOKS)).contentsChangedFunction(this::updateState).build());
        return retVal;
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.lastInteractedSlot = pTag.getInt("LastInteractedSlot");
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("LastInteractedSlot", this.lastInteractedSlot);
    }

    @Override
    public Optional<IItemHandlerPM> getTargetRandomizedInventory() {
        return Optional.ofNullable((IItemHandlerPM)this.itemHandlers.get(0));
    }

    protected void updateState(int slot) {
        if (slot >= 0 && slot < 6) {
            this.lastInteractedSlot = slot;
            BlockState state = this.getBlockState();
            for (int index = 0; index < CarvedBookshelfBlock.SLOT_OCCUPIED_PROPERTIES.size(); ++index) {
                state = (BlockState)state.setValue((Property)CarvedBookshelfBlock.SLOT_OCCUPIED_PROPERTIES.get(index), (Comparable)Boolean.valueOf(!this.getItem(0, index).isEmpty()));
            }
            Objects.requireNonNull(this.level).setBlock(this.worldPosition, state, 3);
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.worldPosition, GameEvent.Context.of((BlockState)state));
        } else {
            LOGGER.error("Expected slot 0-{}, got {}", (Object)5, (Object)slot);
        }
    }

    public void addBook(int slot, ItemStack bookStack) {
        if (bookStack.is(ItemTags.BOOKSHELF_BOOKS) && this.getItem(0, slot).isEmpty()) {
            this.setItem(0, slot, bookStack);
        }
    }

    public ItemStack removeBook(int slot) {
        return this.removeItem(0, slot, 1);
    }
}

