/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.menus.WandChargerMenu;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class WandChargerTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider {
    public static final int INPUT_INV_INDEX = 0;
    public static final int CHARGE_INV_INDEX = 1;
    protected int chargeTime;
    protected int chargeTimeTotal;
    protected final ContainerData chargerData = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return WandChargerTileEntity.this.chargeTime;
                }
                case 1: {
                    return WandChargerTileEntity.this.chargeTimeTotal;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    WandChargerTileEntity.this.chargeTime = value;
                    break;
                }
                case 1: {
                    WandChargerTileEntity.this.chargeTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public WandChargerTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.WAND_CHARGER.get(), pos, state);
    }

    @Override
    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return inventoryIndex == 1 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.chargeTime = compound.getInt("ChargeTime");
        this.chargeTimeTotal = compound.getInt("ChargeTimeTotal");
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("ChargeTime", this.chargeTime);
        compound.putInt("ChargeTimeTotal", this.chargeTimeTotal);
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
        return new WandChargerMenu(windowId, playerInv, this.getBlockPos(), this, this.chargerData);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WandChargerTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.isClientSide) {
            ItemStack inputStack = entity.getItem(0, 0);
            ItemStack chargeStack = entity.getItem(1, 0);
            if (!inputStack.isEmpty() && !chargeStack.isEmpty()) {
                if (entity.canCharge()) {
                    ++entity.chargeTime;
                    if (entity.chargeTime >= entity.chargeTimeTotal) {
                        entity.chargeTime = 0;
                        entity.chargeTimeTotal = entity.getChargeTimeTotal();
                        entity.doCharge();
                        shouldMarkDirty = true;
                    }
                } else {
                    entity.chargeTime = 0;
                }
            } else if (entity.chargeTime > 0) {
                entity.chargeTime = Mth.clamp((int)(entity.chargeTime - 2), (int)0, (int)entity.chargeTimeTotal);
            }
        }
        if (shouldMarkDirty) {
            entity.setChanged();
            entity.syncTile(true);
        }
    }

    protected int getChargeTimeTotal() {
        return 200;
    }

    @VisibleForTesting
    public boolean canCharge() {
        Item item;
        ItemStack inputStack = this.getItem(0, 0);
        ItemStack chargeStack = this.getItem(1, 0);
        if (inputStack != null && !inputStack.isEmpty() && (item = inputStack.getItem()) instanceof EssenceItem) {
            EssenceItem essence = (EssenceItem)item;
            if (chargeStack != null && !chargeStack.isEmpty() && chargeStack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())) {
                ManaStorage manaCap = (ManaStorage)chargeStack.get(DataComponentsPM.CAPABILITY_MANA_STORAGE.get());
                return manaCap.getManaStored(essence.getSource()) < manaCap.getMaxManaStored(essence.getSource());
            }
        }
        return false;
    }

    @VisibleForTesting
    public void doCharge() {
        ItemStack inputStack = this.getItem(0, 0);
        ItemStack chargeStack = this.getItem(1, 0);
        if (this.canCharge()) {
            EssenceItem essence = (EssenceItem)inputStack.getItem();
            if (chargeStack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())) {
                chargeStack.update(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY, manaCap -> {
                    manaCap.receiveMana(essence.getSource(), essence.getEssenceType().getManaEquivalent(), false);
                    return manaCap;
                });
                chargeStack.set(DataComponentsPM.LAST_UPDATED.get(), (Object)System.currentTimeMillis());
            }
            inputStack.shrink(1);
        }
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag;
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        boolean bl = flag = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack);
        if (invIndex == 0 && !flag) {
            this.chargeTimeTotal = this.getChargeTimeTotal();
            this.chargeTime = 0;
            this.setChanged();
        }
    }

    @Override
    protected int getInventoryCount() {
        return 2;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 1 -> 1;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.UP -> Optional.of(0);
            case Direction.DOWN -> Optional.empty();
            default -> Optional.of(1);
        };
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).itemValidFunction((slot, stack) -> stack.getItem() instanceof EssenceItem).build());
        retVal.set(1, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), this).itemValidFunction((slot, stack) -> stack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())).build());
        return retVal;
    }
}

