/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.mana.network.IManaRelay;
import com.verdantartifice.primalmagick.common.mana.network.RouteManager;
import com.verdantartifice.primalmagick.common.mana.network.RouteTable;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.ITieredDeviceBlockEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class ManaRelayTileEntity
extends AbstractTilePM
implements ITieredDeviceBlockEntity,
IManaRelay {
    public static final int BOB_CYCLE_TIME_TICKS = 200;
    protected static final int TICKS_PER_PHASE = 40;
    protected static final List<Source> ALLOWED_SOURCES = Arrays.asList(Sources.EARTH, Sources.SEA, Sources.SKY, Sources.SUN, Sources.MOON);
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected int ticks = 0;
    protected Source lastSource = Sources.SKY;
    protected Source nextSource = Sources.SKY;

    public ManaRelayTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.MANA_RELAY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ManaRelayTileEntity entity) {
        if (entity.ticks++ % 40 == 0) {
            entity.nextPhase();
        }
    }

    protected void nextPhase() {
        if (this.level != null) {
            this.lastSource = this.nextSource;
            Source[] nextPossibleSources = (Source[])ALLOWED_SOURCES.stream().filter(s -> !s.equals(this.lastSource)).toArray(Source[]::new);
            this.nextSource = nextPossibleSources[this.level.random.nextInt(nextPossibleSources.length)];
        }
        this.setChanged();
        this.syncTile(true);
    }

    public int getCurrentColor(float partialTicks) {
        if (this.ticks % 40 == 0) {
            return this.nextSource.getColor();
        }
        int lastColor = this.lastSource.getColor();
        int nextColor = this.nextSource.getColor();
        float blend = Mth.clamp((float)(((float)(this.ticks % 40) + partialTicks) / 20.0f), (float)0.0f, (float)1.0f);
        return FastColor.ARGB32.lerp((float)blend, (int)lastColor, (int)nextColor);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.ticks = pTag.getInt("Ticks");
        Source last = Sources.get(ResourceLocation.parse((String)pTag.getString("LastSource")));
        this.lastSource = last == null ? Sources.EARTH : last;
        Source next = Sources.get(ResourceLocation.parse((String)pTag.getString("NextSource")));
        this.nextSource = next == null ? Sources.EARTH : next;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("Ticks", this.ticks);
        pTag.putString("LastSource", this.lastSource.getId().toString());
        pTag.putString("NextSource", this.nextSource.getId().toString());
    }

    @Override
    public boolean canRelay(Source source) {
        return true;
    }

    @Override
    public int getNetworkRange() {
        return switch (this.getDeviceTier()) {
            default -> throw new MatchException(null, null);
            case DeviceTier.BASIC -> 5;
            case DeviceTier.ENCHANTED -> 10;
            case DeviceTier.FORBIDDEN -> 15;
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> 20;
        };
    }

    @Override
    public int getManaThroughput() {
        return switch (this.getDeviceTier()) {
            default -> throw new MatchException(null, null);
            case DeviceTier.BASIC -> 400;
            case DeviceTier.ENCHANTED -> 800;
            case DeviceTier.FORBIDDEN -> 1600;
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> 3200;
        };
    }

    @Override
    @NotNull
    public RouteTable getRouteTable() {
        return RouteManager.getRouteTable(this.getLevel());
    }
}

