/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.mana.network.IManaConsumer;
import com.verdantartifice.primalmagick.common.mana.network.RouteManager;
import com.verdantartifice.primalmagick.common.mana.network.RouteTable;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.common.tiles.base.ITieredDeviceBlockEntity;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ManaInjectorTileEntity
extends AbstractTilePM
implements ITieredDeviceBlockEntity,
IManaConsumer,
IOwnedTileEntity {
    protected static final int TICKS_PER_PHASE = 40;
    protected static final List<Source> ALLOWED_SOURCES = Arrays.asList(Sources.EARTH, Sources.SEA, Sources.SKY, Sources.SUN, Sources.MOON);
    protected int ticks = 0;
    protected Source lastSource = Sources.SKY;
    protected Source nextSource = Sources.SKY;
    protected UUID ownerUUID;

    public ManaInjectorTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.MANA_INJECTOR.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        String ownerUUIDStr;
        super.loadAdditional(compound, registries);
        this.ownerUUID = null;
        if (compound.contains("OwnerUUID") && !(ownerUUIDStr = compound.getString("OwnerUUID")).isEmpty()) {
            this.ownerUUID = UUID.fromString(ownerUUIDStr);
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (this.ownerUUID != null) {
            compound.putString("OwnerUUID", this.ownerUUID.toString());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ManaInjectorTileEntity entity) {
        if (entity.ticks % 40 == 0) {
            entity.nextPhase();
        }
        if (!level.isClientSide && entity.ticks % 5 == 0) {
            entity.getConnectedStorage().ifPresent(storage -> {
                int throughput = entity.getManaThroughput();
                int totalSiphoned = Sources.streamSorted().filter(entity::canConsume).mapToInt(s -> entity.doSiphon(entity.getTileOwner(), level, (Source)s, Math.min(throughput, storage.getMaxManaStored((Source)s) - storage.getManaStored((Source)s)))).sum();
                Player patt0$temp = entity.getTileOwner();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    CriteriaTriggersPM.MANA_NETWORK_SIPHON.get().trigger(serverPlayer, totalSiphoned);
                }
            });
        }
        ++entity.ticks;
    }

    @Override
    public void setTileOwner(@Nullable Player owner) {
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    @Override
    @Nullable
    public Player getTileOwner() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getServer().getPlayerList().getPlayer(this.ownerUUID);
        }
        return null;
    }

    protected void nextPhase() {
        if (this.level != null) {
            this.lastSource = this.nextSource;
            Source[] nextPossibleSources = (Source[])ALLOWED_SOURCES.stream().filter(s -> !s.equals(this.lastSource)).toArray(Source[]::new);
            this.nextSource = nextPossibleSources[this.level.random.nextInt(nextPossibleSources.length)];
        }
        this.setChanged();
        this.syncTile(true);
    }

    public int getCurrentColor(float partialTicks) {
        if (this.ticks % 40 == 0) {
            return this.nextSource.getColor();
        }
        int lastColor = this.lastSource.getColor();
        int nextColor = this.nextSource.getColor();
        float blend = Mth.clamp((float)(((float)(this.ticks % 40) + partialTicks) / 20.0f), (float)0.0f, (float)1.0f);
        return FastColor.ARGB32.lerp((float)blend, (int)lastColor, (int)nextColor);
    }

    protected Optional<IManaStorage<?>> getConnectedStorage() {
        Level level = this.getLevel();
        return level != null ? Services.CAPABILITIES.manaStorage(level, this.getBlockPos().below(), Direction.UP) : Optional.empty();
    }

    @Override
    public boolean canConsume(@NotNull Source source) {
        return this.getConnectedStorage().map(cap -> cap.canReceive(source)).orElse(false);
    }

    @Override
    public int receiveMana(@NotNull Source source, int maxReceive, boolean simulate) {
        return this.getConnectedStorage().map(cap -> cap.receiveMana(source, maxReceive, simulate)).orElse(0);
    }

    @Override
    public int getNetworkRange() {
        return 5;
    }

    @Override
    public int getManaThroughput() {
        return switch (this.getDeviceTier()) {
            default -> throw new MatchException(null, null);
            case DeviceTier.BASIC -> 400;
            case DeviceTier.ENCHANTED -> 800;
            case DeviceTier.FORBIDDEN -> 1600;
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> 3200;
        };
    }

    @Override
    @NotNull
    public RouteTable getRouteTable() {
        return RouteManager.getRouteTable(this.getLevel());
    }
}

