/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.mojang.serialization.DynamicOps;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.mana.network.IManaConsumer;
import com.verdantartifice.primalmagick.common.mana.network.IManaNetworkNode;
import com.verdantartifice.primalmagick.common.mana.network.IManaSupplier;
import com.verdantartifice.primalmagick.common.mana.network.RouteManager;
import com.verdantartifice.primalmagick.common.mana.network.RouteTable;
import com.verdantartifice.primalmagick.common.menus.ManaBatteryMenu;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IManaContainingBlockEntity;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.common.tiles.base.ITieredDeviceBlockEntity;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class ManaBatteryTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IManaContainingBlockEntity,
IManaSupplier,
IManaConsumer,
ITieredDeviceBlockEntity,
IOwnedTileEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int CHARGE_INV_INDEX = 1;
    protected int chargeTime;
    protected int chargeTimeTotal;
    protected int fontSiphonTime;
    protected ManaStorage manaStorage;
    protected UUID ownerUUID;
    protected final ContainerData chargerData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> ManaBatteryTileEntity.this.chargeTime;
                case 1 -> ManaBatteryTileEntity.this.chargeTimeTotal;
                case 2 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Sources.EARTH);
                case 3 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Sources.EARTH);
                case 4 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Sources.SEA);
                case 5 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Sources.SEA);
                case 6 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Sources.SKY);
                case 7 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Sources.SKY);
                case 8 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Sources.SUN);
                case 9 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Sources.SUN);
                case 10 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Sources.MOON);
                case 11 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Sources.MOON);
                case 12 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Sources.BLOOD);
                case 13 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Sources.BLOOD);
                case 14 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Sources.INFERNAL);
                case 15 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Sources.INFERNAL);
                case 16 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Sources.VOID);
                case 17 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Sources.VOID);
                case 18 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Sources.HALLOWED);
                case 19 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Sources.HALLOWED);
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ManaBatteryTileEntity.this.chargeTime = value;
                    break;
                }
                case 1: {
                    ManaBatteryTileEntity.this.chargeTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 20;
        }
    };

    public ManaBatteryTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.MANA_BATTERY.get(), pos, state);
        this.manaStorage = new ManaStorage(this.getBatteryCapacity(), this.getBatteryTransferCap(), Sources.getAllSorted().toArray(new Source[0]));
    }

    public IManaStorage<?> getUncachedManaStorage() {
        return this.manaStorage;
    }

    protected int getBatteryCapacity() {
        return switch (this.getDeviceTier()) {
            case DeviceTier.FORBIDDEN -> 4 * WandGem.WIZARD.getCapacity();
            case DeviceTier.HEAVENLY -> 4 * WandGem.ARCHMAGE.getCapacity();
            case DeviceTier.CREATIVE -> -1;
            default -> 0;
        };
    }

    @VisibleForTesting
    public int getBatteryTransferCap() {
        return switch (this.getDeviceTier()) {
            case DeviceTier.FORBIDDEN -> WandCap.HEXIUM.getSiphonAmount();
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> WandCap.HALLOWSTEEL.getSiphonAmount();
            default -> 0;
        };
    }

    @Override
    public void setTileOwner(@Nullable Player owner) {
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    @Override
    @Nullable
    public Player getTileOwner() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getServer().getPlayerList().getPlayer(this.ownerUUID);
        }
        return null;
    }

    @Override
    public int extractMana(@NotNull Source source, int maxExtract, boolean simulate) {
        return this.manaStorage.extractMana(source, maxExtract, simulate);
    }

    @Override
    public int receiveMana(@NotNull Source source, int maxReceive, boolean simulate) {
        return this.manaStorage.receiveMana(source, maxReceive, simulate);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ManaBatteryTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.isClientSide) {
            ItemStack inputStack = entity.getItem(0, 0);
            ItemStack chargeStack = entity.getItem(1, 0);
            if (entity.fontSiphonTime % 5 == 0) {
                Player player;
                int throughput = entity.getManaThroughput();
                int totalSiphoned = Sources.streamSorted().filter(entity.manaStorage::canReceive).mapToInt(s -> entity.doSiphon(entity.getTileOwner(), level, (Source)s, Math.min(throughput, entity.manaStorage.getMaxManaStored((Source)s) - entity.manaStorage.getManaStored((Source)s)))).sum();
                if (totalSiphoned > 0) {
                    shouldMarkDirty = true;
                }
                if ((player = entity.getTileOwner()) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggersPM.MANA_NETWORK_SIPHON.get().trigger(serverPlayer, totalSiphoned);
                }
            }
            ++entity.fontSiphonTime;
            if (!inputStack.isEmpty()) {
                if (entity.canBreakDownEssence(inputStack)) {
                    ++entity.chargeTime;
                    if (entity.chargeTime >= entity.chargeTimeTotal) {
                        entity.chargeTime = 0;
                        entity.chargeTimeTotal = entity.getChargeTimeTotal();
                        entity.breakDownEssence(inputStack);
                        shouldMarkDirty = true;
                    }
                } else {
                    entity.chargeTime = 0;
                }
                for (Source source : Sources.getAllSorted()) {
                    if (!entity.canSiphonWand(inputStack, source) || !entity.doWandSiphon(inputStack, source)) continue;
                    shouldMarkDirty = true;
                }
            }
            if (!chargeStack.isEmpty()) {
                for (Source source : Sources.getAllSorted()) {
                    if (!entity.canOutputToWand(chargeStack, source)) continue;
                    entity.doOutput(chargeStack, source);
                    shouldMarkDirty = true;
                }
            }
        }
        if (shouldMarkDirty) {
            entity.setChanged();
            entity.syncTile(true);
        }
    }

    protected int getChargeTimeTotal() {
        return 100;
    }

    protected boolean canBreakDownEssence(ItemStack inputStack) {
        Item item;
        if (!inputStack.isEmpty() && (item = inputStack.getItem()) instanceof EssenceItem) {
            EssenceItem essenceItem = (EssenceItem)item;
            return this.manaStorage.getManaStored(essenceItem.getSource()) < this.manaStorage.getMaxManaStored(essenceItem.getSource());
        }
        return false;
    }

    protected void breakDownEssence(ItemStack inputStack) {
        Item item;
        if (this.canBreakDownEssence(inputStack) && (item = inputStack.getItem()) instanceof EssenceItem) {
            EssenceItem essenceItem = (EssenceItem)item;
            this.manaStorage.setMana(essenceItem.getSource(), this.manaStorage.getManaStored(essenceItem.getSource()) + essenceItem.getEssenceType().getManaEquivalent());
            inputStack.shrink(1);
        }
    }

    protected boolean canSiphonWand(ItemStack inputStack, Source source) {
        IWand wand;
        Item item;
        return !inputStack.isEmpty() && (item = inputStack.getItem()) instanceof IWand && (wand = (IWand)item).containsManaRaw(inputStack, source, 1) && this.manaStorage.getManaStored(source) < this.manaStorage.getMaxManaStored(source);
    }

    protected boolean doWandSiphon(ItemStack inputStack, Source source) {
        Item item;
        if (this.canSiphonWand(inputStack, source) && (item = inputStack.getItem()) instanceof IWand) {
            int centimanaToTransfer;
            IWand wand = (IWand)item;
            int maxTransferRate = Math.min(this.getBatteryTransferCap(), wand.getSiphonAmount(inputStack));
            int centimanaMissingInBattery = this.manaStorage.getMaxManaStored(source) - this.manaStorage.getManaStored(source);
            int centimanaPresentInWand = wand.getMana(inputStack, source);
            if (centimanaPresentInWand == -1) {
                centimanaPresentInWand = centimanaMissingInBattery;
            }
            if (wand.removeManaRaw(inputStack, source, centimanaToTransfer = Mth.clamp((int)Math.min(centimanaPresentInWand, centimanaMissingInBattery), (int)0, (int)maxTransferRate))) {
                this.manaStorage.receiveMana(source, centimanaToTransfer, false);
                return true;
            }
        }
        return false;
    }

    protected boolean canOutputToWand(ItemStack outputStack, Source source) {
        if (!(outputStack.isEmpty() || this.manaStorage.getMaxManaStored(source) != -1 && this.manaStorage.getManaStored(source) <= 0)) {
            return outputStack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get());
        }
        return false;
    }

    protected void doOutput(ItemStack outputStack, Source source) {
        if (this.canOutputToWand(outputStack, source) && outputStack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())) {
            outputStack.update(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY, stackManaStorage -> {
                int centimanaToTransfer = Math.min(this.getBatteryTransferCap(), this.manaStorage.getManaStored(source));
                int transferedCentimana = stackManaStorage.receiveMana(source, centimanaToTransfer, false);
                this.manaStorage.extractMana(source, transferedCentimana, false);
                return stackManaStorage;
            });
            outputStack.set(DataComponentsPM.LAST_UPDATED.get(), (Object)System.currentTimeMillis());
        }
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        String ownerUUIDStr;
        super.loadAdditional(compound, registries);
        this.chargeTime = compound.getInt("ChargeTime");
        this.chargeTimeTotal = compound.getInt("ChargeTimeTotal");
        this.fontSiphonTime = compound.getInt("FontSiphonTime");
        ManaStorage.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("ManaStorage")).resultOrPartial(msg -> LOGGER.error("Failed to decode mana storage: {}", msg)).ifPresent(mana -> mana.copyManaInto(this.manaStorage));
        this.ownerUUID = null;
        if (compound.contains("OwnerUUID") && !(ownerUUIDStr = compound.getString("OwnerUUID")).isEmpty()) {
            this.ownerUUID = UUID.fromString(ownerUUIDStr);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("ChargeTime", this.chargeTime);
        compound.putInt("ChargeTimeTotal", this.chargeTimeTotal);
        compound.putInt("FontSiphonTime", this.fontSiphonTime);
        ManaStorage.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.manaStorage).resultOrPartial(msg -> LOGGER.error("Failed to encode mana storage: {}", msg)).ifPresent(encoded -> compound.put("ManaStorage", encoded));
        if (this.ownerUUID != null) {
            compound.putString("OwnerUUID", this.ownerUUID.toString());
        }
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ManaBatteryMenu(pContainerId, pPlayerInventory, this.getBlockPos(), this, this.chargerData);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Sources.getAllSorted()) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Sources.EARTH);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.setChanged();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.setChanged();
        this.syncTile(true);
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag;
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        boolean bl = flag = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack);
        if (invIndex == 0 && !flag) {
            this.chargeTimeTotal = this.getChargeTimeTotal();
            this.chargeTime = 0;
            this.setChanged();
        }
    }

    @Override
    protected int getInventoryCount() {
        return 2;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 1 -> 1;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.UP -> Optional.of(0);
            case Direction.DOWN -> Optional.empty();
            default -> Optional.of(1);
        };
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).itemValidFunction((slot, stack) -> stack.getItem() instanceof IWand || stack.getItem() instanceof EssenceItem).build());
        retVal.set(1, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), this).itemValidFunction((slot, stack) -> stack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())).build());
        return retVal;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        ((ManaStorage)pComponentInput.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).copyManaInto(this.manaStorage);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)this.manaStorage);
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
        pTag.remove("ManaStorage");
    }

    @Override
    public boolean canSupply(@NotNull Source source) {
        return true;
    }

    @Override
    public boolean canConsume(@NotNull Source source) {
        return true;
    }

    @Override
    public int getNetworkRange() {
        return 5;
    }

    @Override
    public int getManaThroughput() {
        return this.getBatteryTransferCap();
    }

    @Override
    @NotNull
    public RouteTable getRouteTable() {
        return RouteManager.getRouteTable(this.getLevel());
    }

    @Override
    public void loadManaNetwork(@NotNull Level level) {
        if (!Services.CONFIG.enableManaNetworking()) {
            LOGGER.warn("Mana networking not enabled; skipping mana battery bootstrap");
            return;
        }
        level.getProfiler().push("loadManaNetwork");
        level.getProfiler().push("manaBattery");
        int range = this.getNetworkRange();
        int rangeSqr = range * range;
        level.getProfiler().push("findNodes");
        List<IManaNetworkNode> nodes = BlockPos.betweenClosedStream((AABB)new AABB(this.getBlockPos()).inflate((double)range)).filter(pos -> pos.distSqr((Vec3i)this.getBlockPos()) <= (double)rangeSqr).map(pos -> {
            IManaNetworkNode node;
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            return patt0$temp instanceof IManaNetworkNode ? (node = (IManaNetworkNode)patt0$temp) : null;
        }).filter(Objects::nonNull).toList();
        level.getProfiler().popPush("createDirectConsumerEdges");
        List<IManaConsumer> consumers = nodes.stream().map(node -> {
            IManaConsumer consumer;
            return node instanceof IManaConsumer ? (consumer = (IManaConsumer)node) : null;
        }).filter(Objects::nonNull).toList();
        consumers.forEach(consumer -> this.getRouteTable().add(this, (IManaConsumer)consumer));
        level.getProfiler().popPush("createDirectSupplierEdges");
        List<IManaSupplier> suppliers = nodes.stream().map(node -> {
            IManaSupplier supplier;
            return node instanceof IManaSupplier ? (supplier = (IManaSupplier)node) : null;
        }).filter(Objects::nonNull).toList();
        suppliers.forEach(supplier -> this.getRouteTable().add((IManaSupplier)supplier, this));
        level.getProfiler().pop();
        level.getProfiler().pop();
        level.getProfiler().pop();
    }
}

