/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.mana.network.IManaConsumer;
import com.verdantartifice.primalmagick.common.mana.network.RouteManager;
import com.verdantartifice.primalmagick.common.mana.network.RouteTable;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class AutoChargerTileEntity
extends AbstractTileSidedInventoryPM
implements IManaConsumer,
IOwnedTileEntity {
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected static final int INPUT_INV_INDEX = 0;
    protected int chargeTime;
    protected UUID ownerUUID;

    public AutoChargerTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.AUTO_CHARGER.get(), pos, state);
    }

    @Override
    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return inventoryIndex == 0 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        String ownerUUIDStr;
        super.loadAdditional(compound, registries);
        this.chargeTime = compound.getInt("ChargeTime");
        this.ownerUUID = null;
        if (compound.contains("OwnerUUID") && !(ownerUUIDStr = compound.getString("OwnerUUID")).isEmpty()) {
            this.ownerUUID = UUID.fromString(ownerUUIDStr);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("ChargeTime", this.chargeTime);
        if (this.ownerUUID != null) {
            compound.putString("OwnerUUID", this.ownerUUID.toString());
        }
    }

    @Override
    public void setTileOwner(@Nullable Player owner) {
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    @Override
    @Nullable
    public Player getTileOwner() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getServer().getPlayerList().getPlayer(this.ownerUUID);
        }
        return null;
    }

    @Override
    public int receiveMana(@NotNull Source source, int maxReceive, boolean simulate) {
        ItemStack chargeStack = this.getItem(0, 0);
        if (!this.getLevel().isClientSide() && chargeStack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())) {
            MutableInt actualReceived = new MutableInt(0);
            chargeStack.update(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY, manaCap -> {
                actualReceived.setValue(manaCap.receiveMana(source, maxReceive, simulate));
                return manaCap;
            });
            return actualReceived.intValue();
        }
        return 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AutoChargerTileEntity entity) {
        if (!level.isClientSide) {
            ItemStack chargeStack = entity.getItem(0, 0);
            if (entity.chargeTime % 5 == 0 && chargeStack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())) {
                ManaStorage manaStorage = (ManaStorage)chargeStack.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY);
                int throughput = entity.getManaThroughput();
                int totalSiphoned = Sources.streamSorted().filter(manaStorage::canReceive).mapToInt(s -> entity.doSiphon(entity.getTileOwner(), level, (Source)s, Math.min(throughput, manaStorage.getMaxManaStored((Source)s) - manaStorage.getManaStored((Source)s)))).sum();
                Player player = entity.getTileOwner();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggersPM.MANA_NETWORK_SIPHON.get().trigger(serverPlayer, totalSiphoned);
                }
            }
            ++entity.chargeTime;
        }
    }

    public ItemStack getItem() {
        return this.getItem(0, 0);
    }

    public ItemStack getSyncedStack() {
        return (ItemStack)((NonNullList)this.syncedInventories.get(0)).get(0);
    }

    public void setItem(ItemStack stack) {
        this.setItem(0, 0, stack);
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag;
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        boolean bl = flag = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack);
        if (invIndex == 0 && !flag) {
            this.chargeTime = 0;
            this.setChanged();
        }
    }

    @Override
    protected int getInventoryCount() {
        return 1;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return inventoryIndex == 0 ? 1 : 0;
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return Optional.of(0);
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).itemValidFunction((slot, stack) -> stack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())).build());
        return retVal;
    }

    @Override
    public int getNetworkRange() {
        return 5;
    }

    @Override
    public boolean canConsume(@NotNull Source source) {
        return true;
    }

    @Override
    public int getManaThroughput() {
        int n;
        ItemStack chargeStack = this.getItem(0, 0);
        Item item = chargeStack.getItem();
        if (item instanceof IWand) {
            IWand wand = (IWand)item;
            n = wand.getSiphonAmount(chargeStack);
        } else {
            n = 100;
        }
        return n;
    }

    @Override
    @NotNull
    public RouteTable getRouteTable() {
        return RouteManager.getRouteTable(this.getLevel());
    }
}

