/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.blocks.mana.AbstractManaFontBlock;
import com.verdantartifice.primalmagick.common.mana.network.IManaSupplier;
import com.verdantartifice.primalmagick.common.mana.network.RouteManager;
import com.verdantartifice.primalmagick.common.mana.network.RouteTable;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.ManaSparklePacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.ITieredDeviceBlockEntity;
import com.verdantartifice.primalmagick.common.wands.IInteractWithWand;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.common.wands.ManaManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;

public abstract class AbstractManaFontTileEntity
extends AbstractTilePM
implements IInteractWithWand,
IManaSupplier,
ITieredDeviceBlockEntity {
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected int ticksExisted = 0;
    protected int mana = this.getInitialMana();

    public AbstractManaFontTileEntity(BlockEntityType<? extends AbstractManaFontTileEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.mana = compound.getInt("mana");
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("mana", this.mana);
    }

    public int getMana() {
        return this.mana;
    }

    public boolean setMana(int mana) {
        int startMana = this.getMana();
        this.mana = Math.min(mana, this.getManaCapacity());
        return this.getMana() != startMana;
    }

    public int getManaCapacity() {
        int n;
        Block block = this.getBlockState().getBlock();
        if (block instanceof AbstractManaFontBlock) {
            AbstractManaFontBlock fontBlock = (AbstractManaFontBlock)block;
            n = fontBlock.getManaCapacity();
        } else {
            n = 0;
        }
        return n;
    }

    public int getManaRechargedPerTick() {
        return switch (this.getDeviceTier()) {
            default -> throw new MatchException(null, null);
            case DeviceTier.ENCHANTED -> 1;
            case DeviceTier.BASIC, DeviceTier.FORBIDDEN -> 5;
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> 25;
        };
    }

    protected abstract int getInitialMana();

    @Override
    public InteractionResult onWandRightClick(ItemStack wandStack, Level world, Player player, BlockPos pos, Direction direction) {
        Item item = wandStack.getItem();
        if (item instanceof IWand) {
            IWand wand = (IWand)item;
            wand.setPositionInUse(wandStack, this.getBlockPos());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void onWandUseTick(ItemStack wandStack, Level level, Player player, Vec3 targetPos, int count) {
        if (count % 5 == 0) {
            this.doSiphon(wandStack, level, player, targetPos);
        }
    }

    public void doSiphon(ItemStack wandStack, Level level, Player player, Vec3 targetPos) {
        Item item = wandStack.getItem();
        if (item instanceof IWand) {
            int tap;
            int leftover;
            AbstractManaFontBlock fontBlock;
            Source source;
            IWand wand = (IWand)item;
            Block block = this.getBlockState().getBlock();
            if (block instanceof AbstractManaFontBlock && (source = (fontBlock = (AbstractManaFontBlock)block).getSource()) != null && (leftover = ManaManager.addMana(player, wandStack, source, tap = Math.min(this.mana, wand.getSiphonAmount(wandStack)))) < tap) {
                this.mana -= tap - leftover;
                StatsManager.incrementValue(player, StatsPM.MANA_SIPHONED, (tap - leftover) / 100);
                this.setChanged();
                this.syncTile(true);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    PacketHandler.sendToAllAround(new ManaSparklePacket((Position)this.worldPosition.getCenter(), (Position)targetPos, 20, source), serverLevel, this.worldPosition, 32.0);
                }
            }
        }
    }

    @Override
    public int extractMana(@NotNull Source source, int maxExtract, boolean simulate) {
        AbstractManaFontBlock fontBlock;
        Source fontSource;
        Block block = this.getBlockState().getBlock();
        if (block instanceof AbstractManaFontBlock && source.equals(fontSource = (fontBlock = (AbstractManaFontBlock)block).getSource()) && !simulate) {
            int tap = Math.min(this.mana, maxExtract);
            this.mana -= tap;
            this.setChanged();
            this.syncTile(true);
            return tap;
        }
        return 0;
    }

    @VisibleForTesting
    public void doRecharge() {
        if (this.setMana(this.getMana() + this.getManaRechargedPerTick())) {
            this.setChanged();
            this.syncTile(true);
        }
    }

    @Override
    public int getNetworkRange() {
        return 5;
    }

    @Override
    public boolean canSupply(@NotNull Source source) {
        AbstractManaFontBlock fontBlock;
        Block block = this.getBlockState().getBlock();
        return block instanceof AbstractManaFontBlock && source.equals((fontBlock = (AbstractManaFontBlock)block).getSource());
    }

    @Override
    public int getManaThroughput() {
        return this.getManaCapacity();
    }

    @Override
    @NotNull
    public RouteTable getRouteTable() {
        return RouteManager.getRouteTable(this.getLevel());
    }
}

