/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.verdantartifice.primalmagick.common.blocks.devices.AbstractWindGeneratorBlock;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WindGeneratorTileEntity
extends AbstractTilePM {
    public WindGeneratorTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.WIND_GENERATOR.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WindGeneratorTileEntity entity) {
        Block block = state.getBlock();
        if (block instanceof AbstractWindGeneratorBlock) {
            AbstractWindGeneratorBlock block2 = (AbstractWindGeneratorBlock)block;
            if (((Boolean)state.getValue((Property)AbstractWindGeneratorBlock.POWERED)).booleanValue()) {
                int lineOfSightPower;
                int power = level.getBestNeighborSignal(pos);
                Direction facing = (Direction)state.getValue((Property)AbstractWindGeneratorBlock.FACING);
                if (power < 1) {
                    return;
                }
                for (lineOfSightPower = 0; lineOfSightPower < power && level.isEmptyBlock(pos.relative(facing, lineOfSightPower + 1)); ++lineOfSightPower) {
                }
                Direction windDir = block2.getWindDirection(state);
                Vec3 windStep = new Vec3(windDir.step()).scale(0.1 * ((double)power / 15.0));
                AABB zone = new AABB(pos).expandTowards(new Vec3(facing.step()).scale((double)lineOfSightPower));
                List affected = level.getEntitiesOfClass(Entity.class, zone, e -> !e.isSpectator() && (e instanceof ItemEntity || e instanceof LivingEntity));
                for (Entity affectedEntity : affected) {
                    affectedEntity.setDeltaMovement(affectedEntity.getDeltaMovement().add(windStep));
                }
            }
        }
    }
}

