/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.verdantartifice.primalmagick.common.blocks.devices.SunlampBlock;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class SunlampTileEntity
extends AbstractTilePM {
    private static final int LIGHT_THRESHOLD = 11;
    protected int ticksExisted = 0;

    public SunlampTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.SUNLAMP.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SunlampTileEntity entity) {
        ++entity.ticksExisted;
        if (!level.isClientSide && entity.ticksExisted % 5 == 0) {
            int x = level.random.nextInt(16) - level.random.nextInt(16);
            int y = level.random.nextInt(16) - level.random.nextInt(16);
            int z = level.random.nextInt(16) - level.random.nextInt(16);
            BlockPos bp = pos.offset(x, y, z);
            BlockPos rainHeight = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, bp);
            if (bp.getY() > rainHeight.getY() + 4) {
                bp = rainHeight.above(4);
            }
            if (bp.getY() < 1) {
                bp = new BlockPos(bp.getX(), 1, bp.getZ());
            }
            BlockPos finalPos = new BlockPos((Vec3i)bp);
            Block block = state.getBlock();
            if (block instanceof SunlampBlock) {
                SunlampBlock lampBlock = (SunlampBlock)block;
                lampBlock.getGlowField(level.registryAccess()).ifPresent(glow -> {
                    if (level.isEmptyBlock(finalPos) && !level.getBlockState(finalPos).is((Block)glow) && level.getBrightness(LightLayer.BLOCK, finalPos) < 11 && RayTraceUtils.hasLineOfSight(level, pos, finalPos)) {
                        level.setBlock(finalPos, glow.defaultBlockState(), 3);
                    }
                });
            }
        }
    }
}

