/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.ScribeTableMode;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerLinguistics;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.menus.AbstractScribeTableMenu;
import com.verdantartifice.primalmagick.common.menus.ScribeGainComprehensionMenu;
import com.verdantartifice.primalmagick.common.menus.ScribeStudyVocabularyMenu;
import com.verdantartifice.primalmagick.common.menus.ScribeTranscribeWorksMenu;
import com.verdantartifice.primalmagick.common.tags.BookLanguageTagsPM;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class ScribeTableTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider {
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int OUTPUT_INV_INDEX = 1;

    public ScribeTableTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.SCRIBE_TABLE.get(), pos, state);
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        Optional<IPlayerLinguistics> capOpt = Services.CAPABILITIES.linguistics(pPlayer);
        if (capOpt.isPresent()) {
            AbstractScribeTableMenu menu = switch (capOpt.get().getScribeTableMode()) {
                default -> throw new MatchException(null, null);
                case ScribeTableMode.STUDY_VOCABULARY -> new ScribeStudyVocabularyMenu(pContainerId, pPlayerInventory, this.getBlockPos(), this);
                case ScribeTableMode.GAIN_COMPREHENSION -> new ScribeGainComprehensionMenu(pContainerId, pPlayerInventory, this.getBlockPos(), this);
                case ScribeTableMode.TRANSCRIBE_WORKS -> new ScribeTranscribeWorksMenu(pContainerId, pPlayerInventory, this.getBlockPos(), this);
            };
            this.addInventoryChangeListener(Direction.UP, menu);
            return menu;
        }
        return null;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Override
    protected int getInventoryCount() {
        return 2;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0 -> 2;
            case 1 -> 1;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.DOWN -> Optional.of(1);
            default -> Optional.of(0);
        };
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).itemValidFunction((slot, stack) -> switch (slot) {
            case 0 -> {
                if (stack.is(ItemTagsPM.STATIC_BOOKS) && StaticBookItem.getBookLanguage(stack).map(lang -> lang.is(BookLanguageTagsPM.ANCIENT)).orElse(false).booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> stack.is(Items.WRITABLE_BOOK);
            default -> false;
        }).build());
        retVal.set(1, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), this).itemValidFunction((slot, stack) -> false).build());
        return retVal;
    }

    public void doTranscribe(Player player) {
        Level level = this.getLevel();
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack sourceStack = this.getItem(0, 0);
            ItemStack blankStack = this.getItem(0, 1);
            if (sourceStack.is(ItemTagsPM.STATIC_BOOKS) && blankStack.is(Items.WRITABLE_BOOK)) {
                Optional<Holder<BookLanguage>> sourceLanguageOpt = StaticBookItem.getBookLanguage(sourceStack);
                int sourceGeneration = StaticBookItem.getGeneration(sourceStack);
                if (sourceLanguageOpt.isPresent() && sourceLanguageOpt.get().is(BookLanguageTagsPM.ANCIENT) && sourceGeneration < 2) {
                    Services.CAPABILITIES.linguistics((Player)serverPlayer).ifPresent(linguistics -> {
                        int sourceComprehension;
                        ItemStack resultStack = sourceStack.copyWithCount(1);
                        int playerComprehension = linguistics.getComprehension(((ResourceKey)((Holder)sourceLanguageOpt.get()).unwrapKey().get()).location());
                        int maxComprehension = Math.max(playerComprehension, sourceComprehension = StaticBookItem.getTranslatedComprehension(sourceStack).orElse(0).intValue());
                        StaticBookItem.setTranslatedComprehension(resultStack, maxComprehension <= 0 ? Optional.empty() : Optional.of(maxComprehension));
                        StaticBookItem.setGeneration(resultStack, sourceGeneration + 1);
                        ItemStack existingStack = this.getItem(1, 0);
                        if (ItemStack.isSameItemSameComponents((ItemStack)resultStack, (ItemStack)existingStack) && existingStack.getCount() < existingStack.getMaxStackSize()) {
                            existingStack.grow(1);
                            blankStack.shrink(1);
                            this.setChanged();
                            this.syncTile(false);
                        } else if (existingStack.isEmpty()) {
                            this.setItem(1, 0, resultStack);
                            blankStack.shrink(1);
                            this.setChanged();
                            this.syncTile(false);
                        }
                    });
                }
            }
        }
    }
}

