/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.blocks.devices.SanguineCrucibleBlock;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.items.misc.SanguineCoreItem;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.WandPoofPacket;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class SanguineCrucibleTileEntity
extends AbstractTileSidedInventoryPM {
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int FLUID_CAPACITY = 1000;
    protected static final int FLUID_DRAIN = 200;
    protected static final int CHARGE_MAX = 100;
    protected static final int SPAWN_RANGE = 4;
    protected int souls;
    protected int fluidAmount;
    protected int charge;
    protected int counter = 0;

    public SanguineCrucibleTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.SANGUINE_CRUCIBLE.get(), pos, state);
    }

    @Override
    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return inventoryIndex == 0 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.souls = compound.getInt("Souls");
        this.fluidAmount = compound.getInt("FluidAmount");
        this.charge = compound.getInt("Charge");
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("Souls", this.souls);
        compound.putInt("FluidAmount", this.fluidAmount);
        compound.putInt("Charge", this.charge);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SanguineCrucibleTileEntity entity) {
        SanguineCoreItem core;
        ++entity.counter;
        if (entity.fluidAmount < 1000) {
            ++entity.fluidAmount;
        }
        if (entity.hasCore() && entity.fluidAmount >= 200 && (core = entity.getCoreItem()) != null && entity.souls >= core.getSoulsPerSpawn()) {
            ++entity.charge;
            if (entity.charge >= 100) {
                entity.charge = 0;
                entity.fluidAmount -= 200;
                entity.souls -= core.getSoulsPerSpawn();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ItemStack coreStack = entity.getItem(0, 0);
                    if (coreStack.isDamageableItem()) {
                        int newDamage = coreStack.getDamageValue() + 1;
                        if (newDamage >= coreStack.getMaxDamage()) {
                            coreStack.shrink(1);
                            entity.updateLitState();
                        } else {
                            coreStack.setDamageValue(newDamage);
                        }
                    } else {
                        coreStack.shrink(1);
                        entity.updateLitState();
                    }
                    int attempts = 0;
                    boolean success = false;
                    while (attempts++ < 50 && !success) {
                        success = entity.attemptSpawn(core.getEntityType());
                    }
                    PacketHandler.sendToAllAround(new WandPoofPacket(pos.above(), Color.WHITE.getRGB(), true, Direction.UP), serverLevel, pos, 32.0);
                    entity.setChanged();
                    entity.syncTile(true);
                }
            }
        }
    }

    protected void updateLitState() {
        if (this.hasLevel()) {
            this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)SanguineCrucibleBlock.LIT, (Comparable)Boolean.valueOf(!this.getItem().isEmpty())), 11);
        }
    }

    protected boolean attemptSpawn(EntityType<?> entityType) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double x = (double)this.worldPosition.getX() + 4.0 * (this.level.random.nextDouble() - this.level.random.nextDouble()) + 0.5;
        double y = (double)this.worldPosition.getY() + (double)this.level.random.nextInt(3) - 1.0;
        double z = (double)this.worldPosition.getZ() + 4.0 * (this.level.random.nextDouble() - this.level.random.nextDouble()) + 0.5;
        BlockPos spawnPos = BlockPos.containing((double)x, (double)y, (double)z);
        if (this.level.noCollision(entityType.getSpawnAABB(x, y, z))) {
            ServerLevel serverWorld = (ServerLevel)this.level;
            Entity entity = entityType.spawn(serverWorld, (ItemStack)null, (Player)null, spawnPos, MobSpawnType.SPAWNER, true, !Objects.equals(this.worldPosition, spawnPos));
            if (entity == null) {
                return false;
            }
            entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), this.level.random.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                Mob mobEntity = (Mob)entity;
                Services.EVENTS.finalizeMobSpawn(mobEntity, (ServerLevelAccessor)serverWorld, this.level.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
            }
            PacketHandler.sendToAllAround(new WandPoofPacket(x, y, z, Color.WHITE.getRGB(), true, Direction.UP), serverLevel, entity.blockPosition(), 32.0);
            return true;
        }
        return false;
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        if (invIndex == 0 && (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack))) {
            this.charge = 0;
            this.setChanged();
            this.syncTile(false);
        }
    }

    public int getSouls() {
        return this.souls;
    }

    public void addSouls(int count) {
        this.souls += count;
        this.setChanged();
        this.syncTile(false);
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public float getFluidHeight() {
        return 0.3f + 0.5f * ((float)this.getFluidAmount() / 1000.0f);
    }

    public int getCharge() {
        return this.charge;
    }

    public double getSmokeChance() {
        return (double)this.charge / 100.0;
    }

    public boolean hasCore() {
        return !this.getItem(0, 0).isEmpty();
    }

    public boolean showBubble(RandomSource rand) {
        return rand.nextBoolean() && this.counter % 5 == 0;
    }

    @Nullable
    protected SanguineCoreItem getCoreItem() {
        ItemStack stack = this.level.isClientSide ? this.getSyncedItem(0, 0) : this.getItem(0, 0);
        Item item = stack.getItem();
        if (item instanceof SanguineCoreItem) {
            SanguineCoreItem core = (SanguineCoreItem)item;
            return core;
        }
        return null;
    }

    public ItemStack getItem() {
        return this.getItem(0, 0);
    }

    public void setItem(ItemStack stack) {
        this.setItem(0, 0, stack);
    }

    public ItemStack removeItem(int count) {
        ItemStack stack = ((IItemHandlerPM)this.itemHandlers.get(0)).extractItem(0, count, false);
        if (!stack.isEmpty()) {
            this.syncSlots(null);
        }
        this.setChanged();
        return stack;
    }

    @Override
    protected int getInventoryCount() {
        return 1;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return inventoryIndex == 0 ? 1 : 0;
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.UP, Direction.DOWN -> Optional.empty();
            default -> Optional.of(0);
        };
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).slotLimitFunction(slot -> 1).itemValidFunction((slot, stack) -> stack.getItem() instanceof SanguineCoreItem).contentsChangedFunction(slot -> this.updateLitState()).build());
        return retVal;
    }
}

