/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.mojang.serialization.DynamicOps;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.menus.InfernalFurnaceMenu;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IManaContainingBlockEntity;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class InfernalFurnaceTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IManaContainingBlockEntity,
RecipeCraftingHolder,
StackedContentsCompatible {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final int SUPERCHARGE_MULTIPLIER = 5;
    protected static final int MANA_PER_HALF_SECOND = 100;
    protected static final int DEFAULT_COOK_TIME = 100;
    protected static final int LIT_GRACE_TICKS_MAX = 5;
    public static final int OUTPUT_INV_INDEX = 0;
    public static final int INPUT_INV_INDEX = 1;
    public static final int WAND_INV_INDEX = 2;
    protected int superchargeTime;
    protected int superchargeTimeTotal;
    protected int processTime;
    protected int processTimeTotal;
    protected int litGraceTicks;
    protected ManaStorage manaStorage;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected final ContainerData furnaceData = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return InfernalFurnaceTileEntity.this.processTime;
                }
                case 1: {
                    return InfernalFurnaceTileEntity.this.processTimeTotal;
                }
                case 2: {
                    return InfernalFurnaceTileEntity.this.manaStorage.getManaStored(Sources.INFERNAL);
                }
                case 3: {
                    return InfernalFurnaceTileEntity.this.manaStorage.getMaxManaStored(Sources.INFERNAL);
                }
                case 4: {
                    return InfernalFurnaceTileEntity.this.superchargeTime;
                }
                case 5: {
                    return InfernalFurnaceTileEntity.this.superchargeTimeTotal;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    InfernalFurnaceTileEntity.this.processTime = value;
                    break;
                }
                case 1: {
                    InfernalFurnaceTileEntity.this.processTimeTotal = value;
                    break;
                }
                case 4: {
                    InfernalFurnaceTileEntity.this.superchargeTime = value;
                    break;
                }
                case 5: {
                    InfernalFurnaceTileEntity.this.superchargeTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 6;
        }
    };

    public InfernalFurnaceTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.INFERNAL_FURNACE.get(), pos, state);
        this.manaStorage = new ManaStorage(10000, 1000, 1000, Sources.INFERNAL);
    }

    public IManaStorage<?> getUncachedManaStorage() {
        return this.manaStorage;
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.processTime = compound.getInt("ProcessTime");
        this.processTimeTotal = compound.getInt("ProcessTimeTotal");
        this.superchargeTime = compound.getInt("SuperchargeTime");
        this.superchargeTimeTotal = compound.getInt("SuperchargeTimeTotal");
        ManaStorage.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("ManaStorage")).resultOrPartial(msg -> LOGGER.error("Failed to decode mana storage: {}", msg)).ifPresent(mana -> mana.copyManaInto(this.manaStorage));
        CompoundTag recipesUsedTag = compound.getCompound("RecipesUsed");
        for (String key : recipesUsedTag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)key), recipesUsedTag.getInt(key));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("ProcessTime", this.processTime);
        compound.putInt("ProcessTimeTotal", this.processTimeTotal);
        compound.putInt("SuperchargeTime", this.superchargeTime);
        compound.putInt("SuperchargeTimeTotal", this.superchargeTimeTotal);
        ManaStorage.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.manaStorage).resultOrPartial(msg -> LOGGER.error("Failed to encode mana storage: {}", msg)).ifPresent(encoded -> compound.put("ManaStorage", encoded));
        CompoundTag recipesUsedTag = new CompoundTag();
        this.recipesUsed.forEach((key, value) -> recipesUsedTag.putInt(key.toString(), value.intValue()));
        compound.put("RecipesUsed", (Tag)recipesUsedTag);
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new InfernalFurnaceMenu(pContainerId, pPlayerInventory, this.getBlockPos(), this, this.furnaceData);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    private boolean isLit() {
        return this.processTime > 0 || this.litGraceTicks > 0;
    }

    private boolean isCharged() {
        int current = this.getMana(Sources.INFERNAL);
        return current > 0 && current >= InfernalFurnaceTileEntity.getManaNeeded(this.getLevel(), this);
    }

    private boolean isSupercharged() {
        return this.superchargeTime > 0;
    }

    private static Optional<RecipeHolder<SmeltingRecipe>> getActiveRecipe(Level level, InfernalFurnaceTileEntity entity) {
        return level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(entity.getItem(1, 0)), level);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, InfernalFurnaceTileEntity entity) {
        boolean fuelPopulated;
        int centimanaMissing;
        int centimanaToTransfer;
        IWand wand;
        Item item;
        ItemStack wandStack;
        boolean shouldMarkDirty = false;
        boolean startedLit = entity.isLit();
        entity.litGraceTicks = Mth.clamp((int)(entity.litGraceTicks - 1), (int)0, (int)5);
        if (!level.isClientSide && !(wandStack = entity.getItem(2, 1)).isEmpty() && (item = wandStack.getItem()) instanceof IWand && (wand = (IWand)item).consumeMana(wandStack, null, Sources.INFERNAL, centimanaToTransfer = Mth.clamp((int)(centimanaMissing = entity.manaStorage.getMaxManaStored(Sources.INFERNAL) - entity.manaStorage.getManaStored(Sources.INFERNAL)), (int)0, (int)100), (HolderLookup.Provider)level.registryAccess())) {
            entity.manaStorage.receiveMana(Sources.INFERNAL, centimanaToTransfer, false);
            shouldMarkDirty = true;
        }
        if (entity.isSupercharged()) {
            --entity.superchargeTime;
        }
        ItemStack fuelStack = entity.getItem(2, 0);
        boolean inputPopulated = !entity.getItem(1, 0).isEmpty();
        boolean bl = fuelPopulated = !fuelStack.isEmpty();
        if (entity.isCharged() && inputPopulated) {
            RecipeHolder recipeHolder = InfernalFurnaceTileEntity.getActiveRecipe(level, entity).orElse(null);
            int furnaceMaxStackSize = ((IItemHandlerPM)entity.itemHandlers.get(1)).getSlotLimit(0);
            if (!entity.isSupercharged() && fuelPopulated && InfernalFurnaceTileEntity.canBurn(level.registryAccess(), recipeHolder, entity, furnaceMaxStackSize)) {
                entity.superchargeTime = entity.superchargeTimeTotal = entity.getSuperchargeDuration(fuelStack);
                if (entity.isSupercharged()) {
                    shouldMarkDirty = true;
                    if (Services.ITEMS.hasCraftingRemainingItem(fuelStack)) {
                        entity.setItem(2, 0, Services.ITEMS.getCraftingRemainingItem(fuelStack));
                    } else {
                        fuelStack.shrink(1);
                        if (fuelStack.isEmpty()) {
                            entity.setItem(2, 0, ItemStack.EMPTY);
                        }
                    }
                }
            }
            if (entity.isCharged() && InfernalFurnaceTileEntity.canBurn(level.registryAccess(), recipeHolder, entity, furnaceMaxStackSize)) {
                entity.processTime = entity.processTime + (entity.isSupercharged() ? 5 : 1);
                if (entity.processTime >= entity.processTimeTotal) {
                    entity.processTime = 0;
                    entity.processTimeTotal = InfernalFurnaceTileEntity.getTotalCookTime(level, entity, 100);
                    entity.litGraceTicks = 5;
                    if (InfernalFurnaceTileEntity.burn(level.registryAccess(), recipeHolder, entity, furnaceMaxStackSize)) {
                        entity.setRecipeUsed(recipeHolder);
                    }
                    shouldMarkDirty = true;
                }
            } else {
                entity.processTime = 0;
            }
        } else if (entity.processTime > 0) {
            entity.processTime = Mth.clamp((int)(entity.processTime - 2), (int)0, (int)entity.processTimeTotal);
        }
        if (startedLit != entity.isLit()) {
            shouldMarkDirty = true;
            state = (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(entity.isLit()));
            level.setBlock(pos, state, 3);
        }
        if (shouldMarkDirty) {
            InfernalFurnaceTileEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private static boolean canBurn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipeHolder, InfernalFurnaceTileEntity entity, int maxFurnaceStackSize) {
        if (!entity.getItem(1, 0).isEmpty() && recipeHolder != null) {
            ItemStack recipeOutput = recipeHolder.value().assemble((RecipeInput)new SingleRecipeInput(entity.getItem(1, 0)), (HolderLookup.Provider)registryAccess);
            if (recipeOutput.isEmpty()) {
                return false;
            }
            ItemStack existingOutput = entity.getItem(0, 0);
            if (existingOutput.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)recipeOutput, (ItemStack)existingOutput)) {
                return false;
            }
            if (existingOutput.getCount() + recipeOutput.getCount() <= maxFurnaceStackSize && existingOutput.getCount() + recipeOutput.getCount() <= existingOutput.getMaxStackSize()) {
                return true;
            }
            return existingOutput.getCount() + recipeOutput.getCount() <= recipeOutput.getMaxStackSize();
        }
        return false;
    }

    private static boolean burn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipeHolder, InfernalFurnaceTileEntity entity, int maxFurnaceStackSize) {
        if (recipeHolder != null && InfernalFurnaceTileEntity.canBurn(registryAccess, recipeHolder, entity, maxFurnaceStackSize)) {
            ItemStack inputStack = entity.getItem(1, 0);
            ItemStack recipeOutput = recipeHolder.value().assemble((RecipeInput)new SingleRecipeInput(entity.getItem(1, 0)), (HolderLookup.Provider)registryAccess);
            ItemStack existingOutput = entity.getItem(0, 0);
            if (existingOutput.isEmpty()) {
                entity.setItem(0, 0, recipeOutput.copy());
            } else if (ItemStack.isSameItem((ItemStack)recipeOutput, (ItemStack)existingOutput)) {
                existingOutput.grow(recipeOutput.getCount());
            }
            if (entity.manaStorage.canExtract(Sources.INFERNAL)) {
                entity.manaStorage.extractMana(Sources.INFERNAL, InfernalFurnaceTileEntity.getManaNeeded(entity.getLevel(), entity), false);
            }
            inputStack.shrink(1);
            return true;
        }
        return false;
    }

    protected int getSuperchargeDuration(ItemStack pFuel) {
        if (pFuel.isEmpty()) {
            return 0;
        }
        return Services.EVENTS.getBurnTime(pFuel, RecipeType.SMELTING) / 5;
    }

    protected static int getTotalCookTime(Level pLevel, InfernalFurnaceTileEntity pBlockEntity, int defaultTime) {
        return InfernalFurnaceTileEntity.getActiveRecipe(pLevel, pBlockEntity).map(RecipeHolder::value).map(AbstractCookingRecipe::getCookingTime).map(t -> t / 2).orElse(defaultTime);
    }

    private static int getManaNeeded(Level pLevel, InfernalFurnaceTileEntity pBlockEntity) {
        return pBlockEntity.getItem(1, 0).isEmpty() ? 0 : InfernalFurnaceTileEntity.getTotalCookTime(pLevel, pBlockEntity, 0) / 10 * 100;
    }

    public static boolean isSuperchargeFuel(ItemStack pStack) {
        return pStack.is(ItemTagsPM.INFERNAL_SUPERCHARGE_FUEL);
    }

    public void fillStackedContents(StackedContents pHelper) {
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            for (int slotIndex = 0; slotIndex < this.getInventorySize(invIndex); ++slotIndex) {
                pHelper.accountStack(this.getItem(invIndex, slotIndex));
            }
        }
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Sources.getAllSorted()) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Sources.INFERNAL);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.setChanged();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.setChanged();
        this.syncTile(true);
    }

    public void setRecipeUsed(RecipeHolder<?> pRecipeHolder) {
        if (pRecipeHolder != null) {
            this.recipesUsed.addTo((Object)pRecipeHolder.id(), 1);
        }
    }

    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)this.getItem(invIndex, slotIndex), (ItemStack)stack);
        super.setItem(invIndex, slotIndex, stack);
        if (invIndex == 1 && !flag && this.hasLevel()) {
            this.processTimeTotal = InfernalFurnaceTileEntity.getTotalCookTime(this.level, this, 100);
            this.processTime = 0;
            this.setChanged();
        }
    }

    public void awardUsedRecipes(Player player, List<ItemStack> stacks) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer pPlayer) {
        List<RecipeHolder<?>> recipes = this.getRecipesToAwardAndPopExperience(pPlayer.serverLevel(), pPlayer.position());
        pPlayer.awardRecipes(recipes);
        recipes.stream().filter(Predicate.not(Objects::isNull)).forEach(r -> pPlayer.triggerRecipeCrafted(r, (List)this.inventories.get(1)));
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel pLevel, Vec3 pPopVec) {
        ArrayList retVal = new ArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            pLevel.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipeHolder -> {
                retVal.add((RecipeHolder<?>)recipeHolder);
                InfernalFurnaceTileEntity.createExperience(pLevel, pPopVec, entry.getIntValue(), ((AbstractCookingRecipe)recipeHolder.value()).getExperience());
            });
        }
        return retVal;
    }

    private static void createExperience(ServerLevel pLevel, Vec3 pPopVec, int pRecipeIndex, float pExperience) {
        int i = Mth.floor((float)((float)pRecipeIndex * pExperience));
        float f = Mth.frac((float)((float)pRecipeIndex * pExperience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)pLevel, (Vec3)pPopVec, (int)i);
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 1 -> 1;
            case 2 -> 2;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.DOWN -> Optional.of(0);
            default -> Optional.of(1);
        };
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(1, (Object)Services.ITEM_HANDLERS.create((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), (AbstractTilePM)this));
        retVal.set(2, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(2)), this).itemValidFunction((slot, stack) -> switch (slot) {
            case 0 -> stack.is(ItemTagsPM.INFERNAL_SUPERCHARGE_FUEL);
            case 1 -> stack.getItem() instanceof IWand;
            default -> false;
        }).build());
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).itemValidFunction((slot, stack) -> false).build());
        return retVal;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        ((ManaStorage)pComponentInput.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).copyManaInto(this.manaStorage);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)this.manaStorage);
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
        pTag.remove("ManaStorage");
    }
}

