/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.mojang.serialization.DynamicOps;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ITileResearchCache;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.TileResearchCache;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.menus.EssenceTransmuterMenu;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IManaContainingBlockEntity;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class EssenceTransmuterTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IManaContainingBlockEntity,
IOwnedTileEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int INPUT_INV_INDEX = 0;
    public static final int OUTPUT_INV_INDEX = 1;
    public static final int WAND_INV_INDEX = 2;
    protected static final int ESSENCE_PER_TRANSMUTE = 8;
    protected static final int OUTPUT_CAPACITY = 9;
    protected int processTime;
    protected int processTimeTotal;
    protected UUID ownerUUID;
    protected ManaStorage manaStorage;
    protected ITileResearchCache researchCache;
    protected Source nextOutputSource;
    protected Set<AbstractResearchKey<?>> relevantResearch = Collections.emptySet();
    protected final Predicate<AbstractResearchKey<?>> relevantFilter = k -> this.getRelevantResearch().contains(k);
    protected final ContainerData transmuterData = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return EssenceTransmuterTileEntity.this.processTime;
                }
                case 1: {
                    return EssenceTransmuterTileEntity.this.processTimeTotal;
                }
                case 2: {
                    return EssenceTransmuterTileEntity.this.manaStorage.getManaStored(Sources.MOON);
                }
                case 3: {
                    return EssenceTransmuterTileEntity.this.manaStorage.getMaxManaStored(Sources.MOON);
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    EssenceTransmuterTileEntity.this.processTime = value;
                    break;
                }
                case 1: {
                    EssenceTransmuterTileEntity.this.processTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public EssenceTransmuterTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.ESSENCE_TRANSMUTER.get(), pos, state);
        this.manaStorage = new ManaStorage(2000, 200, 200, Sources.MOON);
        this.researchCache = new TileResearchCache();
    }

    public ITileResearchCache getUncachedTileResearchCache() {
        return this.researchCache;
    }

    public IManaStorage<?> getUncachedManaStorage() {
        return this.manaStorage;
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        String ownerUUIDStr;
        super.loadAdditional(compound, registries);
        this.processTime = compound.getInt("ProcessTime");
        this.processTimeTotal = compound.getInt("ProcessTimeTotal");
        ManaStorage.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("ManaStorage")).resultOrPartial(msg -> LOGGER.error("Failed to decode mana storage: {}", msg)).ifPresent(mana -> mana.copyManaInto(this.manaStorage));
        this.researchCache.deserializeNBT(registries, compound.getCompound("ResearchCache"));
        this.nextOutputSource = compound.contains("NextSource", 8) ? Sources.get(ResourceLocation.parse((String)compound.getString("NextSource"))) : null;
        this.ownerUUID = null;
        if (compound.contains("OwnerUUID") && !(ownerUUIDStr = compound.getString("OwnerUUID")).isEmpty()) {
            this.ownerUUID = UUID.fromString(ownerUUIDStr);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("ProcessTime", this.processTime);
        compound.putInt("ProcessTimeTotal", this.processTimeTotal);
        ManaStorage.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.manaStorage).resultOrPartial(msg -> LOGGER.error("Failed to encode mana storage: {}", msg)).ifPresent(encoded -> compound.put("ManaStorage", encoded));
        compound.put("ResearchCache", this.researchCache.serializeNBT(registries));
        if (this.nextOutputSource != null) {
            compound.putString("NextSource", this.nextOutputSource.getId().toString());
        }
        if (this.ownerUUID != null) {
            compound.putString("OwnerUUID", this.ownerUUID.toString());
        }
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
        return new EssenceTransmuterMenu(windowId, playerInv, this.getBlockPos(), this, this.transmuterData);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    protected int getProcessTimeTotal() {
        return 100;
    }

    protected int getManaCost() {
        return 200;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EssenceTransmuterTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.isClientSide) {
            ItemStack essenceStack;
            int centimanaMissing;
            int centimanaToTransfer;
            IWand wand;
            Item item;
            ItemStack wandStack = entity.getItem(2, 0);
            if (!wandStack.isEmpty() && (item = wandStack.getItem()) instanceof IWand && (wand = (IWand)item).consumeMana(wandStack, null, Sources.MOON, centimanaToTransfer = Mth.clamp((int)(centimanaMissing = entity.manaStorage.getMaxManaStored(Sources.MOON) - entity.manaStorage.getManaStored(Sources.MOON)), (int)0, (int)100), (HolderLookup.Provider)level.registryAccess())) {
                entity.manaStorage.receiveMana(Sources.MOON, centimanaToTransfer, false);
                shouldMarkDirty = true;
            }
            if (!(essenceStack = entity.getItem(0, 0)).isEmpty() && entity.manaStorage.getManaStored(Sources.MOON) >= entity.getManaCost()) {
                if (entity.canTransmute(essenceStack)) {
                    ++entity.processTime;
                    if (entity.processTime == entity.processTimeTotal) {
                        entity.processTime = 0;
                        entity.processTimeTotal = entity.getProcessTimeTotal();
                        entity.doTransmute(essenceStack);
                        entity.nextOutputSource = null;
                        shouldMarkDirty = true;
                    }
                } else {
                    entity.processTime = 0;
                }
            } else if (entity.processTime > 0) {
                entity.processTime = Mth.clamp((int)(entity.processTime - 2), (int)0, (int)entity.processTimeTotal);
            }
        }
        if (shouldMarkDirty) {
            entity.setChanged();
            entity.syncTile(true);
        }
    }

    @Nonnull
    protected Source getNextSource(Source inputSource, RandomSource rng) {
        if (this.nextOutputSource == null || this.nextOutputSource.equals(inputSource)) {
            WeightedRandomBag bag = new WeightedRandomBag();
            Sources.stream().filter(s -> !s.equals(inputSource) && this.isSourceKnown((Source)s)).forEach(s -> bag.add(s, 1.0));
            this.nextOutputSource = (Source)bag.getRandom(rng);
        }
        return this.nextOutputSource;
    }

    protected boolean canTransmute(ItemStack inputStack) {
        List<ItemStack> newOutputs = this.getNewOutputs(inputStack);
        return newOutputs != null && newOutputs.size() <= 9;
    }

    protected void doTransmute(ItemStack inputStack) {
        List<ItemStack> newOutputs = this.getNewOutputs(inputStack);
        if (newOutputs != null) {
            for (int index = 0; index < Math.min(newOutputs.size(), 9); ++index) {
                ItemStack out = newOutputs.get(index);
                this.setItem(1, index, out == null ? ItemStack.EMPTY : out);
            }
            inputStack.shrink(8);
            this.manaStorage.extractMana(Sources.MOON, this.getManaCost(), false);
        }
    }

    @Nullable
    protected List<ItemStack> getNewOutputs(ItemStack inputStack) {
        Item item;
        if (inputStack != null && !inputStack.isEmpty() && inputStack.getCount() >= 8 && (item = inputStack.getItem()) instanceof EssenceItem) {
            EssenceItem essence = (EssenceItem)item;
            EssenceType inputType = essence.getEssenceType();
            Source inputSource = essence.getSource();
            Source outputSource = this.getNextSource(inputSource, this.level.random);
            ItemStack outputItem = EssenceItem.getEssence(inputType, outputSource, 1);
            List currentOutputs = (List)this.inventories.get(1);
            List<ItemStack> mergedOutputs = ItemUtils.mergeItemStackIntoList(currentOutputs, outputItem);
            return mergedOutputs;
        }
        return null;
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        if (invIndex == 0 && (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack))) {
            this.processTimeTotal = this.getProcessTimeTotal();
            this.processTime = 0;
            this.nextOutputSource = null;
            this.setChanged();
        }
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Sources.getAllSorted()) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Sources.MOON);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.setChanged();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.setChanged();
        this.syncTile(true);
    }

    @Override
    public void setTileOwner(Player owner) {
        this.ownerUUID = owner == null ? null : owner.getUUID();
        this.updateResearchCache(owner);
    }

    @Override
    public Player getTileOwner() {
        Level level;
        if (this.ownerUUID != null && this.hasLevel() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer livePlayer = serverLevel.getServer().getPlayerList().getPlayer(this.ownerUUID);
            if (livePlayer != null && livePlayer.tickCount % 20 == 0) {
                this.updateResearchCache((Player)livePlayer);
            }
            return livePlayer;
        }
        return null;
    }

    protected void updateResearchCache(Player player) {
        this.researchCache.update(player, this.relevantFilter);
        this.nextOutputSource = null;
    }

    protected boolean isSourceKnown(@Nullable Source source) {
        if (source == null || source.getDiscoverKey().isEmpty()) {
            return true;
        }
        Player owner = this.getTileOwner();
        if (owner != null) {
            return source.isDiscovered(owner);
        }
        return this.researchCache.isResearchComplete(source.getDiscoverKey().get());
    }

    protected Set<AbstractResearchKey<?>> getRelevantResearch() {
        return this.relevantResearch;
    }

    protected static Set<AbstractResearchKey<?>> assembleRelevantResearch() {
        return Sources.streamSorted().map(Source::getDiscoverKey).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 2 -> 1;
            case 1 -> 9;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.DOWN -> Optional.of(1);
            default -> Optional.of(0);
        };
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).itemValidFunction((slot, stack) -> stack.is(ItemTagsPM.ESSENCES)).build());
        retVal.set(2, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(2)), this).itemValidFunction((slot, stack) -> stack.getItem() instanceof IWand).build());
        retVal.set(1, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), this).itemValidFunction((slot, stack) -> false).build());
        return retVal;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        ((ManaStorage)pComponentInput.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).copyManaInto(this.manaStorage);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)this.manaStorage);
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
        pTag.remove("ManaStorage");
    }
}

