/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.verdantartifice.primalmagick.common.blocks.devices.EssenceCaskBlock;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.menus.EssenceCaskMenu;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IHasCustomScanContents;
import com.verdantartifice.primalmagick.common.tiles.base.ITieredDeviceBlockEntity;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class EssenceCaskTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
ITieredDeviceBlockEntity,
IHasCustomScanContents {
    public static final int NUM_ROWS = EssenceType.values().length;
    public static final int NUM_COLS = Sources.getAllSorted().size();
    public static final int NUM_SLOTS = NUM_ROWS * NUM_COLS;
    protected static final int INPUT_INV_INDEX = 0;
    protected static final Map<DeviceTier, Integer> CAPACITY = (Map)Util.make(new HashMap(), map -> {
        map.put(DeviceTier.ENCHANTED, 4096);
        map.put(DeviceTier.FORBIDDEN, 8192);
        map.put(DeviceTier.HEAVENLY, 16384);
    });
    protected final Table<EssenceType, Source, Integer> contents = HashBasedTable.create((int)NUM_ROWS, (int)NUM_COLS);
    protected final ContainerData caskData = new ContainerData(){

        public int get(int index) {
            return EssenceCaskTileEntity.this.getEssenceCountAtSlot(index);
        }

        public void set(int index, int value) {
            EssenceCaskTileEntity.this.setEssenceCountAtSlot(index, value);
        }

        public int getCount() {
            return NUM_SLOTS;
        }
    };
    protected final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, pos, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            level.setBlock(pos, (BlockState)state.setValue((Property)EssenceCaskBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, pos, SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            level.setBlock(pos, (BlockState)state.setValue((Property)EssenceCaskBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int previousCount, int currentCount) {
        }

        protected boolean isOwnContainer(Player player) {
            EssenceCaskMenu caskMenu;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            return abstractContainerMenu instanceof EssenceCaskMenu && (caskMenu = (EssenceCaskMenu)abstractContainerMenu).getTile() == EssenceCaskTileEntity.this;
        }
    };

    public EssenceCaskTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.ESSENCE_CASK.get(), pos, state);
        for (EssenceType row : EssenceType.values()) {
            for (Source col : Sources.getAllSorted()) {
                this.contents.put((Object)row, (Object)col, (Object)0);
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EssenceCaskTileEntity entity) {
        ItemStack stack;
        Item item;
        if (!level.isClientSide && !((NonNullList)entity.inventories.get(0)).isEmpty() && (item = (stack = entity.getItem(0, 0)).getItem()) instanceof EssenceItem) {
            int capacity;
            EssenceItem essenceItem = (EssenceItem)item;
            EssenceType essenceType = essenceItem.getEssenceType();
            Source essenceSource = essenceItem.getSource();
            int inputCount = stack.getCount();
            int currentCount = entity.contents.contains((Object)essenceType, (Object)essenceSource) ? (Integer)entity.contents.get((Object)essenceType, (Object)essenceSource) : 0;
            int totalCount = entity.getTotalEssenceCount();
            if (totalCount + inputCount <= (capacity = entity.getTotalEssenceCapacity())) {
                entity.contents.put((Object)essenceType, (Object)essenceSource, (Object)(currentCount + inputCount));
                entity.setItem(0, 0, ItemStack.EMPTY);
            } else {
                int addable = capacity - totalCount;
                entity.contents.put((Object)essenceType, (Object)essenceSource, (Object)(currentCount + addable));
                stack.shrink(addable);
            }
        }
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
        return new EssenceCaskMenu(windowId, playerInv, this.getBlockPos(), this, this.caskData);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public int getTotalEssenceCapacity() {
        return CAPACITY.getOrDefault((Object)this.getDeviceTier(), 0);
    }

    public int getTotalEssenceCount() {
        return this.contents.values().stream().mapToInt(i -> i).sum();
    }

    public int getEssenceCountForType(EssenceType type) {
        return this.contents.row((Object)type).entrySet().stream().mapToInt(Map.Entry::getValue).sum();
    }

    public int getEssenceCountForSource(Source source) {
        return this.contents.column((Object)source).entrySet().stream().mapToInt(Map.Entry::getValue).sum();
    }

    protected EssenceType getEssenceTypeForIndex(int index) {
        return index < 0 || index >= NUM_SLOTS ? null : EssenceType.values()[index / NUM_COLS];
    }

    protected Source getEssenceSourceForIndex(int index) {
        return index < 0 || index >= NUM_SLOTS ? null : Sources.getAllSorted().get(index % NUM_COLS);
    }

    public int getEssenceCount(EssenceType essenceType, Source source) {
        return this.contents.contains((Object)essenceType, (Object)source) ? (Integer)this.contents.get((Object)essenceType, (Object)source) : 0;
    }

    public int setEssenceCount(EssenceType type, Source source, int amount) {
        if (amount < 0) {
            return 0;
        }
        int capacity = this.getTotalEssenceCapacity();
        if (amount < capacity) {
            this.contents.put((Object)type, (Object)source, (Object)amount);
            return 0;
        }
        this.contents.put((Object)type, (Object)source, (Object)capacity);
        return amount - capacity;
    }

    public int getEssenceCountAtSlot(int index) {
        Source col;
        if (index < 0 || index >= NUM_SLOTS) {
            return 0;
        }
        EssenceType row = this.getEssenceTypeForIndex(index);
        return this.contents.contains((Object)row, (Object)(col = this.getEssenceSourceForIndex(index))) ? (Integer)this.contents.get((Object)row, (Object)col) : 0;
    }

    public void setEssenceCountAtSlot(int index, int count) {
        if (index < 0 || index >= NUM_SLOTS) {
            return;
        }
        EssenceType row = this.getEssenceTypeForIndex(index);
        Source col = this.getEssenceSourceForIndex(index);
        this.contents.put((Object)row, (Object)col, (Object)count);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.loadContentsNbt(compound);
    }

    protected void loadContentsNbt(CompoundTag compound) {
        this.contents.clear();
        CompoundTag contentsTag = compound.getCompound("CaskContents");
        for (EssenceType type : EssenceType.values()) {
            CompoundTag typeContents = contentsTag.getCompound(type.getSerializedName());
            for (Source source : Sources.getAllSorted()) {
                int count = typeContents.getInt(source.getId().toString());
                this.contents.put((Object)type, (Object)source, (Object)count);
            }
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("CaskContents", (Tag)this.getContentsNbt());
    }

    protected CompoundTag getContentsNbt() {
        CompoundTag contentsTag = new CompoundTag();
        for (EssenceType type : EssenceType.values()) {
            CompoundTag typeContents = new CompoundTag();
            for (Source source : Sources.getAllSorted()) {
                int count = this.contents.contains((Object)type, (Object)source) ? (Integer)this.contents.get((Object)type, (Object)source) : 0;
                typeContents.put(source.getId().toString(), (Tag)IntTag.valueOf((int)count));
            }
            contentsTag.put(type.getSerializedName(), (Tag)typeContents);
        }
        return contentsTag;
    }

    public void dropContents() {
        this.dropContents(this.level, this.worldPosition);
        for (Table.Cell cell : this.contents.cellSet()) {
            ItemStack tempStack = EssenceItem.getEssence((EssenceType)((Object)cell.getRowKey()), (Source)cell.getColumnKey(), (Integer)cell.getValue());
            this.contents.put((Object)((EssenceType)((Object)cell.getRowKey())), (Object)((Source)cell.getColumnKey()), (Object)0);
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)tempStack);
        }
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    protected int getInventoryCount() {
        return 1;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0 -> 1;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.UP -> Optional.of(0);
            default -> Optional.empty();
        };
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).itemValidFunction((slot, stack) -> stack.getItem() instanceof EssenceItem).build());
        return retVal;
    }

    @Override
    public NonNullList<ItemStack> getCustomScanContents() {
        List<Table.Cell> filteredContents = this.contents.cellSet().stream().filter(cell -> (Integer)cell.getValue() > 0).toList();
        NonNullList retVal = NonNullList.withSize((int)filteredContents.size(), (Object)ItemStack.EMPTY);
        int index = 0;
        for (Table.Cell cell2 : filteredContents) {
            retVal.set(index++, (Object)EssenceItem.getEssence((EssenceType)((Object)cell2.getRowKey()), (Source)cell2.getColumnKey()));
        }
        return retVal;
    }
}

