/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.mojang.serialization.DynamicOps;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.menus.DissolutionChamberMenu;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IManaContainingBlockEntity;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class DissolutionChamberTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IManaContainingBlockEntity,
StackedContentsCompatible {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int OUTPUT_INV_INDEX = 0;
    public static final int INPUT_INV_INDEX = 1;
    public static final int WAND_INV_INDEX = 2;
    protected int processTime;
    protected int processTimeTotal;
    protected ManaStorage manaStorage;
    protected final ContainerData chamberData = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return DissolutionChamberTileEntity.this.processTime;
                }
                case 1: {
                    return DissolutionChamberTileEntity.this.processTimeTotal;
                }
                case 2: {
                    return DissolutionChamberTileEntity.this.manaStorage.getManaStored(Sources.EARTH);
                }
                case 3: {
                    return DissolutionChamberTileEntity.this.manaStorage.getMaxManaStored(Sources.EARTH);
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    DissolutionChamberTileEntity.this.processTime = value;
                    break;
                }
                case 1: {
                    DissolutionChamberTileEntity.this.processTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public DissolutionChamberTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.DISSOLUTION_CHAMBER.get(), pos, state);
        this.manaStorage = new ManaStorage(10000, 1000, 1000, Sources.EARTH);
    }

    public IManaStorage<?> getUncachedManaStorage() {
        return this.manaStorage;
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.processTime = compound.getInt("ProcessTime");
        this.processTimeTotal = compound.getInt("ProcessTimeTotal");
        ManaStorage.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("ManaStorage")).resultOrPartial(msg -> LOGGER.error("Failed to decode mana storage: {}", msg)).ifPresent(mana -> mana.copyManaInto(this.manaStorage));
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("ProcessTime", this.processTime);
        compound.putInt("ProcessTimeTotal", this.processTimeTotal);
        ManaStorage.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.manaStorage).resultOrPartial(msg -> LOGGER.error("Failed to encode mana storage: {}", msg)).ifPresent(encoded -> compound.put("ManaStorage", encoded));
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
        return new DissolutionChamberMenu(windowId, playerInv, this.getBlockPos(), this, this.chamberData);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    protected int getProcessTimeTotal() {
        return 100;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DissolutionChamberTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.isClientSide) {
            int centimanaMissing;
            int centimanaToTransfer;
            IWand wand;
            Item item;
            ItemStack wandStack = entity.getItem(2, 0);
            if (!wandStack.isEmpty() && (item = wandStack.getItem()) instanceof IWand && (wand = (IWand)item).consumeMana(wandStack, null, Sources.EARTH, centimanaToTransfer = Mth.clamp((int)(centimanaMissing = entity.manaStorage.getMaxManaStored(Sources.EARTH) - entity.manaStorage.getManaStored(Sources.EARTH)), (int)0, (int)100), (HolderLookup.Provider)level.registryAccess())) {
                entity.manaStorage.receiveMana(Sources.EARTH, centimanaToTransfer, false);
                shouldMarkDirty = true;
            }
            SingleRecipeInput testInv = new SingleRecipeInput(entity.getItem(1, 0));
            RecipeHolder recipe = level.getServer().getRecipeManager().getRecipeFor(RecipeTypesPM.DISSOLUTION.get(), (RecipeInput)testInv, level).orElse(null);
            if (entity.canDissolve(testInv, level.registryAccess(), (RecipeHolder<IDissolutionRecipe>)recipe)) {
                ++entity.processTime;
                if (entity.processTime >= entity.processTimeTotal) {
                    entity.processTime = 0;
                    entity.processTimeTotal = entity.getProcessTimeTotal();
                    entity.doDissolve(testInv, level.registryAccess(), (RecipeHolder<IDissolutionRecipe>)recipe);
                    shouldMarkDirty = true;
                }
            } else {
                entity.processTime = Mth.clamp((int)(entity.processTime - 2), (int)0, (int)entity.processTimeTotal);
            }
        }
        if (shouldMarkDirty) {
            entity.setChanged();
            entity.syncTile(true);
        }
    }

    protected boolean canDissolve(SingleRecipeInput inputInv, RegistryAccess registryAccess, RecipeHolder<IDissolutionRecipe> recipe) {
        if (!inputInv.isEmpty() && recipe != null) {
            ItemStack output = ((IDissolutionRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registryAccess);
            if (output.isEmpty()) {
                return false;
            }
            if (this.getMana(Sources.EARTH) < ((IDissolutionRecipe)recipe.value()).getManaCosts().getAmount(Sources.EARTH)) {
                return false;
            }
            ItemStack currentOutput = this.getItem(0, 0);
            if (currentOutput.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)currentOutput, (ItemStack)output)) {
                return false;
            }
            if (currentOutput.getCount() + output.getCount() <= ((IItemHandlerPM)this.itemHandlers.get(0)).getSlotLimit(0) && currentOutput.getCount() + output.getCount() <= currentOutput.getMaxStackSize()) {
                return true;
            }
            return currentOutput.getCount() + output.getCount() <= output.getMaxStackSize();
        }
        return false;
    }

    protected void doDissolve(SingleRecipeInput inputInv, RegistryAccess registryAccess, RecipeHolder<IDissolutionRecipe> recipe) {
        if (recipe != null && this.canDissolve(inputInv, registryAccess, recipe)) {
            ItemStack recipeOutput = ((IDissolutionRecipe)recipe.value()).assemble((RecipeInput)inputInv, (HolderLookup.Provider)registryAccess);
            ItemStack currentOutput = this.getItem(0, 0);
            if (currentOutput.isEmpty()) {
                this.setItem(0, 0, recipeOutput);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)recipeOutput, (ItemStack)currentOutput)) {
                currentOutput.grow(recipeOutput.getCount());
            }
            for (int index = 0; index < inputInv.size(); ++index) {
                ItemStack stack = inputInv.getItem(index);
                if (stack.isEmpty()) continue;
                stack.shrink(1);
            }
            this.setMana(Sources.EARTH, this.getMana(Sources.EARTH) - ((IDissolutionRecipe)recipe.value()).getManaCosts().getAmount(Sources.EARTH));
        }
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        if (invIndex == 1 && (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack))) {
            this.processTimeTotal = this.getProcessTimeTotal();
            this.processTime = 0;
            this.setChanged();
        }
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Sources.getAllSorted()) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Sources.EARTH);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.setChanged();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.setChanged();
        this.syncTile(true);
    }

    public void fillStackedContents(StackedContents stackedContents) {
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            for (int slotIndex = 0; slotIndex < this.getInventorySize(invIndex); ++slotIndex) {
                stackedContents.accountStack(this.getItem(invIndex, slotIndex));
            }
        }
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 1, 2 -> 1;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.DOWN -> Optional.of(0);
            default -> Optional.of(1);
        };
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(1, (Object)Services.ITEM_HANDLERS.create((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), (AbstractTilePM)this));
        retVal.set(2, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(2)), this).itemValidFunction((slot, stack) -> stack.getItem() instanceof IWand).build());
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).itemValidFunction((slot, stack) -> false).build());
        return retVal;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        ((ManaStorage)pComponentInput.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).copyManaInto(this.manaStorage);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)this.manaStorage);
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
        pTag.remove("ManaStorage");
    }
}

