/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.verdantartifice.primalmagick.common.capabilities.IFluidHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.fluids.IFluidStackPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.menus.DesalinatorMenu;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IManaContainingBlockEntity;
import com.verdantartifice.primalmagick.common.util.FluidUtils;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class DesalinatorTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IManaContainingBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int INPUT_INV_INDEX = 0;
    public static final int OUTPUT_INV_INDEX = 1;
    public static final int WAND_INV_INDEX = 2;
    protected static final int REQUIRED_WATER_AMOUNT = 1000;
    protected static final int PASSIVE_WATER_INPUT = 50;
    protected int ticks = 0;
    protected int boilTime;
    protected int boilTimeTotal;
    protected ManaStorage manaStorage;
    protected IFluidHandlerPM waterTank;
    protected final ContainerData containerData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> DesalinatorTileEntity.this.boilTime;
                case 1 -> DesalinatorTileEntity.this.boilTimeTotal;
                case 2 -> DesalinatorTileEntity.this.manaStorage.getManaStored(Sources.SUN);
                case 3 -> DesalinatorTileEntity.this.manaStorage.getMaxManaStored(Sources.SUN);
                case 4 -> DesalinatorTileEntity.this.waterTank.getFluidInTank(0).getAmount();
                case 5 -> DesalinatorTileEntity.this.waterTank.getTankCapacity(0);
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    DesalinatorTileEntity.this.boilTime = value;
                    break;
                }
                case 1: {
                    DesalinatorTileEntity.this.boilTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 6;
        }
    };

    public DesalinatorTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.DESALINATOR.get(), pos, state);
        this.manaStorage = new ManaStorage(2000, 200, 200, Sources.SUN);
        this.waterTank = Services.FLUID_HANDLERS.create(4000, fs -> fs.is((Fluid)Fluids.WATER));
    }

    public IManaStorage<?> getUncachedManaStorage() {
        return this.manaStorage;
    }

    public IFluidHandlerPM getUncachedFluidHandler() {
        return this.waterTank;
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.boilTime = compound.getInt("BoilTime");
        this.boilTimeTotal = compound.getInt("BoilTimeTotal");
        ManaStorage.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("ManaStorage")).resultOrPartial(msg -> LOGGER.error("Failed to decode mana storage: {}", msg)).ifPresent(mana -> mana.copyManaInto(this.manaStorage));
        this.waterTank.readFromNBT(registries, compound.getCompound("WaterTank"));
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("BoilTime", this.boilTime);
        compound.putInt("BoilTimeTotal", this.boilTimeTotal);
        ManaStorage.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.manaStorage).resultOrPartial(msg -> LOGGER.error("Failed to encode mana storage: {}", msg)).ifPresent(encoded -> compound.put("ManaStorage", encoded));
        compound.put("WaterTank", (Tag)this.waterTank.writeToNBT(registries, new CompoundTag()));
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
        return new DesalinatorMenu(windowId, playerInv, this.getBlockPos(), this, this.containerData);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    protected int getBoilTimeTotal() {
        return 200;
    }

    protected int getManaCost() {
        return 200;
    }

    public int getTicks() {
        return this.ticks;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DesalinatorTileEntity entity) {
        boolean shouldMarkDirty = false;
        ++entity.ticks;
        if (!level.isClientSide) {
            ItemStack inputStack;
            int centimanaMissing;
            int centimanaToTransfer;
            IWand wand;
            Item item;
            ItemStack wandStack = entity.getItem(2, 0);
            if (!wandStack.isEmpty() && (item = wandStack.getItem()) instanceof IWand && (wand = (IWand)item).consumeMana(wandStack, null, Sources.SUN, centimanaToTransfer = Mth.clamp((int)(centimanaMissing = entity.manaStorage.getMaxManaStored(Sources.SUN) - entity.manaStorage.getManaStored(Sources.SUN)), (int)0, (int)100), (HolderLookup.Provider)level.registryAccess())) {
                entity.manaStorage.receiveMana(Sources.SUN, centimanaToTransfer, false);
                shouldMarkDirty = true;
            }
            if (!(inputStack = entity.getItem(0, 0)).isEmpty()) {
                IFluidStackPM fluidStack = DesalinatorTileEntity.getFluidStackForInput(inputStack);
                ItemStack containerStack = DesalinatorTileEntity.getContainerForInput(inputStack);
                if (!fluidStack.isEmpty() && entity.waterTank.fill(fluidStack, true) == fluidStack.getAmount() && entity.canFill(containerStack)) {
                    entity.doFill(fluidStack, containerStack);
                }
            }
            if (FluidUtils.isInfiniteSource(level, pos, Fluids.WATER)) {
                entity.waterTank.fill(Services.FLUIDS.makeFluidStack((Fluid)Fluids.WATER, 50), false);
            }
            if (entity.waterTank.drain(1000, true).getAmount() >= 1000 && entity.manaStorage.getManaStored(Sources.SUN) >= entity.getManaCost()) {
                if (entity.canBoil()) {
                    ++entity.boilTime;
                    if (entity.boilTime >= entity.boilTimeTotal) {
                        entity.boilTime = 0;
                        entity.boilTimeTotal = entity.getBoilTimeTotal();
                        entity.doBoil();
                        shouldMarkDirty = true;
                    }
                } else {
                    entity.boilTime = 0;
                }
            } else if (entity.boilTime > 0) {
                entity.boilTime = Mth.clamp((int)(entity.boilTime - 2), (int)0, (int)entity.boilTimeTotal);
            }
        }
        if (shouldMarkDirty) {
            entity.setChanged();
            entity.syncTile(true);
        }
    }

    protected static IFluidStackPM getFluidStackForInput(ItemStack stack) {
        if (stack.is(Items.WATER_BUCKET)) {
            return Services.FLUIDS.makeFluidStack((Fluid)Fluids.WATER, 1000);
        }
        if (stack.is(Items.POTION) || stack.is((Item)ItemsPM.CONCOCTION.get())) {
            return Services.FLUIDS.makeFluidStack((Fluid)Fluids.WATER, 250);
        }
        return Services.FLUIDS.emptyStack();
    }

    protected static ItemStack getContainerForInput(ItemStack stack) {
        if (stack.is(Items.WATER_BUCKET) && stack.getItem().getCraftingRemainingItem() != null) {
            return new ItemStack((ItemLike)stack.getItem().getCraftingRemainingItem());
        }
        if (stack.is(Items.POTION)) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (stack.is((Item)ItemsPM.CONCOCTION.get())) {
            return new ItemStack((ItemLike)ItemsPM.SKYGLASS_FLASK.get());
        }
        return ItemStack.EMPTY;
    }

    protected boolean canFill(ItemStack containerStack) {
        ItemStack containerOutput = this.getItem(1, 2);
        return containerOutput.isEmpty() || containerOutput.is(containerStack.getItem()) && containerOutput.getCount() < ((IItemHandlerPM)this.itemHandlers.get(1)).getSlotLimit(2) && containerOutput.getCount() < containerOutput.getMaxStackSize();
    }

    protected void doFill(IFluidStackPM fluidStack, ItemStack containerStack) {
        this.waterTank.fill(fluidStack, false);
        ItemStack outputStack = this.getItem(1, 2);
        if (outputStack.isEmpty()) {
            this.setItem(1, 2, containerStack);
        } else {
            outputStack.grow(1);
        }
        ItemStack inputStack = this.getItem(0, 0);
        inputStack.shrink(1);
        if (inputStack.isEmpty()) {
            this.setItem(0, 0, ItemStack.EMPTY);
        }
    }

    protected boolean canBoil() {
        ItemStack saltOutput = this.getItem(1, 0);
        ItemStack essenceOutput = this.getItem(1, 1);
        return saltOutput.getCount() < ((IItemHandlerPM)this.itemHandlers.get(1)).getSlotLimit(0) && saltOutput.getCount() < saltOutput.getMaxStackSize() && essenceOutput.getCount() < ((IItemHandlerPM)this.itemHandlers.get(1)).getSlotLimit(1) && essenceOutput.getCount() < essenceOutput.getMaxStackSize();
    }

    protected void doBoil() {
        ItemStack saltOutput = this.getItem(1, 0);
        if (saltOutput.isEmpty()) {
            this.setItem(1, 0, new ItemStack((ItemLike)ItemsPM.SALT_PINCH.get()));
        } else {
            saltOutput.grow(1);
        }
        ItemStack essenceOutput = this.getItem(1, 1);
        if (essenceOutput.isEmpty()) {
            this.setItem(1, 1, new ItemStack((ItemLike)ItemsPM.ESSENCE_DUST_SEA.get()));
        } else {
            essenceOutput.grow(1);
        }
        this.waterTank.drain(1000, false);
        this.manaStorage.extractMana(Sources.SUN, this.getManaCost(), false);
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        if (invIndex == 0 && (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack))) {
            this.boilTimeTotal = this.getBoilTimeTotal();
            this.boilTime = 0;
            this.setChanged();
        }
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Sources.getAllSorted()) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Sources.SUN);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.setChanged();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.setChanged();
        this.syncTile(true);
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 2 -> 1;
            case 1 -> 3;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.DOWN -> Optional.of(1);
            default -> Optional.of(0);
        };
    }

    public static boolean isFullWaterContainer(ItemStack stack) {
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return stack.is(Items.WATER_BUCKET) || stack.is(Items.POTION) && contents.is(Potions.WATER) || stack.is((Item)ItemsPM.CONCOCTION.get()) && contents.is(Potions.WATER);
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), this).itemValidFunction((slot, stack) -> DesalinatorTileEntity.isFullWaterContainer(stack)).build());
        retVal.set(2, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(2)), this).itemValidFunction((slot, stack) -> stack.getItem() instanceof IWand).build());
        retVal.set(1, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), this).itemValidFunction((slot, stack) -> false).build());
        return retVal;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        ((ManaStorage)pComponentInput.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).copyManaInto(this.manaStorage);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)this.manaStorage);
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
        pTag.remove("ManaStorage");
    }
}

