/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.crafting;

import com.verdantartifice.primalmagick.common.blocks.crafting.SpellcraftingAltarBlock;
import com.verdantartifice.primalmagick.common.menus.SpellcraftingAltarMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellcraftingRunePacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SpellcraftingAltarTileEntity
extends AbstractTilePM
implements MenuProvider {
    public static final int BOB_CYCLE_TIME_TICKS = 200;
    protected static final int TICKS_PER_SEGMENT_ROTATION = 10;
    protected static final int TICKS_PER_PAUSE = 20;
    protected static final List<Source> ALLOWED_SOURCES = Arrays.asList(Sources.EARTH, Sources.SEA, Sources.SKY, Sources.SUN, Sources.MOON);
    protected int phaseTicks = 0;
    protected int nextUpdate = 0;
    protected Segment lastSegment = Segment.U1;
    protected Segment nextSegment = Segment.U1;
    protected RotationPhase currentRotation = RotationPhase.COUNTER_CLOCKWISE_PAUSE;
    protected Source lastSource = Sources.EARTH;
    protected Source nextSource = Sources.EARTH;

    public SpellcraftingAltarTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.SPELLCRAFTING_ALTAR.get(), pos, state);
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
        return new SpellcraftingAltarMenu(windowId, playerInv, this.getBlockPos(), this);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.phaseTicks = compound.getInt("PhaseTicks");
        this.nextUpdate = compound.getInt("NextUpdate");
        this.lastSegment = Segment.values()[compound.getInt("LastSegmentIndex")];
        this.nextSegment = Segment.values()[compound.getInt("NextSegmentIndex")];
        this.currentRotation = RotationPhase.values()[compound.getInt("CurrentRotationIndex")];
        Source last = Sources.get(ResourceLocation.parse((String)compound.getString("LastSource")));
        this.lastSource = last == null ? Sources.EARTH : last;
        Source next = Sources.get(ResourceLocation.parse((String)compound.getString("NextSource")));
        this.nextSource = next == null ? Sources.EARTH : next;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("PhaseTicks", this.phaseTicks);
        compound.putInt("NextUpdate", this.nextUpdate);
        compound.putInt("LastSegmentIndex", this.lastSegment.ordinal());
        compound.putInt("NextSegmentIndex", this.nextSegment.ordinal());
        compound.putInt("CurrentRotationIndex", this.currentRotation.ordinal());
        compound.putString("LastSource", this.lastSource.getId().toString());
        compound.putString("NextSource", this.nextSource.getId().toString());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SpellcraftingAltarTileEntity entity) {
        if (entity.phaseTicks++ >= entity.nextUpdate && !level.isClientSide) {
            entity.nextRotationPhase();
        }
    }

    protected void nextRotationPhase() {
        this.currentRotation = this.currentRotation.getNext();
        if (!this.currentRotation.isPause()) {
            this.lastSegment = this.nextSegment;
            Segment[] nextPossibleSegments = (Segment[])Arrays.stream(Segment.values()).filter(s -> !s.equals((Object)this.lastSegment)).toArray(Segment[]::new);
            this.nextSegment = nextPossibleSegments[this.level.random.nextInt(nextPossibleSegments.length)];
            this.lastSource = this.nextSource;
            Source[] nextPossibleSources = (Source[])ALLOWED_SOURCES.stream().filter(s -> !s.equals(this.lastSource)).toArray(Source[]::new);
            this.nextSource = nextPossibleSources[this.level.random.nextInt(nextPossibleSources.length)];
        }
        this.nextUpdate = this.currentRotation.getDuration(this.lastSegment, this.nextSegment);
        this.phaseTicks = 0;
        this.setChanged();
        this.syncTile(true);
        if (!this.level.isClientSide && this.currentRotation.isPause()) {
            this.emitRuneParticle();
        }
    }

    public float getCurrentRotation(float partialTicks) {
        if (this.nextUpdate == 0) {
            return 0.0f;
        }
        if (this.currentRotation.isPause()) {
            return this.nextSegment.getDegreeOffset();
        }
        return Mth.lerp((float)(((float)this.phaseTicks + partialTicks) / (float)this.nextUpdate), (float)this.lastSegment.getDegreeOffset(), (float)this.nextSegment.getDegreeTarget(this.lastSegment, this.currentRotation));
    }

    public Color getCurrentColor(float partialTicks) {
        if (this.nextUpdate == 0) {
            return new Color(Sources.EARTH.getColor());
        }
        if (this.currentRotation.isPause()) {
            return new Color(this.nextSource.getColor());
        }
        Color last = new Color(this.lastSource.getColor());
        Color next = new Color(this.nextSource.getColor());
        float blend = ((float)this.phaseTicks + partialTicks) / (float)this.nextUpdate;
        float inverse = 1.0f - blend;
        float r = (float)next.getRed() * blend + (float)last.getRed() * inverse;
        float g = (float)next.getGreen() * blend + (float)last.getGreen() * inverse;
        float b = (float)next.getBlue() * blend + (float)last.getBlue() * inverse;
        return new Color(Mth.clamp((float)(r / 255.0f), (float)0.0f, (float)1.0f), Mth.clamp((float)(g / 255.0f), (float)0.0f, (float)1.0f), Mth.clamp((float)(b / 255.0f), (float)0.0f, (float)1.0f));
    }

    protected void emitRuneParticle() {
        Vec3 center = Vec3.upFromBottomCenterOf((Vec3i)this.worldPosition, (double)1.1875);
        Vec3 facingNormal = Vec3.atLowerCornerOf((Vec3i)((Direction)this.getBlockState().getValue((Property)SpellcraftingAltarBlock.FACING)).getNormal());
        Vec3 centerOffset = facingNormal.scale(0.5);
        Vec3 movement = facingNormal.scale(0.05);
        long time = this.getLevel().getLevelData().getGameTime();
        double bobDelta = 0.125 * Math.sin((double)time * 0.031415926535897934);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketHandler.sendToAllAround(new SpellcraftingRunePacket(this.nextSegment, center.x + centerOffset.x, center.y + bobDelta, center.z + centerOffset.z, movement.x, 0.0, movement.z, this.nextSource.getColor()), serverLevel, this.worldPosition, 64.0);
        }
    }

    public static enum Segment {
        U1(0),
        V1(45),
        T1(90),
        D1(135),
        U2(180),
        V2(225),
        T2(270),
        D2(315);

        private final int degreeOffset;

        private Segment(int degrees) {
            this.degreeOffset = degrees;
        }

        public int getDegreeOffset() {
            return this.degreeOffset;
        }

        public int getDegreeTarget(Segment last, RotationPhase rotation) {
            if (rotation.isReverse() && this.degreeOffset >= last.degreeOffset) {
                return this.degreeOffset - 360;
            }
            if (!rotation.isReverse() && this.degreeOffset <= last.degreeOffset) {
                return this.degreeOffset + 360;
            }
            return this.degreeOffset;
        }
    }

    protected static enum RotationPhase {
        CLOCKWISE(false, false),
        CLOCKWISE_PAUSE(false, true),
        COUNTER_CLOCKWISE(true, false),
        COUNTER_CLOCKWISE_PAUSE(true, true);

        private final boolean reverse;
        private final boolean pause;

        private RotationPhase(boolean reverse, boolean pause) {
            this.reverse = reverse;
            this.pause = pause;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public boolean isPause() {
            return this.pause;
        }

        public int getDuration(Segment last, Segment next) {
            switch (this.ordinal()) {
                case 0: 
                case 2: {
                    int segmentDelta = Math.abs(next.getDegreeTarget(last, this) - last.getDegreeOffset()) / 45;
                    return 10 * segmentDelta;
                }
                case 1: 
                case 3: {
                    return 20;
                }
            }
            throw new IndexOutOfBoundsException("No such rotation phase!");
        }

        public RotationPhase getNext() {
            switch (this.ordinal()) {
                case 0: {
                    return CLOCKWISE_PAUSE;
                }
                case 1: {
                    return COUNTER_CLOCKWISE;
                }
                case 2: {
                    return COUNTER_CLOCKWISE_PAUSE;
                }
                case 3: {
                    return CLOCKWISE;
                }
            }
            throw new IndexOutOfBoundsException("No such rotation phase!");
        }
    }
}

