/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.crafting;

import com.mojang.serialization.DynamicOps;
import com.verdantartifice.primalmagick.common.blocks.crafting.ConcocterBlock;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ITileResearchCache;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.TileResearchCache;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.concoctions.ConcoctionUtils;
import com.verdantartifice.primalmagick.common.concoctions.FuseType;
import com.verdantartifice.primalmagick.common.crafting.IConcoctingRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.menus.ConcocterMenu;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IManaContainingBlockEntity;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class ConcocterTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IOwnedTileEntity,
IManaContainingBlockEntity,
StackedContentsCompatible {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int WAND_INV_INDEX = 1;
    protected static final int OUTPUT_INV_INDEX = 2;
    protected static final int MAX_INPUT_ITEMS = 9;
    protected int cookTime;
    protected int cookTimeTotal;
    protected ManaStorage manaStorage;
    protected ITileResearchCache researchCache;
    protected UUID ownerUUID;
    protected Set<AbstractResearchKey<?>> relevantResearch = Collections.emptySet();
    protected final Predicate<AbstractResearchKey<?>> relevantFilter = k -> this.getRelevantResearch().contains(k);
    protected final ContainerData concocterData = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return ConcocterTileEntity.this.cookTime;
                }
                case 1: {
                    return ConcocterTileEntity.this.cookTimeTotal;
                }
                case 2: {
                    return ConcocterTileEntity.this.manaStorage.getManaStored(Sources.INFERNAL);
                }
                case 3: {
                    return ConcocterTileEntity.this.manaStorage.getMaxManaStored(Sources.INFERNAL);
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ConcocterTileEntity.this.cookTime = value;
                    break;
                }
                case 1: {
                    ConcocterTileEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public ConcocterTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypesPM.CONCOCTER.get(), pos, state);
        this.manaStorage = new ManaStorage(20000, 5000, 5000, Sources.INFERNAL);
        this.researchCache = new TileResearchCache();
    }

    public ITileResearchCache getUncachedTileResearchCache() {
        return this.researchCache;
    }

    public IManaStorage<?> getUncachedManaStorage() {
        return this.manaStorage;
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.cookTime = compound.getInt("CookTime");
        this.cookTimeTotal = compound.getInt("CookTimeTotal");
        ManaStorage.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("ManaStorage")).resultOrPartial(msg -> LOGGER.error("Failed to decode mana storage: {}", msg)).ifPresent(mana -> mana.copyManaInto(this.manaStorage));
        this.researchCache.deserializeNBT(registries, compound.getCompound("ResearchCache"));
        this.ownerUUID = null;
        if (compound.contains("OwnerUUID")) {
            this.ownerUUID = compound.getUUID("OwnerUUID");
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("CookTime", this.cookTime);
        compound.putInt("CookTimeTotal", this.cookTimeTotal);
        ManaStorage.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.manaStorage).resultOrPartial(msg -> LOGGER.error("Failed to encode mana storage: {}", msg)).ifPresent(encoded -> compound.put("ManaStorage", encoded));
        compound.put("ResearchCache", this.researchCache.serializeNBT(registries));
        if (this.ownerUUID != null) {
            compound.putUUID("OwnerUUID", this.ownerUUID);
        }
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
        return new ConcocterMenu(windowId, playerInv, this.getBlockPos(), this, this.concocterData);
    }

    @Override
    public void setTileOwner(Player owner) {
        this.ownerUUID = owner == null ? null : owner.getUUID();
        this.researchCache.update(owner, this.relevantFilter);
    }

    @Override
    public Player getTileOwner() {
        Level level;
        if (this.ownerUUID != null && this.hasLevel() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer livePlayer = serverLevel.getServer().getPlayerList().getPlayer(this.ownerUUID);
            if (livePlayer != null && livePlayer.tickCount % 20 == 0) {
                this.researchCache.update((Player)livePlayer, this.relevantFilter);
            }
            return livePlayer;
        }
        return null;
    }

    protected boolean isResearchKnown(Optional<AbstractRequirement<?>> requirementOpt) {
        if (requirementOpt.isEmpty()) {
            return true;
        }
        Player owner = this.getTileOwner();
        if (owner != null) {
            return requirementOpt.get().isMetBy(owner);
        }
        return this.researchCache.isResearchComplete(requirementOpt.get().streamKeys().toList());
    }

    protected Set<AbstractResearchKey<?>> getRelevantResearch() {
        return this.relevantResearch;
    }

    protected static Set<AbstractResearchKey<?>> assembleRelevantResearch(RecipeManager recipeManager) {
        return recipeManager.getAllRecipesFor(RecipeTypesPM.CONCOCTING.get()).stream().flatMap(holder -> ((IConcoctingRecipe)holder.value()).getRequirement().map(req -> req.streamKeys()).orElse(Stream.empty())).distinct().collect(Collectors.toUnmodifiableSet());
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ConcocterTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.isClientSide) {
            int centimanaMissing;
            int centimanaToTransfer;
            IWand wand;
            Item item;
            ItemStack wandStack = entity.getItem(1, 0);
            if (!wandStack.isEmpty() && (item = wandStack.getItem()) instanceof IWand && (wand = (IWand)item).consumeMana(wandStack, null, Sources.INFERNAL, centimanaToTransfer = Mth.clamp((int)(centimanaMissing = entity.manaStorage.getMaxManaStored(Sources.INFERNAL) - entity.manaStorage.getManaStored(Sources.INFERNAL)), (int)0, (int)100), (HolderLookup.Provider)level.registryAccess())) {
                entity.manaStorage.receiveMana(Sources.INFERNAL, centimanaToTransfer, false);
                shouldMarkDirty = true;
            }
            SimpleContainer realInv = new SimpleContainer(9);
            SimpleContainer testInv = new SimpleContainer(9);
            for (int index = 0; index < 9; ++index) {
                ItemStack invStack = entity.getItem(0, index);
                realInv.setItem(index, invStack);
                testInv.setItem(index, ConcoctionUtils.isBomb(invStack) ? ConcoctionUtils.setFuseType(invStack.copy(), FuseType.MEDIUM) : invStack);
            }
            CraftingInput realInput = CraftingInput.of((int)3, (int)3, (List)realInv.getItems());
            CraftingInput testInput = CraftingInput.of((int)3, (int)3, (List)testInv.getItems());
            IConcoctingRecipe recipe = level.getServer().getRecipeManager().getRecipeFor(RecipeTypesPM.CONCOCTING.get(), (RecipeInput)testInput, level).map(RecipeHolder::value).orElse(null);
            if (entity.canConcoct(realInput, level.registryAccess(), recipe)) {
                ++entity.cookTime;
                if (entity.cookTime >= entity.cookTimeTotal) {
                    entity.cookTime = 0;
                    entity.cookTimeTotal = entity.getCookTimeTotal();
                    entity.doConcoction(realInput, level.registryAccess(), recipe);
                    shouldMarkDirty = true;
                }
            } else {
                entity.cookTime = Mth.clamp((int)(entity.cookTime - 2), (int)0, (int)entity.cookTimeTotal);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)ConcocterBlock.HAS_BOTTLE, (Comparable)Boolean.valueOf(entity.showBottle())), 2);
        }
        if (shouldMarkDirty) {
            entity.setChanged();
            entity.syncTile(true);
        }
    }

    protected boolean canConcoct(CraftingInput inputInv, RegistryAccess registryAccess, @Nullable IConcoctingRecipe recipe) {
        if (!inputInv.isEmpty() && recipe != null) {
            ItemStack output = recipe.getResultItem((HolderLookup.Provider)registryAccess);
            if (output.isEmpty()) {
                return false;
            }
            if (this.getMana(Sources.INFERNAL) < recipe.getManaCosts().getAmount(Sources.INFERNAL)) {
                return false;
            }
            if (!this.isResearchKnown(recipe.getRequirement())) {
                return false;
            }
            return this.getItem(2, 0).isEmpty();
        }
        return false;
    }

    protected void doConcoction(CraftingInput inputInv, RegistryAccess registryAccess, @Nullable IConcoctingRecipe recipe) {
        if (recipe != null && this.canConcoct(inputInv, registryAccess, recipe)) {
            ItemStack recipeOutput = recipe.assemble((RecipeInput)inputInv, (HolderLookup.Provider)registryAccess);
            ItemStack currentOutput = this.getItem(2, 0);
            if (currentOutput.isEmpty()) {
                this.setItem(2, 0, recipeOutput);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)recipeOutput, (ItemStack)currentOutput)) {
                currentOutput.grow(recipeOutput.getCount());
            }
            for (int index = 0; index < inputInv.size(); ++index) {
                ItemStack stack = inputInv.getItem(index);
                if (stack.isEmpty()) continue;
                stack.shrink(1);
            }
            this.setMana(Sources.INFERNAL, this.getMana(Sources.INFERNAL) - recipe.getManaCosts().getAmount(Sources.INFERNAL));
        }
    }

    protected boolean showBottle() {
        return this.cookTime > 0 || !this.getItem(2, 0).isEmpty();
    }

    protected int getCookTimeTotal() {
        return 100;
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Sources.getAllSorted()) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Sources.INFERNAL);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.setChanged();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.setChanged();
        this.syncTile(true);
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag;
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        boolean bl = flag = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack);
        if (invIndex == 0 && !flag) {
            this.cookTimeTotal = this.getCookTimeTotal();
            this.cookTime = 0;
            this.setChanged();
        }
    }

    public void fillStackedContents(StackedContents stackedContents) {
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            for (int slotIndex = 0; slotIndex < this.getInventorySize(invIndex); ++slotIndex) {
                stackedContents.accountStack(this.getItem(invIndex, slotIndex));
            }
        }
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0 -> 9;
            case 1 -> 1;
            case 2 -> 1;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.UP -> Optional.of(0);
            case Direction.DOWN -> Optional.of(2);
            default -> Optional.of(1);
        };
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.create((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), (AbstractTilePM)this));
        retVal.set(1, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), this).itemValidFunction((slot, stack) -> stack.getItem() instanceof IWand).build());
        retVal.set(2, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(2)), this).itemValidFunction((slot, stack) -> false).build());
        return retVal;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        ((ManaStorage)pComponentInput.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).copyManaInto(this.manaStorage);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)this.manaStorage);
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
        pTag.remove("ManaStorage");
    }
}

