/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.crafting;

import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.blocks.crafting.AbstractCalcinatorBlock;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ITileResearchCache;
import com.verdantartifice.primalmagick.common.capabilities.TileResearchCache;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.menus.CalcinatorMenu;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.common.tiles.base.ITieredDeviceBlockEntity;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class AbstractCalcinatorTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IOwnedTileEntity,
ITieredDeviceBlockEntity {
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int FUEL_INV_INDEX = 1;
    protected static final int OUTPUT_INV_INDEX = 2;
    protected static final int OUTPUT_CAPACITY = 9;
    protected int burnTime;
    protected int burnTimeTotal;
    protected int cookTime;
    protected int cookTimeTotal;
    protected UUID ownerUUID;
    protected ITileResearchCache researchCache;
    protected Set<AbstractResearchKey<?>> relevantResearch = Collections.emptySet();
    protected final Predicate<AbstractResearchKey<?>> relevantFilter = k -> this.getRelevantResearch().contains(k);
    protected final ContainerData calcinatorData = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return AbstractCalcinatorTileEntity.this.burnTime;
                }
                case 1: {
                    return AbstractCalcinatorTileEntity.this.burnTimeTotal;
                }
                case 2: {
                    return AbstractCalcinatorTileEntity.this.cookTime;
                }
                case 3: {
                    return AbstractCalcinatorTileEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractCalcinatorTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    AbstractCalcinatorTileEntity.this.burnTimeTotal = value;
                    break;
                }
                case 2: {
                    AbstractCalcinatorTileEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    AbstractCalcinatorTileEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public AbstractCalcinatorTileEntity(BlockEntityType<? extends AbstractCalcinatorTileEntity> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.researchCache = new TileResearchCache();
    }

    public ITileResearchCache getUncachedTileResearchCache() {
        return this.researchCache;
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0 -> 1;
            case 1 -> 1;
            case 2 -> 9;
            default -> 0;
        };
    }

    @Override
    public Optional<Integer> getInventoryIndexForFace(@NotNull Direction face) {
        return switch (face) {
            case Direction.UP -> Optional.of(0);
            case Direction.DOWN -> Optional.of(2);
            default -> Optional.of(1);
        };
    }

    @Override
    protected NonNullList<IItemHandlerPM> createItemHandlers() {
        NonNullList retVal = NonNullList.withSize((int)this.getInventoryCount(), (Object)Services.ITEM_HANDLERS.create(this));
        retVal.set(0, (Object)Services.ITEM_HANDLERS.create((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), (AbstractTilePM)this));
        retVal.set(1, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), this).itemValidFunction((slot, stack) -> AbstractCalcinatorTileEntity.isFuel(stack)).build());
        retVal.set(2, (Object)Services.ITEM_HANDLERS.builder((NonNullList<ItemStack>)((NonNullList)this.inventories.get(2)), this).itemValidFunction((slot, stack) -> false).build());
        return retVal;
    }

    protected boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        String ownerUUIDStr;
        super.loadAdditional(compound, registries);
        this.burnTime = compound.getInt("BurnTime");
        this.burnTimeTotal = compound.getInt("BurnTimeTotal");
        this.cookTime = compound.getInt("CookTime");
        this.cookTimeTotal = compound.getInt("CookTimeTotal");
        this.researchCache.deserializeNBT(registries, compound.getCompound("ResearchCache"));
        this.ownerUUID = null;
        if (compound.contains("OwnerUUID") && !(ownerUUIDStr = compound.getString("OwnerUUID")).isEmpty()) {
            this.ownerUUID = UUID.fromString(ownerUUIDStr);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("BurnTime", this.burnTime);
        compound.putInt("BurnTimeTotal", this.burnTimeTotal);
        compound.putInt("CookTime", this.cookTime);
        compound.putInt("CookTimeTotal", this.cookTimeTotal);
        compound.put("ResearchCache", this.researchCache.serializeNBT(registries));
        if (this.ownerUUID != null) {
            compound.putString("OwnerUUID", this.ownerUUID.toString());
        }
    }

    protected abstract boolean hasFuelRemainingItem(ItemStack var1);

    protected abstract ItemStack getFuelRemainingItem(ItemStack var1);

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractCalcinatorTileEntity entity) {
        boolean burningAtStart = entity.isBurning();
        boolean shouldMarkDirty = false;
        if (burningAtStart) {
            --entity.burnTime;
        }
        if (!level.isClientSide) {
            ItemStack inputStack = entity.getItem(0, 0);
            ItemStack fuelStack = entity.getItem(1, 0);
            if (entity.isBurning() || !fuelStack.isEmpty() && !inputStack.isEmpty()) {
                if (!entity.isBurning() && entity.canCalcinate(inputStack)) {
                    entity.burnTimeTotal = entity.burnTime = Services.EVENTS.getBurnTime(fuelStack, null);
                    if (entity.isBurning()) {
                        shouldMarkDirty = true;
                        if (entity.hasFuelRemainingItem(fuelStack)) {
                            entity.setItem(1, 0, entity.getFuelRemainingItem(fuelStack));
                        } else if (!fuelStack.isEmpty()) {
                            fuelStack.shrink(1);
                            if (fuelStack.isEmpty()) {
                                entity.setItem(1, 0, entity.getFuelRemainingItem(fuelStack));
                            }
                        }
                    }
                }
                if (entity.isBurning() && entity.canCalcinate(inputStack)) {
                    ++entity.cookTime;
                    if (entity.cookTime == entity.cookTimeTotal) {
                        entity.cookTime = 0;
                        entity.cookTimeTotal = entity.getCookTimeTotal();
                        entity.doCalcination();
                        shouldMarkDirty = true;
                    }
                } else {
                    entity.cookTime = 0;
                }
            } else if (!entity.isBurning() && entity.cookTime > 0) {
                entity.cookTime = Mth.clamp((int)(entity.cookTime - 2), (int)0, (int)entity.cookTimeTotal);
            }
            if (burningAtStart != entity.isBurning()) {
                shouldMarkDirty = true;
                level.setBlock(pos, (BlockState)state.setValue((Property)AbstractCalcinatorBlock.LIT, (Comparable)Boolean.valueOf(entity.isBurning())), 3);
            }
        }
        if (shouldMarkDirty) {
            entity.setChanged();
            entity.syncTile(true);
        }
    }

    @VisibleForTesting
    public void doCalcination() {
        ItemStack inputStack = this.getItem(0, 0);
        if (!inputStack.isEmpty() && this.canCalcinate(inputStack)) {
            List currentOutputs = (List)this.inventories.get(2);
            List<ItemStack> newOutputs = this.getCalcinationOutput(inputStack, false);
            List<ItemStack> mergedOutputs = ItemUtils.mergeItemStackLists(currentOutputs, newOutputs);
            for (int index = 0; index < Math.min(mergedOutputs.size(), 9); ++index) {
                ItemStack out = mergedOutputs.get(index);
                this.setItem(2, index, out == null ? ItemStack.EMPTY : out);
            }
            inputStack.shrink(1);
        }
    }

    protected abstract int getCookTimeTotal();

    public static boolean isFuel(ItemStack stack) {
        return Services.EVENTS.getBurnTime(stack, null) > 0;
    }

    protected boolean canCalcinate(ItemStack inputStack) {
        MutableBoolean retVal = new MutableBoolean(false);
        if (inputStack != null && !inputStack.isEmpty()) {
            AffinityManager.getInstance().getAffinityValues(inputStack, this.level).ifPresent(sources -> {
                if (!sources.isEmpty()) {
                    List<ItemStack> newOutputs;
                    List currentOutputs = (List)this.inventories.get(2);
                    List<ItemStack> mergedOutputs = ItemUtils.mergeItemStackLists(currentOutputs, newOutputs = this.getCalcinationOutput(inputStack, true));
                    retVal.setValue(mergedOutputs.size() <= 9);
                }
            });
        }
        return retVal.booleanValue();
    }

    @Nonnull
    protected abstract List<ItemStack> getCalcinationOutput(ItemStack var1, boolean var2);

    @Nonnull
    protected ItemStack getOutputEssence(EssenceType type, Source source, int count) {
        if (this.isSourceKnown(source)) {
            return EssenceItem.getEssence(type, source, count);
        }
        return new ItemStack((ItemLike)ItemsPM.ALCHEMICAL_WASTE.get(), count);
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
        return new CalcinatorMenu(windowId, playerInv, this.getBlockPos(), this, this.calcinatorData);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag;
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        boolean bl = flag = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack);
        if (invIndex == 0 && !flag) {
            this.cookTimeTotal = this.getCookTimeTotal();
            this.cookTime = 0;
            this.setChanged();
        }
    }

    @Override
    public void setTileOwner(Player owner) {
        this.ownerUUID = owner == null ? null : owner.getUUID();
        this.researchCache.update(owner, this.relevantFilter);
    }

    @Override
    public Player getTileOwner() {
        Level level;
        if (this.ownerUUID != null && this.hasLevel() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer livePlayer = serverLevel.getServer().getPlayerList().getPlayer(this.ownerUUID);
            if (livePlayer != null && livePlayer.tickCount % 20 == 0) {
                this.researchCache.update((Player)livePlayer, this.relevantFilter);
            }
            return livePlayer;
        }
        return null;
    }

    protected boolean isSourceKnown(@Nullable Source source) {
        if (source == null || source.getDiscoverKey().isEmpty()) {
            return true;
        }
        Player owner = this.getTileOwner();
        if (owner != null) {
            return source.isDiscovered(owner);
        }
        return this.researchCache.isResearchComplete(source.getDiscoverKey().get());
    }

    protected Set<AbstractResearchKey<?>> getRelevantResearch() {
        return this.relevantResearch;
    }

    protected static Set<AbstractResearchKey<?>> assembleRelevantResearch() {
        return Sources.streamSorted().map(Source::getDiscoverKey).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableSet());
    }
}

