/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.base;

import com.mojang.serialization.DynamicOps;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.items.IItemHandlerChangeListener;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.IRandomizableContents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTileSidedInventoryPM
extends AbstractTilePM
implements IRandomizableContents {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final NonNullList<NonNullList<ItemStack>> inventories;
    protected final NonNullList<NonNullList<ItemStack>> syncedInventories;
    protected final NonNullList<IItemHandlerPM> itemHandlers;
    protected final NonNullList<List<IItemHandlerChangeListener>> listeners;
    protected ResourceKey<LootTable> lootTable;
    protected long lootTableSeed;

    public AbstractTileSidedInventoryPM(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (Direction dir : Direction.values()) {
            this.getInventoryIndexForFace(dir).ifPresent(invIndex -> {
                if (invIndex < 0 || invIndex >= this.getInventoryCount()) {
                    throw new IllegalArgumentException("Face inventory mapping yields invalid index for direction " + dir.toString());
                }
            });
        }
        this.inventories = NonNullList.withSize((int)this.getInventoryCount(), (Object)NonNullList.create());
        this.syncedInventories = NonNullList.withSize((int)this.getInventoryCount(), (Object)NonNullList.create());
        for (int index = 0; index < this.getInventoryCount(); ++index) {
            this.inventories.set(index, (Object)NonNullList.withSize((int)this.getInventorySize(index), (Object)ItemStack.EMPTY));
            this.syncedInventories.set(index, (Object)NonNullList.withSize((int)this.getInventorySize(index), (Object)ItemStack.EMPTY));
        }
        this.itemHandlers = this.createItemHandlers();
        this.listeners = NonNullList.withSize((int)this.getInventoryCount(), new ArrayList());
    }

    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return Collections.emptySet();
    }

    public int getInventorySize(@Nullable Direction face) {
        MutableInt retVal = new MutableInt(0);
        if (face != null) {
            this.getInventoryIndexForFace(face).ifPresent(invIndex -> retVal.setValue(this.getInventorySize((int)invIndex)));
        }
        return retVal.getValue();
    }

    protected abstract int getInventoryCount();

    protected abstract int getInventorySize(int var1);

    public abstract Optional<Integer> getInventoryIndexForFace(@NotNull Direction var1);

    protected abstract NonNullList<IItemHandlerPM> createItemHandlers();

    @Nullable
    public IItemHandlerPM getRawItemHandler(@Nullable Direction face) {
        return face == null ? null : (IItemHandlerPM)this.getInventoryIndexForFace(face).map(arg_0 -> this.itemHandlers.get(arg_0)).orElse(null);
    }

    @Nullable
    public IItemHandlerPM getRawItemHandler(int index) {
        return index >= 0 && index < this.itemHandlers.size() ? (IItemHandlerPM)this.itemHandlers.get(index) : null;
    }

    public void addInventoryChangeListener(@Nullable Direction face, @NotNull IItemHandlerChangeListener listener) {
        if (face != null) {
            this.getInventoryIndexForFace(face).ifPresent(invIndex -> ((List)this.listeners.get(invIndex.intValue())).add(listener));
        }
    }

    public void removeInventoryChangeListener(IItemHandlerChangeListener listener) {
        this.listeners.forEach(invListeners -> invListeners.remove(listener));
    }

    public void setChanged() {
        super.setChanged();
        int index = 0;
        while (index < this.getInventoryCount()) {
            int invIndex = index++;
            ((List)this.listeners.get(invIndex)).forEach(listener -> listener.itemsChanged(invIndex, (IItemHandlerPM)this.itemHandlers.get(invIndex)));
        }
    }

    protected boolean isSyncedSlot(int inventoryIndex, int slotIndex) {
        return this.getSyncedSlotIndices(inventoryIndex).contains(slotIndex);
    }

    protected void syncSlots(@Nullable ServerPlayer player) {
        ListTag tagList = new ListTag();
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            for (int slotIndex = 0; slotIndex < this.getInventorySize(invIndex); ++slotIndex) {
                ItemStack stack = this.getItem(invIndex, slotIndex);
                if (!this.isSyncedSlot(invIndex, slotIndex) || stack.isEmpty()) continue;
                CompoundTag slotTag = new CompoundTag();
                byte invIndexByte = (byte)invIndex;
                slotTag.putByte("Inv", invIndexByte);
                byte slotIndexByte = (byte)slotIndex;
                slotTag.putByte("Slot", slotIndexByte);
                ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)this.getLevel().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack).resultOrPartial(msg -> LOGGER.error("Failed to encode inv {} slot {}: {}", (Object)invIndexByte, (Object)slotIndexByte, msg)).ifPresent(tag -> slotTag.put("Item", tag));
                tagList.add((Object)slotTag);
            }
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("ItemsSynced", (Tag)tagList);
        this.sendMessageToClient(nbt, player);
    }

    @Override
    public void syncTile(boolean rerender) {
        super.syncTile(rerender);
        this.syncSlots(null);
    }

    @Override
    public void onMessageFromClient(CompoundTag nbt, ServerPlayer player) {
        super.onMessageFromClient(nbt, player);
        if (nbt.contains("RequestSync")) {
            this.syncSlots(player);
        }
    }

    @Override
    public void onMessageFromServer(CompoundTag nbt) {
        super.onMessageFromServer(nbt);
        if (nbt.contains("ItemsSynced")) {
            for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
                ((NonNullList)this.syncedInventories.get(invIndex)).clear();
            }
            ListTag tagList = nbt.getList("ItemsSynced", 10);
            for (int tagIndex = 0; tagIndex < tagList.size(); ++tagIndex) {
                byte slotIndex;
                CompoundTag slotTag = tagList.getCompound(tagIndex);
                byte invIndex = slotTag.getByte("Inv");
                if (!this.isSyncedSlot(invIndex, slotIndex = slotTag.getByte("Slot"))) continue;
                ItemStack.OPTIONAL_CODEC.parse((DynamicOps)this.getLevel().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)slotTag.getCompound("Item")).resultOrPartial(msg -> LOGGER.error("Failed to decode inv {} slot {}: {}", (Object)invIndex, (Object)slotIndex, msg)).ifPresent(stack -> ((NonNullList)this.syncedInventories.get((int)invIndex)).set((int)slotIndex, stack));
            }
        }
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            ((NonNullList)this.inventories.get(invIndex)).clear();
        }
        if (!this.tryLoadLootTable(pTag) && pTag.contains("TileSidedInventoriesPM")) {
            ListTag listTag = pTag.getList("TileSidedInventoriesPM", 10);
            for (int invIndex = 0; invIndex < this.getInventoryCount() && invIndex < listTag.size(); ++invIndex) {
                CompoundTag invTag = listTag.getCompound(invIndex);
                ContainerHelper.loadAllItems((CompoundTag)invTag, (NonNullList)((NonNullList)this.inventories.get(invIndex)), (HolderLookup.Provider)pRegistries);
            }
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        ListTag listTag = new ListTag();
        if (!this.trySaveLootTable(pTag)) {
            for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
                CompoundTag invTag = new CompoundTag();
                ContainerHelper.saveAllItems((CompoundTag)invTag, (NonNullList)((NonNullList)this.inventories.get(invIndex)), (HolderLookup.Provider)pRegistries);
                listTag.add(invIndex, (Tag)invTag);
            }
        }
        pTag.put("TileSidedInventoriesPM", (Tag)listTag);
    }

    protected void doInventorySync() {
        if (!this.level.isClientSide) {
            this.syncSlots(null);
        } else {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("RequestSync", true);
            this.sendMessageToServer(nbt);
        }
    }

    public void dropContents(Level level, BlockPos pos) {
        this.inventories.forEach(inv -> Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)inv));
    }

    public ItemStack getItem(int invIndex, int slotIndex) {
        return (ItemStack)((NonNullList)this.inventories.get(invIndex)).get(slotIndex);
    }

    public ItemStack getSyncedItem(int invIndex, int slotIndex) {
        return (ItemStack)((NonNullList)this.syncedInventories.get(invIndex)).get(slotIndex);
    }

    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        ((IItemHandlerPM)this.itemHandlers.get(invIndex)).setStackInSlot(slotIndex, stack);
    }

    public ItemStack removeItem(int invIndex, int slotIndex, int amount) {
        return ((IItemHandlerPM)this.itemHandlers.get(invIndex)).extractItem(slotIndex, amount, false);
    }

    @Override
    public void setLootTable(ResourceKey<LootTable> lootTable, long lootTableSeed) {
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
    }

    @Override
    public void unpackLootTable(Player player) {
        if (this.lootTable != null && this.level.getServer() != null) {
            LootTable loot = this.level.getServer().reloadableRegistries().getLootTable(this.lootTable);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.GENERATE_LOOT.trigger(serverPlayer, this.lootTable);
            }
            this.lootTable = null;
            LootParams.Builder paramsBuilder = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition));
            if (player != null) {
                paramsBuilder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
            }
            this.getTargetRandomizedInventory().ifPresentOrElse(inv -> loot.fill(inv.asContainer(), paramsBuilder.create(LootContextParamSets.CHEST), this.lootTableSeed), () -> LOGGER.error("Attempting to unpack loot table into undefined destination!"));
        }
    }

    protected Optional<IItemHandlerPM> getTargetRandomizedInventory() {
        return Optional.empty();
    }

    protected boolean tryLoadLootTable(CompoundTag pTag) {
        if (pTag.contains("LootTable", 8)) {
            this.lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)pTag.getString("LootTable")));
            this.lootTableSeed = pTag.getLong("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean trySaveLootTable(CompoundTag pTag) {
        if (this.lootTable == null) {
            return false;
        }
        pTag.putString("LootTable", this.lootTable.location().toString());
        if (this.lootTableSeed != 0L) {
            pTag.putLong("LootTableSeed", this.lootTableSeed);
        }
        return true;
    }
}

