/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.base;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.TileToClientPacket;
import com.verdantartifice.primalmagick.common.network.packets.data.TileToServerPacket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractTilePM
extends BlockEntity {
    public AbstractTilePM(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void syncTile(boolean rerender) {
        if (this.hasLevel()) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            int flags = 2;
            if (!rerender) {
                flags |= 4;
            }
            this.level.sendBlockUpdated(this.worldPosition, state, state, flags);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag retVal = new CompoundTag();
        this.saveAdditional(retVal, registries);
        return retVal;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void sendMessageToClient(CompoundTag nbt, @Nullable ServerPlayer player) {
        Level level;
        if (this.hasLevel() && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player == null) {
                PacketHandler.sendToAllAround(new TileToClientPacket(this.worldPosition, nbt), serverLevel, this.worldPosition, 128.0);
            } else {
                PacketHandler.sendToPlayer(new TileToClientPacket(this.worldPosition, nbt), player);
            }
        }
    }

    public void sendMessageToServer(CompoundTag nbt) {
        if (this.hasLevel() && this.getLevel().isClientSide) {
            PacketHandler.sendToServer(new TileToServerPacket(this.worldPosition, nbt));
        }
    }

    public void onMessageFromClient(CompoundTag nbt, @Nonnull ServerPlayer player) {
    }

    public void onMessageFromServer(CompoundTag nbt) {
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }
}

