/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting.rewards;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.AbstractReward;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.RewardType;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.RewardTypesPM;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LootTableReward
extends AbstractReward<LootTableReward> {
    public static final MapCodec<LootTableReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("lootTable").forGetter(r -> r.lootTable), (App)ExtraCodecs.POSITIVE_INT.fieldOf("pullCount").forGetter(r -> r.pullCount), (App)Codec.STRING.fieldOf("descTranslationKey").forGetter(r -> r.descTranslationKey)).apply((Applicative)instance, LootTableReward::new));
    public static final StreamCodec<ByteBuf, LootTableReward> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE), reward -> reward.lootTable, (StreamCodec)ByteBufCodecs.VAR_INT, reward -> reward.pullCount, (StreamCodec)ByteBufCodecs.STRING_UTF8, reward -> reward.descTranslationKey, LootTableReward::new);
    private final ResourceKey<LootTable> lootTable;
    private final int pullCount;
    private final String descTranslationKey;

    protected LootTableReward(ResourceKey<LootTable> lootTable, int pullCount, String descTranslationKey) {
        this.lootTable = lootTable;
        this.pullCount = pullCount;
        this.descTranslationKey = descTranslationKey;
    }

    @Override
    protected RewardType<LootTableReward> getType() {
        return RewardTypesPM.LOOT_TABLE.get();
    }

    @Override
    public void grant(ServerPlayer player) {
        LootParams params = new LootParams.Builder(player.serverLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withLuck(player.getLuck()).create(LootContextParamSets.ADVANCEMENT_REWARD);
        boolean playSound = false;
        for (int index = 0; index < this.pullCount; ++index) {
            for (ItemStack stack : player.getServer().reloadableRegistries().getLootTable(this.lootTable).getRandomItems(params)) {
                if (!player.addItem(stack)) {
                    ItemEntity entity = player.drop(stack, false);
                    if (entity == null) continue;
                    entity.setNoPickUpDelay();
                    entity.setTarget(player.getUUID());
                    continue;
                }
                playSound = true;
            }
        }
        if (playSound) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    @Override
    public Component getDescription() {
        return Component.translatable((String)"label.primalmagick.research_table.reward", (Object[])new Object[]{this.pullCount, Component.translatable((String)this.descTranslationKey)});
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LootTableReward)) {
            return false;
        }
        LootTableReward that = (LootTableReward)o;
        return this.pullCount == that.pullCount && Objects.equals(this.lootTable, that.lootTable) && Objects.equals(this.descTranslationKey, that.descTranslationKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lootTable, this.pullCount, this.descTranslationKey);
    }

    public static Builder builder(ResourceKey<LootTable> lootTable) {
        return new Builder(lootTable);
    }

    public static class Builder {
        protected final ResourceKey<LootTable> lootTable;
        protected int pullCount = 1;
        protected String descTranslationKey = null;

        protected Builder(ResourceKey<LootTable> lootTable) {
            this.lootTable = (ResourceKey)Preconditions.checkNotNull(lootTable);
        }

        public Builder pulls(int count) {
            this.pullCount = count;
            return this;
        }

        public Builder description(String translationKey) {
            this.descTranslationKey = translationKey;
            return this;
        }

        private void validate() {
            if (this.pullCount <= 0) {
                throw new IllegalStateException("Reward pull count must be positive");
            }
            if (this.descTranslationKey == null || this.descTranslationKey.isEmpty()) {
                throw new IllegalStateException("Reward description translation key must not be empty");
            }
        }

        public LootTableReward build() {
            this.validate();
            return new LootTableReward(this.lootTable, this.pullCount, this.descTranslationKey);
        }
    }
}

