/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting.rewards;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.AbstractReward;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.RewardType;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.RewardTypesPM;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;

public class ExperienceReward
extends AbstractReward<ExperienceReward> {
    public static final MapCodec<ExperienceReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("points").forGetter(r -> r.points)).apply((Applicative)instance, ExperienceReward::new));
    public static final StreamCodec<ByteBuf, ExperienceReward> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, reward -> reward.points, ExperienceReward::new);
    private final int points;

    public ExperienceReward(int points) {
        this.points = points;
    }

    @Override
    protected RewardType<ExperienceReward> getType() {
        return RewardTypesPM.EXPERIENCE.get();
    }

    @Override
    public void grant(ServerPlayer player) {
        player.giveExperiencePoints(this.points);
    }

    @Override
    public Component getDescription() {
        MutableComponent label = Component.translatable((String)"label.primalmagick.experience.points");
        return Component.translatable((String)"label.primalmagick.research_table.reward", (Object[])new Object[]{this.points, label});
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ExperienceReward)) {
            return false;
        }
        ExperienceReward that = (ExperienceReward)o;
        return this.points == that.points;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.points);
    }
}

