/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting.materials;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ProjectMaterialType;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ProjectMaterialTypesPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class ObservationProjectMaterial
extends AbstractProjectMaterial<ObservationProjectMaterial> {
    protected final int count;
    protected final boolean consumed;

    public static MapCodec<ObservationProjectMaterial> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("count").forGetter(ObservationProjectMaterial::getCount), (App)Codec.BOOL.fieldOf("consumed").forGetter(ObservationProjectMaterial::isConsumed), (App)Codec.DOUBLE.fieldOf("weight").forGetter(AbstractProjectMaterial::getWeight), (App)Codec.DOUBLE.fieldOf("bonusReward").forGetter(AbstractProjectMaterial::getBonusReward), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("requirement").forGetter(AbstractProjectMaterial::getRequirement)).apply((Applicative)instance, ObservationProjectMaterial::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ObservationProjectMaterial> streamCodec() {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ObservationProjectMaterial::getCount, (StreamCodec)ByteBufCodecs.BOOL, ObservationProjectMaterial::isConsumed, (StreamCodec)ByteBufCodecs.DOUBLE, AbstractProjectMaterial::getWeight, (StreamCodec)ByteBufCodecs.DOUBLE, AbstractProjectMaterial::getBonusReward, (StreamCodec)ByteBufCodecs.optional(AbstractRequirement.dispatchStreamCodec()), AbstractProjectMaterial::getRequirement, ObservationProjectMaterial::new);
    }

    protected ObservationProjectMaterial(int count, boolean consumed, double weight, double bonusReward, Optional<AbstractRequirement<?>> requirement) {
        super(weight, bonusReward, requirement);
        this.count = count;
        this.consumed = consumed;
    }

    @Override
    protected ProjectMaterialType<ObservationProjectMaterial> getType() {
        return ProjectMaterialTypesPM.OBSERVATION.get();
    }

    @Override
    public boolean isSatisfied(Player player, Set<Block> surroundings) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge(player).orElse(null);
        return knowledge != null && knowledge.getKnowledge(KnowledgeType.OBSERVATION) >= this.count;
    }

    @Override
    public boolean consume(Player player) {
        return ResearchManager.addKnowledge(player, KnowledgeType.OBSERVATION, -1 * this.count * KnowledgeType.OBSERVATION.getProgression());
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.consumed ? 1231 : 1237);
        result = 31 * result + this.count;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObservationProjectMaterial other = (ObservationProjectMaterial)obj;
        if (this.consumed != other.consumed) {
            return false;
        }
        return this.count == other.count;
    }

    public static Builder builder(int count) {
        return new Builder(count);
    }

    public static class Builder
    extends AbstractProjectMaterial.Builder<ObservationProjectMaterial, Builder> {
        protected final int count;
        protected boolean consumed = false;

        protected Builder(int count) {
            this.count = count;
        }

        public Builder consumed() {
            this.consumed = true;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.count <= 0) {
                throw new IllegalStateException("Material count must be positive");
            }
        }

        @Override
        public ObservationProjectMaterial build() {
            this.validate();
            return new ObservationProjectMaterial(this.count, this.consumed, this.weight, this.bonusReward, this.getFinalRequirement());
        }
    }
}

