/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting.materials;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ProjectMaterialType;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ProjectMaterialTypesPM;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import com.verdantartifice.primalmagick.common.util.StreamCodecUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ItemTagProjectMaterial
extends AbstractProjectMaterial<ItemTagProjectMaterial> {
    protected final TagKey<Item> tag;
    protected final int quantity;
    protected final boolean consumed;

    public static MapCodec<ItemTagProjectMaterial> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(ItemTagProjectMaterial::getTag), (App)ExtraCodecs.POSITIVE_INT.fieldOf("quantity").forGetter(ItemTagProjectMaterial::getQuantity), (App)Codec.BOOL.fieldOf("consumed").forGetter(ItemTagProjectMaterial::isConsumed), (App)Codec.DOUBLE.fieldOf("weight").forGetter(AbstractProjectMaterial::getWeight), (App)Codec.DOUBLE.fieldOf("bonusReward").forGetter(AbstractProjectMaterial::getBonusReward), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("requirement").forGetter(AbstractProjectMaterial::getRequirement)).apply((Applicative)instance, ItemTagProjectMaterial::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemTagProjectMaterial> streamCodec() {
        return StreamCodec.composite(StreamCodecUtils.tagKey(Registries.ITEM), ItemTagProjectMaterial::getTag, (StreamCodec)ByteBufCodecs.VAR_INT, ItemTagProjectMaterial::getQuantity, (StreamCodec)ByteBufCodecs.BOOL, ItemTagProjectMaterial::isConsumed, (StreamCodec)ByteBufCodecs.DOUBLE, AbstractProjectMaterial::getWeight, (StreamCodec)ByteBufCodecs.DOUBLE, AbstractProjectMaterial::getBonusReward, (StreamCodec)ByteBufCodecs.optional(AbstractRequirement.dispatchStreamCodec()), AbstractProjectMaterial::getRequirement, ItemTagProjectMaterial::new);
    }

    protected ItemTagProjectMaterial(TagKey<Item> tag, int quantity, boolean consumed, double weight, double bonusReward, Optional<AbstractRequirement<?>> requirement) {
        super(weight, bonusReward, requirement);
        this.tag = tag;
        this.quantity = quantity;
        this.consumed = consumed;
    }

    @Override
    protected ProjectMaterialType<ItemTagProjectMaterial> getType() {
        return ProjectMaterialTypesPM.ITEM_TAG.get();
    }

    @Override
    public boolean isSatisfied(Player player, Set<Block> surroundings) {
        if (InventoryUtils.isPlayerCarrying(player, this.tag, this.quantity)) {
            return true;
        }
        if (!this.consumed && this.quantity == 1 && surroundings != null) {
            TagKey blockTagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)this.tag.location());
            ArrayList tagContents = new ArrayList();
            Services.BLOCKS_REGISTRY.getTag(blockTagKey).forEach(tagContents::add);
            HashSet<Block> intersection = new HashSet<Block>(surroundings);
            intersection.retainAll(tagContents);
            return !intersection.isEmpty();
        }
        return false;
    }

    @Override
    public boolean consume(Player player) {
        if (this.consumed) {
            return InventoryUtils.consumeItem(player, this.tag, this.quantity);
        }
        return true;
    }

    @Nullable
    public TagKey<Item> getTag() {
        return this.tag;
    }

    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.consumed ? 1231 : 1237);
        result = 31 * result + this.quantity;
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemTagProjectMaterial other = (ItemTagProjectMaterial)obj;
        if (this.consumed != other.consumed) {
            return false;
        }
        if (this.quantity != other.quantity) {
            return false;
        }
        return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
    }

    public static Builder builder(TagKey<Item> tag) {
        return new Builder(tag);
    }

    public static class Builder
    extends AbstractProjectMaterial.Builder<ItemTagProjectMaterial, Builder> {
        protected final TagKey<Item> tag;
        protected int quantity = 1;
        protected boolean consumed = false;

        protected Builder(TagKey<Item> tag) {
            this.tag = (TagKey)Preconditions.checkNotNull(tag);
        }

        public Builder quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder consumed() {
            this.consumed = true;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.quantity <= 0) {
                throw new IllegalStateException("Material quantity must be positive");
            }
        }

        @Override
        public ItemTagProjectMaterial build() {
            this.validate();
            return new ItemTagProjectMaterial(this.tag, this.quantity, this.consumed, this.weight, this.bonusReward, this.getFinalRequirement());
        }
    }
}

