/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting.materials;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ProjectMaterialType;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ProjectMaterialTypesPM;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import com.verdantartifice.primalmagick.common.util.StreamCodecUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ItemProjectMaterial
extends AbstractProjectMaterial<ItemProjectMaterial> {
    protected final ItemStack stack;
    protected final boolean consumed;
    protected final boolean matchNBT;
    protected final int afterCrafting;

    public static MapCodec<ItemProjectMaterial> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("stack").forGetter(ItemProjectMaterial::getItemStack), (App)Codec.BOOL.fieldOf("consumed").forGetter(ItemProjectMaterial::isConsumed), (App)Codec.BOOL.fieldOf("matchNBT").forGetter(material -> material.matchNBT), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("afterCrafting").forGetter(ItemProjectMaterial::getAfterCrafting), (App)Codec.DOUBLE.fieldOf("weight").forGetter(AbstractProjectMaterial::getWeight), (App)Codec.DOUBLE.fieldOf("bonusReward").forGetter(AbstractProjectMaterial::getBonusReward), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("requirement").forGetter(AbstractProjectMaterial::getRequirement)).apply((Applicative)instance, ItemProjectMaterial::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemProjectMaterial> streamCodec() {
        return StreamCodecUtils.composite(ItemStack.STREAM_CODEC, ItemProjectMaterial::getItemStack, ByteBufCodecs.BOOL, ItemProjectMaterial::isConsumed, ByteBufCodecs.BOOL, mat -> mat.matchNBT, ByteBufCodecs.VAR_INT, ItemProjectMaterial::getAfterCrafting, ByteBufCodecs.DOUBLE, AbstractProjectMaterial::getWeight, ByteBufCodecs.DOUBLE, AbstractProjectMaterial::getBonusReward, ByteBufCodecs.optional(AbstractRequirement.dispatchStreamCodec()), AbstractProjectMaterial::getRequirement, ItemProjectMaterial::new);
    }

    protected ItemProjectMaterial(ItemStack stack, boolean consumed, boolean matchNBT, int afterCrafting, double weight, double bonusReward, Optional<AbstractRequirement<?>> requirement) {
        super(weight, bonusReward, requirement);
        this.stack = stack.copy();
        this.consumed = consumed;
        this.matchNBT = matchNBT;
        this.afterCrafting = afterCrafting;
    }

    @Override
    protected ProjectMaterialType<ItemProjectMaterial> getType() {
        return ProjectMaterialTypesPM.ITEM.get();
    }

    @Override
    public boolean isSatisfied(Player player, Set<Block> surroundings) {
        BlockItem blockItem;
        Item item;
        if (InventoryUtils.isPlayerCarrying(player, this.stack, this.matchNBT)) {
            return true;
        }
        return !this.consumed && this.stack.getCount() == 1 && surroundings != null && (item = this.stack.getItem()) instanceof BlockItem && surroundings.contains((blockItem = (BlockItem)item).getBlock());
    }

    @Override
    public boolean consume(Player player) {
        if (this.consumed) {
            return InventoryUtils.consumeItem(player, this.stack, this.matchNBT);
        }
        return true;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    public int getAfterCrafting() {
        return this.afterCrafting;
    }

    @Override
    public boolean isAllowedInProject(ServerPlayer player) {
        return super.isAllowedInProject(player) && player.getStats().getValue(Stats.ITEM_CRAFTED.get((Object)this.getItemStack().getItem())) >= this.getAfterCrafting();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.afterCrafting, this.consumed, this.matchNBT, this.stack);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemProjectMaterial other = (ItemProjectMaterial)obj;
        return this.afterCrafting == other.afterCrafting && this.consumed == other.consumed && this.matchNBT == other.matchNBT && ItemStack.matches((ItemStack)this.stack, (ItemStack)other.stack);
    }

    public static Builder builder(ItemStack stack) {
        return new Builder(stack);
    }

    public static Builder builder(ItemLike item, int count) {
        return ItemProjectMaterial.builder(new ItemStack((ItemLike)((ItemLike)Preconditions.checkNotNull((Object)item)).asItem(), count));
    }

    public static Builder builder(ItemLike item) {
        return ItemProjectMaterial.builder(item, 1);
    }

    public static class Builder
    extends AbstractProjectMaterial.Builder<ItemProjectMaterial, Builder> {
        protected final ItemStack stack;
        protected boolean consumed = false;
        protected boolean matchNBT = false;
        protected int afterCrafting = 0;

        protected Builder(ItemStack stack) {
            this.stack = ((ItemStack)Preconditions.checkNotNull((Object)stack)).copy();
        }

        public Builder consumed() {
            this.consumed = true;
            return this;
        }

        public Builder matchNbt() {
            this.matchNBT = true;
            return this;
        }

        public Builder afterCrafting(int count) {
            this.afterCrafting = count;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.afterCrafting < 0) {
                throw new IllegalStateException("Material crafting minimum must be non-negative");
            }
        }

        @Override
        public ItemProjectMaterial build() {
            this.validate();
            return new ItemProjectMaterial(this.stack, this.consumed, this.matchNBT, this.afterCrafting, this.weight, this.bonusReward, this.getFinalRequirement());
        }
    }
}

