/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting.materials;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ProjectMaterialType;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ProjectMaterialTypesPM;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class ExperienceProjectMaterial
extends AbstractProjectMaterial<ExperienceProjectMaterial> {
    protected final int levels;
    protected final boolean consumed;

    public static MapCodec<ExperienceProjectMaterial> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("levels").forGetter(ExperienceProjectMaterial::getLevels), (App)Codec.BOOL.fieldOf("consumed").forGetter(ExperienceProjectMaterial::isConsumed), (App)Codec.DOUBLE.fieldOf("weight").forGetter(AbstractProjectMaterial::getWeight), (App)Codec.DOUBLE.fieldOf("bonusReward").forGetter(AbstractProjectMaterial::getBonusReward), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("requirement").forGetter(AbstractProjectMaterial::getRequirement)).apply((Applicative)instance, ExperienceProjectMaterial::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ExperienceProjectMaterial> streamCodec() {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ExperienceProjectMaterial::getLevels, (StreamCodec)ByteBufCodecs.BOOL, ExperienceProjectMaterial::isConsumed, (StreamCodec)ByteBufCodecs.DOUBLE, AbstractProjectMaterial::getWeight, (StreamCodec)ByteBufCodecs.DOUBLE, AbstractProjectMaterial::getBonusReward, (StreamCodec)ByteBufCodecs.optional(AbstractRequirement.dispatchStreamCodec()), AbstractProjectMaterial::getRequirement, ExperienceProjectMaterial::new);
    }

    protected ExperienceProjectMaterial(int levels, boolean consumed, double weight, double bonusReward, Optional<AbstractRequirement<?>> requirement) {
        super(weight, bonusReward, requirement);
        this.levels = levels;
        this.consumed = consumed;
    }

    @Override
    protected ProjectMaterialType<ExperienceProjectMaterial> getType() {
        return ProjectMaterialTypesPM.EXPERIENCE.get();
    }

    @Override
    public boolean isSatisfied(Player player, Set<Block> surroundings) {
        return player.experienceLevel >= this.levels;
    }

    @Override
    public boolean consume(Player player) {
        player.giveExperienceLevels(-1 * this.levels);
        return true;
    }

    public int getLevels() {
        return this.levels;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.consumed ? 1231 : 1237);
        result = 31 * result + this.levels;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExperienceProjectMaterial other = (ExperienceProjectMaterial)obj;
        if (this.consumed != other.consumed) {
            return false;
        }
        return this.levels == other.levels;
    }

    public static Builder builder(int levels) {
        return new Builder(levels);
    }

    public static class Builder
    extends AbstractProjectMaterial.Builder<ExperienceProjectMaterial, Builder> {
        protected final int levels;
        protected boolean consumed = false;

        protected Builder(int levels) {
            this.levels = levels;
        }

        public Builder consumed() {
            this.consumed = true;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.levels <= 0) {
                throw new IllegalStateException("Material levels must be positive");
            }
        }

        @Override
        public ExperienceProjectMaterial build() {
            this.validate();
            return new ExperienceProjectMaterial(this.levels, this.consumed, this.weight, this.bonusReward, this.getFinalRequirement());
        }
    }
}

