/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting.materials;

import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.AndRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ProjectMaterialType;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public abstract class AbstractProjectMaterial<T extends AbstractProjectMaterial<T>> {
    protected final double weight;
    protected final double bonusReward;
    protected final Optional<AbstractRequirement<?>> requirement;

    public static Codec<AbstractProjectMaterial<?>> dispatchCodec() {
        return Services.PROJECT_MATERIAL_TYPES_REGISTRY.codec().dispatch("material_type", AbstractProjectMaterial::getType, type -> type.codecSupplier().get());
    }

    public static StreamCodec<RegistryFriendlyByteBuf, AbstractProjectMaterial<?>> dispatchStreamCodec() {
        return Services.PROJECT_MATERIAL_TYPES_REGISTRY.registryFriendlyStreamCodec().dispatch(AbstractProjectMaterial::getType, type -> type.streamCodecSupplier().get());
    }

    protected AbstractProjectMaterial(double weight, double bonusReward, Optional<AbstractRequirement<?>> requirement) {
        this.weight = weight;
        this.bonusReward = bonusReward;
        this.requirement = requirement;
    }

    protected abstract ProjectMaterialType<T> getType();

    public static AbstractProjectMaterial<?> fromNetwork(RegistryFriendlyByteBuf buf) {
        return (AbstractProjectMaterial)AbstractProjectMaterial.dispatchStreamCodec().decode((Object)buf);
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        AbstractProjectMaterial.dispatchStreamCodec().encode((Object)buf, (Object)this);
    }

    public abstract boolean isSatisfied(Player var1, Set<Block> var2);

    public abstract boolean consume(Player var1);

    public abstract boolean isConsumed();

    public double getWeight() {
        return this.weight;
    }

    public double getBonusReward() {
        return this.bonusReward;
    }

    @Nonnull
    public Optional<AbstractRequirement<?>> getRequirement() {
        return this.requirement;
    }

    public boolean isAllowedInProject(ServerPlayer player) {
        return this.hasRequiredResearch((Player)player);
    }

    public boolean hasRequiredResearch(Player player) {
        return this.requirement.map(req -> req.isMetBy(player)).orElse(true);
    }

    public int hashCode() {
        return Objects.hash(this.bonusReward, this.requirement, this.weight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProjectMaterial other = (AbstractProjectMaterial)obj;
        return Double.doubleToLongBits(this.bonusReward) == Double.doubleToLongBits(other.bonusReward) && Objects.equals(this.requirement, other.requirement) && Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
    }

    public static abstract class Builder<T extends AbstractProjectMaterial<T>, U extends Builder<T, U>> {
        protected double weight = 1.0;
        protected double bonusReward = 0.0;
        protected final List<AbstractRequirement<?>> requirements = new ArrayList();

        private U self() {
            return (U)this;
        }

        public U weight(double weight) {
            this.weight = weight;
            return this.self();
        }

        public U bonusReward(double bonus) {
            this.bonusReward = bonus;
            return this.self();
        }

        public U requirement(AbstractRequirement<?> req) {
            this.requirements.add(req);
            return this.self();
        }

        public U requiredResearch(ResourceKey<ResearchEntry> rawKey) {
            return this.requirement(new ResearchRequirement(new ResearchEntryKey(rawKey)));
        }

        protected Optional<AbstractRequirement<?>> getFinalRequirement() {
            if (this.requirements.isEmpty()) {
                return Optional.empty();
            }
            if (this.requirements.size() == 1) {
                return Optional.of(this.requirements.get(0));
            }
            return Optional.of(new AndRequirement(this.requirements));
        }

        protected void validate() {
            if (this.weight <= 0.0) {
                throw new IllegalStateException("Material weight must be positive");
            }
            if (this.bonusReward < 0.0) {
                throw new IllegalStateException("Material bonus reward must be non-negative");
            }
        }

        public abstract T build();
    }

    @FunctionalInterface
    public static interface Reader<T extends AbstractProjectMaterial<T>>
    extends Function4<FriendlyByteBuf, Double, Double, Optional<AbstractRequirement<?>>, T> {
    }
}

