/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.theorycrafting.ProjectTemplate;
import com.verdantartifice.primalmagick.common.theorycrafting.ProjectTemplates;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class TheorycraftManager {
    @Nonnull
    public static Project createRandomProject(@Nonnull ServerPlayer player, @Nonnull BlockPos tablePos) {
        WeightedRandomBag templateBag = new WeightedRandomBag();
        ProjectTemplates.stream(player.level().registryAccess()).forEach(template -> templateBag.add(template, template.getWeight((Player)player)));
        HashSet<Block> nearby = new HashSet<Block>();
        Level level = player.level();
        if (Services.LEVEL.isAreaLoaded(level, tablePos, 5)) {
            Iterable positions = BlockPos.betweenClosed((BlockPos)tablePos.offset(-5, -5, -5), (BlockPos)tablePos.offset(5, 5, 5));
            for (BlockPos pos : positions) {
                nearby.add(level.getBlockState(pos).getBlock());
            }
        }
        Project retVal = null;
        for (int attempts = 0; retVal == null && attempts < 1000; ++attempts) {
            ProjectTemplate selectedTemplate = (ProjectTemplate)templateBag.getRandom(player.getRandom());
            Project initializedProject = selectedTemplate.initialize(player, nearby);
            if (initializedProject == null) continue;
            retVal = initializedProject;
        }
        return retVal;
    }

    @Nonnull
    protected static Set<ResourceLocation> getAllAidBlockIds(RegistryAccess registryAccess) {
        return ProjectTemplates.stream(registryAccess).flatMap(t -> t.aidBlocks().stream()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<Block> getNearbyAidBlocks(Level level, BlockPos pos) {
        Set<ResourceLocation> allAids = TheorycraftManager.getAllAidBlockIds(level.registryAccess());
        return TheorycraftManager.getSurroundingsInner(level, pos, b -> allAids.contains(Services.BLOCKS_REGISTRY.getKey(b)));
    }

    @Nonnull
    public static Set<Block> getSurroundings(Level level, BlockPos pos) {
        return TheorycraftManager.getSurroundingsInner(level, pos, b -> true);
    }

    @Nonnull
    protected static Set<Block> getSurroundingsInner(Level level, BlockPos pos, Predicate<Block> filter) {
        HashSet<Block> retVal = new HashSet<Block>();
        if (Services.LEVEL.isAreaLoaded(level, pos, 5)) {
            Iterable positions = BlockPos.betweenClosed((BlockPos)pos.offset(-5, -5, -5), (BlockPos)pos.offset(5, 5, 5));
            for (BlockPos searchPos : positions) {
                Block block = level.getBlockState(searchPos).getBlock();
                if (!filter.test(block)) continue;
                retVal.add(block);
            }
        }
        return retVal;
    }
}

