/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.AndRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.QuorumRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.theorycrafting.MaterialInstance;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.AbstractReward;
import com.verdantartifice.primalmagick.common.theorycrafting.weights.AbstractWeightFunction;
import com.verdantartifice.primalmagick.common.util.StreamCodecUtils;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public record ProjectTemplate(List<AbstractProjectMaterial<?>> materialOptions, List<AbstractReward<?>> otherRewards, Optional<AbstractRequirement<?>> requirement, Optional<Integer> requiredMaterialCountOverride, Optional<Double> baseSuccessChanceOverride, double rewardMultiplier, List<ResourceLocation> aidBlocks, Optional<AbstractWeightFunction<?>> weightFunction) {
    public static final int MAX_MATERIALS = 4;

    public static Codec<ProjectTemplate> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)AbstractProjectMaterial.dispatchCodec().listOf().fieldOf("materialOptions").forGetter(ProjectTemplate::materialOptions), (App)AbstractReward.dispatchCodec().listOf().fieldOf("otherRewards").forGetter(ProjectTemplate::otherRewards), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("requirement").forGetter(ProjectTemplate::requirement), (App)Codec.INT.optionalFieldOf("requiredMaterialCountOverride").forGetter(ProjectTemplate::requiredMaterialCountOverride), (App)Codec.DOUBLE.optionalFieldOf("baseSuccessChanceOverride").forGetter(ProjectTemplate::baseSuccessChanceOverride), (App)Codec.DOUBLE.fieldOf("rewardMultiplier").forGetter(ProjectTemplate::rewardMultiplier), (App)ResourceLocation.CODEC.listOf().fieldOf("aidBlocks").forGetter(ProjectTemplate::aidBlocks), (App)AbstractWeightFunction.dispatchCodec().optionalFieldOf("weightFunction").forGetter(ProjectTemplate::weightFunction)).apply((Applicative)instance, ProjectTemplate::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ProjectTemplate> streamCodec() {
        return StreamCodecUtils.composite(AbstractProjectMaterial.dispatchStreamCodec().apply(ByteBufCodecs.list()), ProjectTemplate::materialOptions, AbstractReward.dispatchStreamCodec().apply(ByteBufCodecs.list()), ProjectTemplate::otherRewards, ByteBufCodecs.optional(AbstractRequirement.dispatchStreamCodec()), ProjectTemplate::requirement, ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), ProjectTemplate::requiredMaterialCountOverride, ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.DOUBLE), ProjectTemplate::baseSuccessChanceOverride, ByteBufCodecs.DOUBLE, ProjectTemplate::rewardMultiplier, ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), ProjectTemplate::aidBlocks, ByteBufCodecs.optional(AbstractWeightFunction.dispatchStreamCodec()), ProjectTemplate::weightFunction, ProjectTemplate::new);
    }

    public double getWeight(Player player) {
        return this.weightFunction.map(func -> func.getWeight(player)).orElse(1.0);
    }

    @Nullable
    public Project initialize(ServerPlayer player, Set<Block> nearby) {
        if (this.requirement.isPresent() && !this.requirement.get().isMetBy((Player)player)) {
            return null;
        }
        RegistryAccess registryAccess = player.level().registryAccess();
        ResourceKey key = registryAccess.registryOrThrow(RegistryKeysPM.PROJECT_TEMPLATES).getResourceKey((Object)this).orElse(null);
        if (key == null) {
            return null;
        }
        ResourceLocation foundAid = null;
        if (!this.aidBlocks.isEmpty()) {
            boolean found = false;
            Set nearbyIds = nearby.stream().map(b -> Services.BLOCKS_REGISTRY.getKey(b)).collect(Collectors.toUnmodifiableSet());
            for (ResourceLocation aidBlock : this.aidBlocks) {
                if (!nearbyIds.contains(aidBlock)) continue;
                found = true;
                foundAid = aidBlock;
                break;
            }
            if (!found) {
                return null;
            }
        }
        int maxMaterials = this.getRequiredMaterialCount((Player)player);
        ArrayList<MaterialInstance> materials = new ArrayList<MaterialInstance>();
        HashSet chosen = new HashSet();
        WeightedRandomBag<AbstractProjectMaterial<?>> options = this.getMaterialOptions(player);
        for (int attempts = 0; materials.size() < maxMaterials && attempts < 1000; ++attempts) {
            AbstractProjectMaterial<?> material = options.getRandom(player.getRandom());
            if (chosen.contains(material)) continue;
            chosen.add(material);
            materials.add(new MaterialInstance(material));
        }
        if (materials.size() < maxMaterials) {
            return null;
        }
        return new Project((ResourceKey<ProjectTemplate>)key, materials, this.otherRewards, this.getBaseSuccessChance((Player)player), this.rewardMultiplier, Optional.ofNullable(foundAid));
    }

    protected int getRequiredMaterialCount(Player player) {
        return this.requiredMaterialCountOverride.orElseGet(() -> {
            int completed = StatsManager.getValue(player, StatsPM.RESEARCH_PROJECTS_COMPLETED);
            return Math.min(4, 1 + completed / 5);
        });
    }

    protected double getBaseSuccessChance(Player player) {
        return this.baseSuccessChanceOverride.orElseGet(() -> {
            int completed = StatsManager.getValue(player, StatsPM.RESEARCH_PROJECTS_COMPLETED);
            return Math.max(0.0, 0.5 - 0.1 * (double)(completed / 3));
        });
    }

    @Nonnull
    protected WeightedRandomBag<AbstractProjectMaterial<?>> getMaterialOptions(ServerPlayer player) {
        WeightedRandomBag retVal = new WeightedRandomBag();
        for (AbstractProjectMaterial<?> material : this.materialOptions) {
            if (!material.isAllowedInProject(player)) continue;
            retVal.add(material, material.getWeight());
        }
        return retVal;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected final List<AbstractProjectMaterial<?>> materialOptions = new ArrayList();
        protected final List<AbstractReward<?>> otherRewards = new ArrayList();
        protected final List<AbstractRequirement<?>> requirements = new ArrayList();
        protected Optional<Integer> requiredMaterialCountOverride = Optional.empty();
        protected Optional<Double> baseSuccessChanceOverride = Optional.empty();
        protected double rewardMultiplier = 0.25;
        protected final List<ResourceLocation> aidBlocks = new ArrayList<ResourceLocation>();
        protected Optional<AbstractWeightFunction<?>> weightFunction = Optional.empty();

        protected Builder() {
        }

        public Builder material(AbstractProjectMaterial<?> material) {
            this.materialOptions.add(material);
            return this;
        }

        public Builder otherReward(AbstractReward<?> reward) {
            this.otherRewards.add(reward);
            return this;
        }

        public Builder requirement(AbstractRequirement<?> requirement) {
            this.requirements.add(requirement);
            return this;
        }

        public Builder requiredResearch(ResourceKey<ResearchEntry> rawKey) {
            return this.requirement(new ResearchRequirement(new ResearchEntryKey(rawKey)));
        }

        @SafeVarargs
        public final Builder quorumResearch(int count, ResourceKey<ResearchEntry> ... rawKeys) {
            return this.requirement(new QuorumRequirement(count, (AbstractRequirement[])Arrays.stream(rawKeys).map(k -> new ResearchRequirement(new ResearchEntryKey((ResourceKey<ResearchEntry>)k))).toArray(AbstractRequirement[]::new)));
        }

        public Builder materialCountOverride(int value) {
            this.requiredMaterialCountOverride = Optional.of(value);
            return this;
        }

        public Builder baseSuccessChanceOverride(double value) {
            this.baseSuccessChanceOverride = Optional.of(value);
            return this;
        }

        public Builder rewardMultiplier(double multiplier) {
            this.rewardMultiplier = multiplier;
            return this;
        }

        public Builder aid(Block block) {
            this.aidBlocks.add(Services.BLOCKS_REGISTRY.getKey((Block)Preconditions.checkNotNull((Object)block)));
            return this;
        }

        public Builder weightFunction(AbstractWeightFunction<?> func) {
            this.weightFunction = Optional.of(func);
            return this;
        }

        protected Optional<AbstractRequirement<?>> getFinalRequirement() {
            if (this.requirements.isEmpty()) {
                return Optional.empty();
            }
            if (this.requirements.size() == 1) {
                return Optional.of(this.requirements.get(0));
            }
            return Optional.of(new AndRequirement(this.requirements));
        }

        private void validate() {
            int maxMaterialCount = this.requiredMaterialCountOverride.orElse(4);
            if (this.materialOptions.size() < maxMaterialCount) {
                throw new IllegalStateException("Project template must have at least " + maxMaterialCount + " material option(s)");
            }
            if (this.requiredMaterialCountOverride.isPresent() && this.requiredMaterialCountOverride.get() > 4) {
                throw new IllegalStateException("Project template material override must not be greater than 4");
            }
            if (this.requiredMaterialCountOverride.isPresent() && this.requiredMaterialCountOverride.get() <= 0) {
                throw new IllegalStateException("Project template material override must be positive");
            }
            if (this.baseSuccessChanceOverride.isPresent() && (this.baseSuccessChanceOverride.get() < 0.0 || this.baseSuccessChanceOverride.get() > 1.0)) {
                throw new IllegalStateException("Project template base success chance override must be between 0 and 1, inclusive");
            }
            if (this.rewardMultiplier <= 0.0) {
                throw new IllegalStateException("Project template reward multiplier must be positive");
            }
        }

        public ProjectTemplate build() {
            this.validate();
            return new ProjectTemplate(this.materialOptions, this.otherRewards, this.getFinalRequirement(), this.requiredMaterialCountOverride, this.baseSuccessChanceOverride, this.rewardMultiplier, this.aidBlocks, this.weightFunction);
        }
    }
}

