/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.theorycrafting.MaterialInstance;
import com.verdantartifice.primalmagick.common.theorycrafting.ProjectTemplate;
import com.verdantartifice.primalmagick.common.theorycrafting.TheorycraftSpeed;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.AbstractReward;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.mutable.MutableDouble;

public record Project(ResourceKey<ProjectTemplate> templateKey, List<MaterialInstance> activeMaterials, List<AbstractReward<?>> otherRewards, double baseSuccessChance, double baseRewardMultiplier, Optional<ResourceLocation> aidBlock) {
    public static Codec<Project> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec(RegistryKeysPM.PROJECT_TEMPLATES).fieldOf("templateKey").forGetter(Project::templateKey), (App)MaterialInstance.codec().listOf().fieldOf("activeMaterials").forGetter(Project::activeMaterials), (App)AbstractReward.dispatchCodec().listOf().fieldOf("otherRewards").forGetter(Project::otherRewards), (App)Codec.DOUBLE.fieldOf("baseSuccessChance").forGetter(Project::baseSuccessChance), (App)Codec.DOUBLE.fieldOf("baseRewardMultiplier").forGetter(Project::baseRewardMultiplier), (App)ResourceLocation.CODEC.optionalFieldOf("aidBlock").forGetter(Project::aidBlock)).apply((Applicative)instance, Project::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Project> streamCodec() {
        return StreamCodec.composite((StreamCodec)ResourceKey.streamCodec(RegistryKeysPM.PROJECT_TEMPLATES), Project::templateKey, (StreamCodec)MaterialInstance.streamCodec().apply(ByteBufCodecs.list()), Project::activeMaterials, (StreamCodec)AbstractReward.dispatchStreamCodec().apply(ByteBufCodecs.list()), Project::otherRewards, (StreamCodec)ByteBufCodecs.DOUBLE, Project::baseSuccessChance, (StreamCodec)ByteBufCodecs.DOUBLE, Project::baseRewardMultiplier, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), Project::aidBlock, Project::new);
    }

    @Nonnull
    public String getNameTranslationKey() {
        return String.join((CharSequence)".", "research_project", this.templateKey.location().getNamespace(), this.templateKey.location().getPath(), "name");
    }

    @Nonnull
    public String getTextTranslationKey() {
        return String.join((CharSequence)".", "research_project", this.templateKey.location().getNamespace(), this.templateKey.location().getPath(), "text");
    }

    protected double getSuccessChancePerMaterial() {
        int materialCount = this.activeMaterials.size();
        if (materialCount <= 0) {
            return 0.0;
        }
        return (1.0 - this.baseSuccessChance) / (double)materialCount;
    }

    public double getSuccessChance() {
        MutableDouble chance = new MutableDouble(this.baseSuccessChance);
        double per = this.getSuccessChancePerMaterial();
        this.activeMaterials().stream().filter(m -> m.isSelected()).forEach($ -> chance.add(per));
        return Mth.clamp((double)chance.doubleValue(), (double)0.0, (double)1.0);
    }

    public boolean isSatisfied(Player player, Set<Block> surroundings) {
        return !this.activeMaterials.stream().anyMatch(m -> m.isSelected() && !m.getMaterialDefinition().isSatisfied(player, surroundings));
    }

    public boolean consumeSelectedMaterials(Player player) {
        return this.activeMaterials.stream().filter(m -> m.isSelected()).allMatch(m -> m.getMaterialDefinition().consume(player));
    }

    public int getTheoryPointReward() {
        int value = (int)((double)KnowledgeType.THEORY.getProgression() * (this.baseRewardMultiplier + this.activeMaterials().stream().filter(m -> m.isSelected()).mapToDouble(m -> m.getMaterialDefinition().getBonusReward()).sum()));
        return switch (Services.CONFIG.theorycraftSpeed()) {
            case TheorycraftSpeed.SLOW -> value / 2;
            case TheorycraftSpeed.FAST -> value * 2;
            default -> value;
        };
    }

    @Nullable
    public Optional<Block> getAidBlock() {
        return this.aidBlock.map(Services.BLOCKS_REGISTRY::get);
    }
}

